﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.Fields;

namespace Mdws2ORM.Maps
{
    public class VariablePointerItemsBuilder<T> where T : class
    {

        public IEnumerable<VariablePointerFieldMap<T>.BaseItem> Items { get { return items; } }

        private List<VariablePointerFieldMap<T>.BaseItem> items = new List<VariablePointerFieldMap<T>.BaseItem>();


        public VariablePointerItemsBuilder<T> Add(string location, Action<T, string> mapAction)
        {
            items.Add(new VariablePointerFieldMap<T>.Item(location, mapAction));
            return this;
        }

        public VariablePointerItemsBuilder<T> AddFetch<V>(Action<T, string> mapAction, Action<T, V> mapPointerAction, EntityMap<V> entityMap = null)
            where V : class
        {
            items.Add(new VariablePointerFieldMap<T>.ItemFetch<V>(mapAction, mapPointerAction, entityMap));
            return this;
        }
    }
}
