﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.Fields
{
    public class PointerToFileFieldMap<T> : FieldMap<T>
        where T : class
    {

        public PointerToFileFieldMap(string field, Action<T, string> mapAction)
            : base(field, mapAction) { }

    }

    public class PointerToFileFieldMap<T, V> : BaseFieldMap<T>
        where T : class
        where V : class
    {
        private readonly Action<T, string> mapAction;
        private readonly Action<T, V> mapPointerAction;
        private EntityMap<V> entityMap;

        public bool IsFetchEnabled
        {
            get;
            set;
        }


        public PointerToFileFieldMap(string field,  Action<T, string> mapAction, Action<T, V> mapPointerAction, EntityMap<V> entityMap = null)
            : base(field)
        {
            this.mapAction = mapAction;
            this.mapPointerAction = mapPointerAction;
            this.entityMap = entityMap;
            IsFetchEnabled = true;
        }

        public override void Map(IEntityQuery query, T entity, string value)
        {
            mapAction(entity, value);
            if (IsFetchEnabled && query != null)
            {
                V referenceEntity = query.GetNotNull(entityMap, GetParamBuilder.DefaultParam, value );
                if (referenceEntity != null)
                    mapPointerAction(entity, referenceEntity);
            }
        }

        public string Location
        {
            get { return entityMap.Location; }
        }

        public override void Init(InitMapMediator initMediator)
        {
            if (entityMap == null) entityMap = initMediator.GetEntityMap<V>();
            entityMap.Initialize(initMediator);        
        }
    }
}
