﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using System.Diagnostics;
using Mdws2ORM.Maps.BaseFields;
using Mdws2ORM.Core;
using Mdws2ORM.Exceptions;
using BMS.Utils;

namespace Mdws2ORM.Impl
{
    public static class Translator
    {
        public static void PopulateFields<T>(IEntityQuery query, T entity, Entry entry, BaseFieldMap<T>[] fieldsMap) where T : class
        {
            try
            {
                if (entry.Fields == null || entry.Fields.Length == 0) return;
                if (fieldsMap == null || fieldsMap.Length == 0) return;
                if (entry.Fields.Length != fieldsMap.Length) return;
                for (int i = 0; i < fieldsMap.Length; i++)
                {                    
                    Entry.Field entryField = entry.Fields[i];                    
                    BaseFieldMap<T> fieldMap = fieldsMap[i];

                    if (entryField.FieldIen != fieldMap.Field && fieldMap.Field != "666")
                            throw new DataException(
                                string.Format("Invalid input. Field ien {0} expected, but found {1}", fieldMap.Field, entryField.FieldIen));

                        string value = entryField.Value;
                        if (!string.IsNullOrEmpty(value)) fieldMap.Map(query, entity, value);
                    
                }
            }
            catch (Exception ex)
            {
                Tracer.TraceMessage("Exception on Impl.Translator.PopulateFields - entry.File: " + entry.File + " - entry.Ien: " + entry.Ien + " T type:" + typeof(T).ToString());                
                Tracer.TraceException(ex);
            }
        }
    }
}
