﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM.Core;

namespace Mdws2ORM.Impl
{
    public class EntityMapRepository : IEntityMapRepository
    {
        private Dictionary<Type, IEntityMap> dictionary = new Dictionary<Type, IEntityMap>();

        public void Add<TMap, TEntity>()
            where TMap : BaseEntityMap<TEntity>, new()
            where TEntity : class
        {
            Add<TEntity>(new TMap());
        }

        public void Add<T>(BaseEntityMap<T> entityMap) where T : class
        {
            Type type = typeof(T);
            dictionary.Add(type, entityMap);
        }

        public BaseEntityMap<T> GetEntityMap<T>() where T : class
        {
            Type type = typeof(T);
            IEntityMap entityMap = dictionary[type];
            return entityMap as BaseEntityMap<T>;
        }

        public IEnumerable<IEntityMap> EntityMaps
        {
            get
            {
                return dictionary.Values;
            }
        }

        public IEnumerable<Type> GetTypes()
        {
            return dictionary.Keys;
        }
    }
}
