USE [BMS_DW]
GO

/****** Object:  UserDefinedFunction [dbo].[ufn_GetPatientMovementSpecialtyTransfer_TIME_ZONE_DT]    Script Date: 07/28/2015 14:57:21 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		roxanas
-- Create date: 16/07/2012
-- Description:	Function for getting the specialty transfers.
-- 
-- Change History
-- Date		Author	Description
-- 6/23/15	AKR		Modified to use Transfer Date instead of entered date for range comparison
-- =============================================
ALTER FUNCTION [dbo].[ufn_GetPatientMovementSpecialtyTransfer_TIME_ZONE] 
(
	@VISTA_SITE_ID INT, 
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@FACILITYTIMEZONE nvarchar(250)
)
RETURNS TABLE
AS
RETURN
(	
			SELECT  ST.IEN,
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](ST.DATE_TIME, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + 
						CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](ST.DATE_TIME, 'UTC',@FACILITYTIMEZONE), 108) as RECORD_DATE,
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](ST.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + 
						CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](ST.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 108) as ENTERED_DATE,
					dbo.ufn_GetDateDiff(CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](ST.DATE_TIME, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + 
						CONVERT(VARCHAR(5),[dbo].[ufn_TimezoneConversion](ST.DATE_TIME, 'UTC',@FACILITYTIMEZONE), 108),
						CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](ST.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + 
						CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion](ST.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 108)) as DIFF,	
					'' as WARD_NAME,
					'' as BED_NAME,
					PATIENT.LAST_NAME + ' ' + RIGHT(PATIENT.SSN,4) as PATIENT_NAME,
					'SPECIALTY TRANSFER' as TYPE_OF_TRANSACTION,
					MOVEMENT_TYPE.DISPLAY_NAME as TYPE_OF_MOVEMENT,
					DATEDIFF(MINUTE, [dbo].[ufn_TimezoneConversion](ST.DATE_TIME, 'UTC',@FACILITYTIMEZONE), [dbo].[ufn_TimezoneConversion](ST.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE)) AS DIFF_MINUTE
				FROM dbo.FACT_SPECIALTY_TRANSFER AS ST
					LEFT JOIN dbo.DIM_MOVEMENT_TYPE AS MOVEMENT_TYPE ON MOVEMENT_TYPE.ID = ST.DIM_MOVEMENT_TYPE_ID
					LEFT JOIN dbo.DIM_PATIENT AS PATIENT ON PATIENT.ID = ST.DIM_PATIENT_ID				
/*
				WHERE ((@END_DATE IS NULL AND ST.ENTERED_DATE >= @START_DATE) OR ST.ENTERED_DATE BETWEEN @START_DATE AND  @END_DATE)
					AND ST.VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID
*/
				WHERE ((@END_DATE IS NULL AND ST.DATE_TIME >= @START_DATE) OR ST.DATE_TIME BETWEEN @START_DATE AND  @END_DATE)
					AND ST.VISTA_SITE_DIM_ORGANIZATION_ID = @VISTA_SITE_ID
) 





GO


