USE [BMS_DW]
GO

/****** Object:  UserDefinedFunction [dbo].[ufn_GetPatientMovementAdmissionTransaction_TIME_ZONE_DT]    Script Date: 07/28/2015 14:53:07 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		Silvica Pletea
-- Create date: 30/05/2012
-- Description:	Function for getting the patient movements data (admission transaction)
-- 
-- Change History
-- Date		Author	Description
-- 6/23/15	AKR		Modified to use Admission Date instead of entered date for range comparison
-- =============================================
ALTER FUNCTION [dbo].[ufn_GetPatientMovementAdmissionTransaction_TIME_ZONE] 
(
	@FACILITY_ID INT,
	@DIVISION_ID INT, 
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@FACILITYTIMEZONE nvarchar(250)
)
RETURNS @PATIENT_MOVEMENT TABLE
(   
 	IEN INT,
	RECORD_DATE VARCHAR(30),
	ENTERED_DATE VARCHAR(30),
	DIFF VARCHAR(10),
	WARD_NAME NVARCHAR(250),
	BED_NAME NVARCHAR(250),
	PATIENT_NAME NVARCHAR(250),
	TYPE_OF_TRANSACTION NVARCHAR(50),
	TYPE_OF_MOVEMENT NVARCHAR(250),
	DIFF_MINUTE INT
)
AS
BEGIN
	
		DECLARE @WARD TABLE(ID INT PRIMARY KEY);
		
	    -- insert wards belonging to @FACILITY_ID or by	@division_id
		IF @DIVISION_ID = -1
			INSERT INTO @WARD(ID)
			SELECT WARD.ID FROM dbo.ufn_GetWardsByFacilityId(@FACILITY_ID) AS WARD
			INNER JOIN dbo.DIM_WARD AS ACTIVE_WARD ON ACTIVE_WARD.ID = WARD.ID
			WHERE ACTIVE_WARD.STATUS = 'active'
		ELSE
			INSERT INTO @WARD(ID)
			SELECT DIM_WARD_ID FROM dbo.GROUP_WARD_ORGANIZATION GWO
			WHERE DIM_ORGANIZATION_ID = @DIVISION_ID
		
		INSERT INTO @PATIENT_MOVEMENT(IEN, RECORD_DATE, ENTERED_DATE, DIFF, WARD_NAME, BED_NAME, PATIENT_NAME, TYPE_OF_TRANSACTION, TYPE_OF_MOVEMENT, DIFF_MINUTE)
			SELECT	ADMISSION.IEN,
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion](ADMISSION.ADMISSION_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion] (ADMISSION.ADMISSION_DATE, 'UTC',@FACILITYTIMEZONE), 108),
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion] (ADMISSION.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion] (ADMISSION.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 108),
					dbo.ufn_GetDateDiff(CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion] (ADMISSION.ADMISSION_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion] (ADMISSION.ADMISSION_DATE, 'UTC',@FACILITYTIMEZONE), 108),
					CONVERT(VARCHAR, [dbo].[ufn_TimezoneConversion] (ADMISSION.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 101) + ' ' + CONVERT(VARCHAR(5), [dbo].[ufn_TimezoneConversion] (ADMISSION.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE), 108)),	
					WARD.NAME,
					BED.NAME,
					PATIENT.LAST_NAME + ' ' + RIGHT(PATIENT.SSN,4),
					'ADMISSION',
					MOVEMENT_TYPE.DISPLAY_NAME,
					DATEDIFF(MINUTE, [dbo].[ufn_TimezoneConversion] (ADMISSION.ADMISSION_DATE, 'UTC',@FACILITYTIMEZONE), [dbo].[ufn_TimezoneConversion] (ADMISSION.ENTERED_DATE, 'UTC',@FACILITYTIMEZONE)) AS DIFF_MINUTE
			FROM dbo.FACT_ADMISSION_EVN AS ADMISSION
				INNER JOIN dbo.DIM_WARD AS WARD ON WARD.ID = ADMISSION.INITIAL_DIM_WARD_ID
				INNER JOIN dbo.DIM_PATIENT AS PATIENT ON PATIENT.ID = ADMISSION.DIM_PATIENT_ID
				LEFT JOIN dbo.DIM_BED AS BED ON BED.ID = ADMISSION.INITIAL_DIM_BED_ID
				LEFT JOIN dbo.DIM_MOVEMENT_TYPE AS MOVEMENT_TYPE ON MOVEMENT_TYPE.ID = ADMISSION.DIM_MOVEMENT_TYPE_ID
/*
    		WHERE ((@END_DATE IS NULL AND ADMISSION.ENTERED_DATE >= @START_DATE AND ADMISSION.ADMISSION_DATE >=@START_DATE) 
				   OR (ADMISSION.ENTERED_DATE BETWEEN @START_DATE AND @END_DATE AND ADMISSION.ADMISSION_DATE BETWEEN @START_DATE AND  @END_DATE))
				   AND ADMISSION.INITIAL_DIM_WARD_ID IN (SELECT ID FROM @WARD)
*/
    		WHERE ((@END_DATE IS NULL AND ADMISSION.ADMISSION_DATE >=@START_DATE) 
				   OR (ADMISSION.ADMISSION_DATE BETWEEN @START_DATE AND  @END_DATE))
				   AND ADMISSION.INITIAL_DIM_WARD_ID IN (SELECT ID FROM @WARD)
	
	RETURN 
END






GO


