-- Columns

CREATE TABLE [dbo].[PATIENT]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[WARD_LOCATION_ID] [int] NULL,
[ROOM_BED_ID] [int] NULL,
[SEX] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[TREATING_SPECIALTY_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SOCIAL_SECURITY_NUMBER] [nvarchar] (500) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CURRENT_MOVEMENT_ID] [int] NULL,
[CURRENT_ADMISSION_ID] [int] NULL,
[DATE_OF_BIRTH] [datetime] NOT NULL,
[MARITAL_STATUS_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MARITAL_STATUS_ID] [int] NULL,
[NAME1U4N] [nvarchar] (10) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TREATING_SPECIALTY_ID] [int] NULL,
[ADMITTING_DIAGNOSIS] [nvarchar](500) NULL,
[SERVICE_CONNECTED_PERCENTAGE] [int] NULL,
[ATTENDING_PHYSICIAN_ID] [int] null
)
GO
-- Triggers

CREATE TRIGGER [dbo].[PATIENT_tgg_delete]
   ON  [dbo].[PATIENT]
   AFTER DELETE
AS 
BEGIN	
	INSERT INTO [dbo].[PATIENT_LOG]([ACTION],  IEN, NAME, WARD_LOCATION_ID, ROOM_BED_ID, SEX, TREATING_SPECIALTY_NAME, SOCIAL_SECURITY_NUMBER, CURRENT_MOVEMENT_ID, CURRENT_ADMISSION_ID, DATE_OF_BIRTH, MARITAL_STATUS_NAME, MARITAL_STATUS_ID, NAME1U4N, TREATING_SPECIALTY_ID, ADMITTING_DIAGNOSIS, SERVICE_CONNECTED_PERCENTAGE, ATTENDING_PHYSICIAN_ID)
	SELECT 'D', IEN, NAME, WARD_LOCATION_ID, ROOM_BED_ID, SEX, TREATING_SPECIALTY_NAME, SOCIAL_SECURITY_NUMBER, CURRENT_MOVEMENT_ID, CURRENT_ADMISSION_ID, DATE_OF_BIRTH, MARITAL_STATUS_NAME, MARITAL_STATUS_ID, NAME1U4N, TREATING_SPECIALTY_ID, ADMITTING_DIAGNOSIS, SERVICE_CONNECTED_PERCENTAGE, ATTENDING_PHYSICIAN_ID FROM deleted;
END
GO

CREATE TRIGGER [dbo].[PATIENT_tgg_insert]
   ON  [dbo].[PATIENT]
   AFTER INSERT
AS 
BEGIN	
	INSERT INTO [dbo].[PATIENT_LOG]([ACTION],  IEN, NAME, WARD_LOCATION_ID, ROOM_BED_ID, SEX, TREATING_SPECIALTY_NAME, SOCIAL_SECURITY_NUMBER, CURRENT_MOVEMENT_ID, CURRENT_ADMISSION_ID, DATE_OF_BIRTH, MARITAL_STATUS_NAME, MARITAL_STATUS_ID, NAME1U4N, TREATING_SPECIALTY_ID, ADMITTING_DIAGNOSIS, SERVICE_CONNECTED_PERCENTAGE, ATTENDING_PHYSICIAN_ID)
	SELECT 'I', IEN, NAME, WARD_LOCATION_ID, ROOM_BED_ID, SEX, TREATING_SPECIALTY_NAME, SOCIAL_SECURITY_NUMBER, CURRENT_MOVEMENT_ID, CURRENT_ADMISSION_ID, DATE_OF_BIRTH, MARITAL_STATUS_NAME, MARITAL_STATUS_ID, NAME1U4N, TREATING_SPECIALTY_ID, ADMITTING_DIAGNOSIS, SERVICE_CONNECTED_PERCENTAGE, ATTENDING_PHYSICIAN_ID FROM inserted;
END
GO

CREATE TRIGGER [dbo].[PATIENT_tgg_update]
   ON  [dbo].[PATIENT]
   AFTER UPDATE
AS 
BEGIN	
	INSERT INTO [dbo].[PATIENT_LOG]([ACTION],  IEN, NAME, WARD_LOCATION_ID, ROOM_BED_ID, SEX, TREATING_SPECIALTY_NAME, SOCIAL_SECURITY_NUMBER, CURRENT_MOVEMENT_ID, CURRENT_ADMISSION_ID, DATE_OF_BIRTH, MARITAL_STATUS_NAME, MARITAL_STATUS_ID, NAME1U4N, TREATING_SPECIALTY_ID, ADMITTING_DIAGNOSIS, SERVICE_CONNECTED_PERCENTAGE, ATTENDING_PHYSICIAN_ID)
	SELECT 'U', IEN, NAME, WARD_LOCATION_ID, ROOM_BED_ID, SEX, TREATING_SPECIALTY_NAME, SOCIAL_SECURITY_NUMBER, CURRENT_MOVEMENT_ID, CURRENT_ADMISSION_ID, DATE_OF_BIRTH, MARITAL_STATUS_NAME, MARITAL_STATUS_ID, NAME1U4N, TREATING_SPECIALTY_ID, ADMITTING_DIAGNOSIS, SERVICE_CONNECTED_PERCENTAGE, ATTENDING_PHYSICIAN_ID FROM inserted;
END
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[PATIENT] ADD CONSTRAINT [PK_PATIENT] PRIMARY KEY CLUSTERED  ([IEN])
GO
-- Foreign Keys

ALTER TABLE [dbo].[PATIENT] ADD CONSTRAINT [FK_PATIENT_MARITAL_STATUS] FOREIGN KEY ([MARITAL_STATUS_ID]) REFERENCES [dbo].[MARITAL_STATUS] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT] ADD CONSTRAINT [FK_PATIENT_ROOM_BED] FOREIGN KEY ([ROOM_BED_ID]) REFERENCES [dbo].[ROOM_BED] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT] ADD CONSTRAINT [FK_PATIENT_FAC_TREAT_SPECIALTY] FOREIGN KEY ([TREATING_SPECIALTY_ID]) REFERENCES [dbo].[FAC_TREAT_SPECIALTY] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT] ADD CONSTRAINT [FK_PATIENT_WARD_LOCATION] FOREIGN KEY ([WARD_LOCATION_ID]) REFERENCES [dbo].[WARD_LOCATION] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT] ADD CONSTRAINT [FK_PATIENT_ATTENDING_PHYSICIAN] FOREIGN KEY ([ATTENDING_PHYSICIAN_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'Table that contains patient data.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the patient''s current admission.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'CURRENT_ADMISSION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the patient''s current movement.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'CURRENT_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s birth date.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'DATE_OF_BIRTH'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s marital status id.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'MARITAL_STATUS_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s marital status name.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'MARITAL_STATUS_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Column containing first letter of the patient''s name and the last 4 SSN digits.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'NAME1U4N'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Column containing bed id.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'ROOM_BED_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The sex of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'SEX'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s SSN.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'SOCIAL_SECURITY_NUMBER'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the treating specialty.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'TREATING_SPECIALTY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the treating specialty.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'TREATING_SPECIALTY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the ward location.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'WARD_LOCATION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the attending physician.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT', 'COLUMN', N'ATTENDING_PHYSICIAN_ID'
GO