CREATE TABLE [dbo].[ORDERABLE_ITEM]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[INACTIVATED] [bit] NOT NULL CONSTRAINT [DF_ORDERABLE_ITEM_Inactivated] DEFAULT ((0)),
[PACKAGE_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DISPLAY_GROUP_ID] [int] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO


CREATE TRIGGER [dbo].[ORDERABLE_ITEM_tgg_delete]
   ON  [dbo].[ORDERABLE_ITEM]
   AFTER delete
AS 
BEGIN	
		insert into [dbo].[ORDERABLE_ITEM_LOG]([ACTION], IEN, NAME, INACTIVATED, PACKAGE_NAME, DISPLAY_GROUP_ID)
		select 'D', IEN, NAME, INACTIVATED, PACKAGE_NAME, DISPLAY_GROUP_ID from deleted;
END

GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[ORDERABLE_ITEM_tgg_insert]
   ON  [dbo].[ORDERABLE_ITEM]
   AFTER INSERT
AS 
BEGIN	
		insert into [dbo].[ORDERABLE_ITEM_LOG]([ACTION], IEN, NAME, INACTIVATED, PACKAGE_NAME, DISPLAY_GROUP_ID)
		select 'I', IEN, NAME, INACTIVATED, PACKAGE_NAME, DISPLAY_GROUP_ID from inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO


CREATE TRIGGER [dbo].[ORDERABLE_ITEM_tgg_update]
   ON  [dbo].[ORDERABLE_ITEM]
   AFTER Update
AS 
BEGIN	
		insert into [dbo].[ORDERABLE_ITEM_LOG]([ACTION], IEN, NAME, INACTIVATED, PACKAGE_NAME, DISPLAY_GROUP_ID)
		select 'U', IEN, NAME, INACTIVATED, PACKAGE_NAME, DISPLAY_GROUP_ID from inserted;
END

GO
ALTER TABLE [dbo].[ORDERABLE_ITEM] ADD CONSTRAINT [PK_ORDERABLE_ITEM] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ORDERABLE_ITEM] ADD CONSTRAINT [FK_ORDERABLE_ITEM_DISPLAY_GROUP] FOREIGN KEY ([DISPLAY_GROUP_ID]) REFERENCES [dbo].[DISPLAY_GROUP] ([IEN])
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains orderable items.', 'SCHEMA', N'dbo', 'TABLE', N'ORDERABLE_ITEM', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the display group.', 'SCHEMA', N'dbo', 'TABLE', N'ORDERABLE_ITEM', 'COLUMN', N'DISPLAY_GROUP_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The unique identifier of an orderable item.', 'SCHEMA', N'dbo', 'TABLE', N'ORDERABLE_ITEM', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'True/False column for specifying that the orderable item is inactivated or not.', 'SCHEMA', N'dbo', 'TABLE', N'ORDERABLE_ITEM', 'COLUMN', N'INACTIVATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the orderable item.', 'SCHEMA', N'dbo', 'TABLE', N'ORDERABLE_ITEM', 'COLUMN', N'NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the package.', 'SCHEMA', N'dbo', 'TABLE', N'ORDERABLE_ITEM', 'COLUMN', N'PACKAGE_NAME'
GO
