CREATE TABLE [dbo].[HOSPITAL_LOCATION_APPOINTMENT_H](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ID] [int] NOT NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[HOSPITAL_LOCATION_UID] [uniqueidentifier] NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NOT NULL,
	[TRANSACTION_TYPE_CODE] [varchar](50) NOT NULL,
	[DATE] [datetime] NOT NULL,
	[CREATED_BY] [nvarchar](50) NULL
)
GO
-- Constraints and Indexes
ALTER TABLE [dbo].[HOSPITAL_LOCATION_APPOINTMENT_H] ADD CONSTRAINT [PK_HOSPITAL_LOCATION_APPOINTMENT_H] PRIMARY KEY CLUSTERED  ([PK])
GO

-- Extended Properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Code of transaction(I = Inserted, U = Updated, D = Deleted).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'HOSPITAL_LOCATION_APPOINTMENT_H', @level2type=N'COLUMN',@level2name=N'TRANSACTION_TYPE_CODE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Datetime when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'HOSPITAL_LOCATION_APPOINTMENT_H', @level2type=N'COLUMN',@level2name=N'DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User ID of user when record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'HOSPITAL_LOCATION_APPOINTMENT_H', @level2type=N'COLUMN',@level2name=N'CREATED_BY'
GO