CREATE TABLE [dbo].[CONFIG_EVS_H]
(
[PK] [int] NOT NULL IDENTITY(1, 1),
[ID] [int] NOT NULL,
[CONFIG_ID] [int] NOT NULL,
[CODE] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM_NAME] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DISPLAY_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[TRANSACTION_TYPE_CODE] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DATE] [datetime] NOT NULL,
[CREATED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[CONFIG_EVS_H] ADD CONSTRAINT [PK_CONFIG_EVS_H] PRIMARY KEY CLUSTERED  ([PK]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Configuration table for vocabularies.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s code.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s code system.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'CODE_SYSTEM'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s code system name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'CODE_SYSTEM_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Parent configuration''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'CONFIG_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'CREATED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s display name.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'DISPLAY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Vocabulary''s configuration id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Primary key.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'PK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Code of transaction(I = Inserted, U = Updated, D = Deleted).', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EVS_H', 'COLUMN', N'TRANSACTION_TYPE_CODE'
GO
