IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ETL_Full_Insert_Dim_Icon_Flag_Facility]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ETL_Full_Insert_Dim_Icon_Flag_Facility]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[usp_ETL_Full_Insert_Dim_Icon_Flag_Facility]
@END_DATE DATETIME, @SOURCE_DB NVARCHAR(250)
AS
BEGIN
SET NOCOUNT ON;

BEGIN TRY
	
	DECLARE @SQL VARCHAR(max), @FROM_CLAUSE NVARCHAR(MAX), @INDEX INT, @ROWS INT, @START_DATE DATETIME	
	
	--DROP TABLE DIM_ICON_FLAG_FACILITY_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_FACILITY_ETL]'))
	BEGIN
		DROP TABLE DIM_ICON_FLAG_FACILITY_ETL
	END
	
	--DISABLE INDEXES
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' DISABLE;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'DIM_ICON_FLAG_FACILITY';	
	EXEC (@SQL)
	
	SET @START_DATE = '1900-01-01'	
	SET @INDEX = CHARINDEX('.', @SOURCE_DB)	
		
	IF @INDEX = 0
		SET @FROM_CLAUSE = @SOURCE_DB + '.[dbo].[ufn_ETL_Dim_Icon_Flag_Facility](''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''', ''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''')'
	ELSE
		SET @FROM_CLAUSE = 'OPENQUERY( ' + SUBSTRING(@SOURCE_DB, 0, @INDEX) + ', ''SELECT * FROM ' + SUBSTRING(@SOURCE_DB, @INDEX + 1, LEN(@SOURCE_DB)) + 
					'.[dbo].[ufn_ETL_Dim_Icon_Flag_Facility](''''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''''', ''''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''''') '')'
		
	SET @SQL = ''
	SET @SQL = @SQL +
		'SELECT [ICON_FLAG_ID]
			   ,[FACILITY_UID]
			   ,[ORDER_INDEX]
			   ,[ACTIVE]
			   ,[PATIENT_OR_ROOMBED]
			   ,[ICON_NAME]
			   ,[DESCRIPTION]
			   ,[COMMENT]
			   ,[MOUSE_OVER_TEXT]
			   ,[ENTERED_BY]
			   ,[ENTERED_DATE]
			   ,[LAST_EDIT_BY]
			   ,[LAST_EDIT_DATE]
			   ,[SOURCE_ID]
			   ,[_SSIS_TIMESTAMP]
		INTO DIM_ICON_FLAG_FACILITY_ETL
		FROM ' + @FROM_CLAUSE
	EXEC (@SQL)
	
	SET @ROWS = @@ROWCOUNT
	
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_FACILITY_ETL]'))
	BEGIN
		--ADDED INDEXES ON TABLE DIM_ICON_FLAG_FACILITY_ETL
		CREATE NONCLUSTERED INDEX [idx_ICON_FLAG_ID] ON DIM_ICON_FLAG_FACILITY_ETL(ICON_FLAG_ID ASC)
		CREATE NONCLUSTERED INDEX [idx_FACILITY_UID] ON DIM_ICON_FLAG_FACILITY_ETL(FACILITY_UID ASC)
		CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON DIM_ICON_FLAG_FACILITY_ETL(SOURCE_ID ASC)
 
		INSERT INTO [DIM_ICON_FLAG_FACILITY]
			   ([DIM_ICON_FLAG_ID]
			   ,[DIM_ORGANIZATION_FACILITY_ID]
			   ,[ORDER_INDEX]
			   ,[ACTIVE]
			   ,[PATIENT_OR_ROOMBED]
			   ,[ICON_NAME]
			   ,[DESCRIPTION]
			   ,[COMMENT]
			   ,[MOUSE_OVER_TEXT]
			   ,[ENTERED_BY]
			   ,[ENTERED_DATE]
			   ,[LAST_EDIT_BY]
			   ,[LAST_EDIT_DATE]
			   ,[SOURCE_ID]
			   ,[_SSIS_TIMESTAMP])
		 SELECT dif.ID
			   ,FACILITY.ID
			   ,diffi.[ORDER_INDEX]
			   ,diffi.[ACTIVE]
			   ,diffi.[PATIENT_OR_ROOMBED]
			   ,diffi.[ICON_NAME]
			   ,[DESCRIPTION]
			   ,diffi.[COMMENT]
			   ,diffi.[MOUSE_OVER_TEXT]
			   ,diffi.[ENTERED_BY]
			   ,diffi.[ENTERED_DATE]
			   ,diffi.[LAST_EDIT_BY]
			   ,diffi.[LAST_EDIT_DATE]
			   ,diffi.[SOURCE_ID]
			   ,diffi.[_SSIS_TIMESTAMP]
		FROM DIM_ICON_FLAG_FACILITY_ETL diffi 
				LEFT JOIN [DIM_ICON_FLAG] dif ON dif.source_id = diffi.[ICON_FLAG_ID]
				LEFT JOIN DIM_ORGANIZATION FACILITY ON FACILITY.SOURCE_ID = diffi.[FACILITY_UID]
	END
	
	--REBUILD INDEXES ON TABLE DIM_ICON_FLAG_FACILITY
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' REBUILD;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'DIM_ICON_FLAG_FACILITY';
	EXEC (@SQL)
	
	--TRUNCATE TABLE DIM_ICON_FLAG_FACILITY_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DIM_ICON_FLAG_FACILITY_ETL]'))
	BEGIN
		TRUNCATE TABLE DIM_ICON_FLAG_FACILITY_ETL
	END
	
	RETURN @ROWS
	
END TRY
BEGIN CATCH
	
	DECLARE @ErrorMessage NVARCHAR(4000), @ErrorSeverity INT, @ErrorState INT;
			
	SELECT @ErrorMessage = '*** ERROR in usp_ETL_Full_Insert_Dim_Icon_Flag_Facility: ' + ERROR_MESSAGE(),
		   @ErrorSeverity = ERROR_SEVERITY(),
		   @ErrorState = ERROR_STATE();
	
	RAISERROR (@ErrorMessage,  @ErrorSeverity, @ErrorState) WITH LOG;
	
	--ENABLED INDEX
	SET @SQL = ''
	SELECT @SQL =@SQL + 'ALTER INDEX ' + ind.name + ' ON  ' + obj.name + ' REBUILD;' +CHAR(13)+CHAR(10)
	FROM 
		sys.indexes as ind
	JOIN 
		sys.objects  as obj
		ON ind.object_id = obj.object_id
	WHERE  ind.type_desc = 'NONCLUSTERED' and obj.name = 'DIM_ICON_FLAG_FACILITY';
	EXEC (@SQL)
	
END CATCH	

END

GO


