CREATE TABLE [dbo].[VISTA_OPERATIONS](
	[VISTA_ID] [nvarchar](100) NOT NULL,
	[OPERATION_ID] [int] NOT NULL,
	[LAST_RUNNING] [datetime] NULL,
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[COUNTER_FAILED] [int] NULL,
 CONSTRAINT [PK_VISTA_OPERATIONS_1] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista identifier.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_OPERATIONS', @level2type=N'COLUMN',@level2name=N'VISTA_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The VistA operation identifier.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_OPERATIONS', @level2type=N'COLUMN',@level2name=N'OPERATION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the operation last run.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_OPERATIONS', @level2type=N'COLUMN',@level2name=N'LAST_RUNNING'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_OPERATIONS', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores a history of the executed operations on each VistA.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VISTA_OPERATIONS'
GO

ALTER TABLE [dbo].[VISTA_OPERATIONS] ADD  CONSTRAINT [DF_VISTA_OPERATIONS_COUNTER_FAILED]  DEFAULT ((0)) FOR [COUNTER_FAILED]
GO
