CREATE TABLE [dbo].[LOGGED_USER]
(
	[SESSION_ID] [nvarchar](150) NOT NULL,
	[USER_NAME] [nvarchar](250) NOT NULL,
	[FACILITY_UID] [uniqueidentifier] NOT NULL,
	[VISN_UID] [uniqueidentifier] NOT NULL,
	[CREATION_DATE] [datetime] NOT NULL CONSTRAINT [DF_LOGGED_USER_CREATION_DATE]  DEFAULT (getutcdate())
)
GO

--Constraints
ALTER TABLE [dbo].[LOGGED_USER] ADD CONSTRAINT [PK_LOGGED_USER] PRIMARY KEY CLUSTERED  ([SESSION_ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_FACILITY_VISN] ON [dbo].[LOGGED_USER] 
(
	[FACILITY_UID] ASC,
	[VISN_UID] ASC
)
INCLUDE ( [SESSION_ID],
[USER_NAME]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the application session.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'LOGGED_USER', @level2type=N'COLUMN',@level2name=N'SESSION_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the logged user.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'LOGGED_USER', @level2type=N'COLUMN',@level2name=N'USER_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the facility the user logged in to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'LOGGED_USER', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the facility''s visn.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'LOGGED_USER', @level2type=N'COLUMN',@level2name=N'VISN_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the user last logged in.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'LOGGED_USER', @level2type=N'COLUMN',@level2name=N'CREATION_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores the logged users, the session id and the facility they logged in to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'LOGGED_USER'
GO