-- Columns

CREATE TABLE [dbo].[ICON_FLAG]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[GROUP] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[SUBGROUP] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ICON_TYPE_ID] [int] NULL,
[IMAGE_BYTES] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IMAGE_BYTES_INACTIVE] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ORDER_INDEX] [int] NOT NULL,
[ACTIVE] [bit] NOT NULL,
[PUBLISHED] [bit] NULL,
[PATIENT_OR_ROOMBED] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IMAGE_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ICON_NAME] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[SHORT_DESCRIPTION] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LONG_DESCRIPTION] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COMMENT] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[MOUSE_OVER_TEXT] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ENTERED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[ENTERED_DATE] [datetime] NULL CONSTRAINT [DF_ICON_FLAG_ENTERED_DATE] DEFAULT (getutcdate()),
[LAST_EDIT_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[LAST_EDIT_DATE] [datetime] NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_ICON_FLAG__ssis_timestamp] DEFAULT (getdate())
)
GO
-- Triggers

CREATE trigger [dbo].[ICON_FLAG_tgg_ssis_delete] on [dbo].[ICON_FLAG] after delete as begin  delete [dbo].[ICON_FLAG_ssisdel] from [deleted] _xyz where [dbo].[ICON_FLAG_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[ICON_FLAG_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end

GO

CREATE trigger [dbo].[ICON_FLAG_tgg_ssis_insert] on [dbo].[ICON_FLAG] after insert as begin delete [dbo].[ICON_FLAG_ssisdel]  from [inserted] _xyz where [dbo].[ICON_FLAG_ssisdel].[ID]=[_xyz].[ID] end

GO



CREATE TRIGGER [dbo].[utg_ICON_FLAG_AfterDelete] 
   ON  [dbo].[ICON_FLAG]
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')    
		INSERT INTO $(varBMS_HISTORY).[dbo].[ICON_FLAG_H]
			(ID, [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
			ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
			TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
				ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
				'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM deleted;

END

SET ANSI_NULLS ON

GO

CREATE TRIGGER [dbo].[utg_ICON_FLAG_AfterInsert] 
   ON  [dbo].[ICON_FLAG] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ICON_FLAG_H]
			(ID, [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
			ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
			TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
				ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
				'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;


END

SET ANSI_NULLS ON

GO

CREATE TRIGGER [dbo].[utg_ICON_FLAG_AfterUpdate] 
   ON  [dbo].[ICON_FLAG] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ICON_FLAG_H]
			(ID, [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
			ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
			TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
				ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
				'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;

END

SET ANSI_NULLS ON

GO

CREATE TRIGGER [dbo].[utg_ICON_FLAG_InsteadOfInsert] 
   ON  [dbo].[ICON_FLAG]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[ICON_FLAG]
			([GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
			ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
			_ssis_timestamp, CREATED, CREATEDBY)
		SELECT  [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
				ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
				_ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
		FROM inserted;

	ELSE
		INSERT INTO [dbo].[ICON_FLAG]
			([GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
			ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
			_ssis_timestamp)
		SELECT  [GROUP], SUBGROUP, ICON_TYPE_ID, IMAGE_BYTES, IMAGE_BYTES_INACTIVE, ORDER_INDEX, ACTIVE, PUBLISHED, PATIENT_OR_ROOMBED, IMAGE_NAME, 
				ICON_NAME, SHORT_DESCRIPTION, LONG_DESCRIPTION, COMMENT, MOUSE_OVER_TEXT, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, LAST_EDIT_DATE, 
				_ssis_timestamp
		FROM inserted;

END

SET ANSI_NULLS ON

GO

CREATE TRIGGER [dbo].[utg_ICON_FLAG_InsteadOfUpdate] 
   ON  [dbo].[ICON_FLAG] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[ICON_FLAG]
		SET [GROUP] = inserted.[GROUP], 
			SUBGROUP = inserted.SUBGROUP, 
			ICON_TYPE_ID = inserted.ICON_TYPE_ID, 
			IMAGE_BYTES = inserted.IMAGE_BYTES, 
			IMAGE_BYTES_INACTIVE = inserted.IMAGE_BYTES_INACTIVE, 
			ORDER_INDEX = inserted.ORDER_INDEX, 
			ACTIVE = inserted.ACTIVE, 
			PUBLISHED = inserted.PUBLISHED, 
			PATIENT_OR_ROOMBED = inserted.PATIENT_OR_ROOMBED, 
			IMAGE_NAME = inserted.IMAGE_NAME, 
			ICON_NAME = inserted.ICON_NAME, 
			SHORT_DESCRIPTION = inserted.SHORT_DESCRIPTION, 
			LONG_DESCRIPTION = inserted.LONG_DESCRIPTION, 
			COMMENT = inserted.COMMENT, 
			MOUSE_OVER_TEXT = inserted.MOUSE_OVER_TEXT, 
			ENTERED_BY = inserted.ENTERED_BY, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			LAST_EDIT_BY = inserted.LAST_EDIT_BY, 
			LAST_EDIT_DATE = inserted.LAST_EDIT_DATE,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[ICON_FLAG]
			INNER JOIN inserted ON inserted.ID = [dbo].[ICON_FLAG].ID;
	 ELSE
	    UPDATE [dbo].[ICON_FLAG]
		SET [GROUP] = inserted.[GROUP], 
			SUBGROUP = inserted.SUBGROUP, 
			ICON_TYPE_ID = inserted.ICON_TYPE_ID, 
			IMAGE_BYTES = inserted.IMAGE_BYTES, 
			IMAGE_BYTES_INACTIVE = inserted.IMAGE_BYTES_INACTIVE, 
			ORDER_INDEX = inserted.ORDER_INDEX, 
			ACTIVE = inserted.ACTIVE, 
			PUBLISHED = inserted.PUBLISHED, 
			PATIENT_OR_ROOMBED = inserted.PATIENT_OR_ROOMBED, 
			IMAGE_NAME = inserted.IMAGE_NAME, 
			ICON_NAME = inserted.ICON_NAME, 
			SHORT_DESCRIPTION = inserted.SHORT_DESCRIPTION, 
			LONG_DESCRIPTION = inserted.LONG_DESCRIPTION, 
			COMMENT = inserted.COMMENT, 
			MOUSE_OVER_TEXT = inserted.MOUSE_OVER_TEXT, 
			ENTERED_BY = inserted.ENTERED_BY, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			LAST_EDIT_BY = inserted.LAST_EDIT_BY, 
			LAST_EDIT_DATE = inserted.LAST_EDIT_DATE,
			_ssis_timestamp = current_timestamp
		FROM [dbo].[ICON_FLAG]
			INNER JOIN inserted ON inserted.ID = [dbo].[ICON_FLAG].ID;

END

GO

-- Constraints
ALTER TABLE [dbo].[ICON_FLAG] ADD CONSTRAINT [PK_ICON_FLAG] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[ICON_FLAG] ADD CONSTRAINT [FK_ICON_FLAG_CONCEPT_ICON_TYPE] FOREIGN KEY ([ICON_TYPE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_SUBGRUP_AND_INCLUDED] ON [dbo].[ICON_FLAG] 
(
	[SUBGROUP] ASC
)
INCLUDE ( [ID],
[GROUP],
[IMAGE_BYTES],
[IMAGE_BYTES_INACTIVE],
[ORDER_INDEX],
[ACTIVE],
[PUBLISHED],
[PATIENT_OR_ROOMBED],
[IMAGE_NAME],
[ICON_NAME],
[SHORT_DESCRIPTION],
[MOUSE_OVER_TEXT]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The group or category the icon belongs to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'GROUP'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The subgroup or subcategory the icon belongs to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'SUBGROUP'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the icon type.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ICON_TYPE_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The bytes array of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'IMAGE_BYTES'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The bytes array of the icon when it is inactive.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'IMAGE_BYTES_INACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order of the icons on the screen per subgroup.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ORDER_INDEX'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/False flag for an active/inactive icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ACTIVE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The type of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'PATIENT_OR_ROOMBED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The image name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'IMAGE_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ICON_NAME'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A short description of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'SHORT_DESCRIPTION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A long description of the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'LONG_DESCRIPTION'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text comment appropriate for the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'COMMENT'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A free text to show on the top of the icon (hover text).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'MOUSE_OVER_TEXT'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who inserted the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ENTERED_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The icon inserted datetime.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'ENTERED_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the icon.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the icon was last edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_DATE'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores definitions of icons.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'True/False flag to express if the icon is published or not in BMS application.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ICON_FLAG', @level2type=N'COLUMN',@level2name=N'PUBLISHED'
GO