CREATE TABLE [dbo].[BED_SWITCH]
(
	[ID] [int] NOT NULL IDENTITY(1, 1),
	[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[PATIENT_UID] [uniqueidentifier] NOT NULL,
	[ENTERED_DATE] [datetime] NOT NULL,
	[WARD_UID] [uniqueidentifier] NULL,
	[BED_UID] [uniqueidentifier] NULL,
	[OLD_BED_UID] [uniqueidentifier] NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[ADMISSION_ID] [int] NULL,
	[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_BED_SWITCH__ssis_timestamp] DEFAULT (getdate()),
	[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[UPDATED] [datetime] NULL,
	[CREATION_UTC_DATE] DATETIME NOT NULL CONSTRAINT [DF_BED_SWITCH__CREATION_UTC_DATE] DEFAULT (getutcdate())
) 
GO
CREATE trigger [dbo].[BED_SWITCH_tgg_ssis_delete] on [dbo].[BED_SWITCH] after delete as begin  delete [dbo].[BED_SWITCH_ssisdel] from [deleted] _xyz where [dbo].[BED_SWITCH_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[BED_SWITCH_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO

CREATE trigger [dbo].[BED_SWITCH_tgg_ssis_insert] on [dbo].[BED_SWITCH] after insert as begin delete [dbo].[BED_SWITCH_ssisdel]  from [inserted] _xyz where [dbo].[BED_SWITCH_ssisdel].[ID]=[_xyz].[ID] end
GO

CREATE TRIGGER [dbo].[utg_BED_SWITCH_AfterDelete] 
   ON  [dbo].[BED_SWITCH] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[BED_SWITCH_H]
				(ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
END

GO
CREATE TRIGGER [dbo].[utg_BED_SWITCH_AfterInsert] 
   ON  [dbo].[BED_SWITCH] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[BED_SWITCH_H]
		   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END

GO
CREATE TRIGGER [dbo].[utg_BED_SWITCH_AfterUpdate] 
   ON  [dbo].[BED_SWITCH] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[BED_SWITCH_H]
			(ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO
CREATE TRIGGER [dbo].[utg_BED_SWITCH_InsteadOfInsert] 
   ON  [dbo].[BED_SWITCH]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[BED_SWITCH]
			   (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	ELSE
		INSERT INTO [dbo].[BED_SWITCH]
			    (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, _ssis_timestamp)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, OLD_BED_UID, VISTA_SITE_UID, ADMISSION_ID, _ssis_timestamp
			  FROM inserted;
END
GO
CREATE TRIGGER [dbo].[utg_BED_SWITCH_InsteadOfUpdate] 
   ON  [dbo].[BED_SWITCH] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[BED_SWITCH]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,
			WARD_UID = inserted.WARD_UID,
			BED_UID = inserted.BED_UID,
			OLD_BED_UID = inserted.OLD_BED_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[BED_SWITCH]
			INNER JOIN inserted ON inserted.id = [dbo].[BED_SWITCH].id;
	 ELSE
	    UPDATE [dbo].[BED_SWITCH]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE, 
			WARD_UID = inserted.WARD_UID,
			BED_UID = inserted.BED_UID,
			OLD_BED_UID = inserted.OLD_BED_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[BED_SWITCH]
			INNER JOIN inserted ON inserted.id = [dbo].[BED_SWITCH].id;
END
GO
-- Constraints and Indexes
ALTER TABLE [dbo].[BED_SWITCH] ADD CONSTRAINT [PK_BED_SWITCH] PRIMARY KEY CLUSTERED  ([ID])
GO
ALTER TABLE [dbo].[BED_SWITCH] ADD CONSTRAINT [FK_BED_SWITCH_ADMISSION_EVN_ADMISSION] FOREIGN KEY([ADMISSION_ID]) REFERENCES [dbo].[ADMISSION_EVN] ([ID])
GO
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_SWITCH] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed switch.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the ward.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'WARD_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the new bed.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'BED_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the old bed.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'OLD_BED_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The id of the vista site.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'VISTA_SITE_UID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user when the record was updated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was edited.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores acts of bed switch.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'BED_SWITCH'
GO