CREATE TABLE [dbo].[DISCHARGE_EVN]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_UID] [UNIQUEIDENTIFIER] NOT NULL,
[ENTERED_DATE] DATETIME NOT NULL,
[WARD_UID] [uniqueidentifier] NULL,
[BED_UID] [uniqueidentifier] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[DISCHARGED_DATE] [datetime] NULL,
[ENTERED_BY_UID] [uniqueidentifier] NULL,
[TYPE_OF_MOVEMENT_ID] [int] NULL,
[ADMISSION_ID] [int] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__DISCHARGE___ssis__3508D0F3] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[CREATION_UTC_DATE] DATETIME NOT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE trigger [dbo].[DISCHARGE_EVN_tgg_ssis_delete] on [dbo].[DISCHARGE_EVN] after delete as begin  delete [dbo].[DISCHARGE_EVN_ssisdel] from [deleted] _xyz where [dbo].[DISCHARGE_EVN_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[DISCHARGE_EVN_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE trigger [dbo].[DISCHARGE_EVN_tgg_ssis_insert] on [dbo].[DISCHARGE_EVN] after insert as begin delete [dbo].[DISCHARGE_EVN_ssisdel]  from [inserted] _xyz where [dbo].[DISCHARGE_EVN_ssisdel].[ID]=[_xyz].[ID] end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Evn_AfterDelete] 
   ON  [dbo].[DISCHARGE_EVN] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Discharge_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Evn_AfterInsert] 
   ON  [dbo].[DISCHARGE_EVN] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
    	INSERT INTO $(varBMS_HISTORY).[dbo].[Discharge_Evn_H]
			    (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Discharge_Evn_AfterUpdate] 
   ON  [dbo].[DISCHARGE_EVN] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[Discharge_Evn_H]
			   (ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()  
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Discharge_Evn_InsteadOfInsert] 
   ON  [dbo].[DISCHARGE_EVN]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[Discharge_Evn]
			    (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;	    	 
	ELSE
		INSERT INTO [dbo].[Discharge_Evn]
			    (DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, _ssis_timestamp)
			SELECT DOMAIN_ID, IEN, PATIENT_UID, ENTERED_DATE, CREATION_UTC_DATE, WARD_UID, BED_UID, VISTA_SITE_UID, DISCHARGED_DATE, ENTERED_BY_UID, TYPE_OF_MOVEMENT_ID, ADMISSION_ID, _ssis_timestamp
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Discharge_Evn_InsteadOfUpdate] 
   ON  [dbo].[DISCHARGE_EVN] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Discharge_Evn]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE, 
			WARD_UID = inserted.WARD_UID,
			BED_UID = inserted.BED_UID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			DISCHARGED_DATE = inserted.DISCHARGED_DATE,
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Discharge_Evn]
		INNER JOIN inserted ON inserted.id = [dbo].[Discharge_Evn].id; 	 
	 ELSE
	    UPDATE [dbo].[Discharge_Evn]
		SET DOMAIN_ID = inserted.DOMAIN_ID, 
			IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE,  
			WARD_UID = inserted.WARD_UID,
			BED_UID = inserted.BED_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			DISCHARGED_DATE = inserted.DISCHARGED_DATE,
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[Discharge_Evn]
		INNER JOIN inserted ON inserted.id = [dbo].[Discharge_Evn].id;
END
GO

--Constraints
ALTER TABLE [dbo].[DISCHARGE_EVN] ADD CONSTRAINT [PK_DISCHARGE_EVN] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[DISCHARGE_EVN] ADD CONSTRAINT [FK_DISCHARGE_EVN_CONCEPT_TYPE_OF_MOVEMENT] FOREIGN KEY ([TYPE_OF_MOVEMENT_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[DISCHARGE_EVN] ADD CONSTRAINT [DF_DISCHARGE_EVN_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO
ALTER TABLE [dbo].[DISCHARGE_EVN] ADD CONSTRAINT [FK_DISCHARGE_EVN_ADMISSION_EVN_ADMISSION] FOREIGN KEY([ADMISSION_ID]) REFERENCES [dbo].[ADMISSION_EVN] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_DISCH_DATE] ON [dbo].[DISCHARGE_EVN] 
(
	[VISTA_SITE_UID] ASC,
	[DISCHARGED_DATE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_UID] ON [dbo].[DISCHARGE_EVN] 
(
	[BED_UID] ASC
)
INCLUDE ( [DISCHARGED_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID_ID_DOMAIN_ID_IEN] ON [dbo].[DISCHARGE_EVN] ([VISTA_SITE_UID])
INCLUDE ([ID],[DOMAIN_ID],[IEN])
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[DISCHARGE_EVN] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_WARD_UID_ENTERED_DATE_DISCHARGED_DATE] ON [dbo].[DISCHARGE_EVN] 
(
	[WARD_UID] ASC,
	[ENTERED_DATE] ASC,
	[DISCHARGED_DATE] ASC
)
INCLUDE ( [CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX [IDX_ADMISSION_ID] ON [dbo].[DISCHARGE_EVN] 
([ADMISSION_ID])	
GO

CREATE NONCLUSTERED INDEX [IDX_BED_UID_VISTA_SITE_UID] ON [dbo].[DISCHARGE_EVN] 
(
	[BED_UID] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [IEN]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_DISCH_DATE_WITH_INCLUDE] ON [dbo].[DISCHARGE_EVN] 
(
	[VISTA_SITE_UID] ASC,
	[DISCHARGED_DATE] ASC
)
INCLUDE ([ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID], [ADMISSION_ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Discharge event table.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The bed from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date and time of the discharge.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'DISCHARGED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The person who made the discharge order.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'ENTERED_BY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type of movement id column (concept reference)(VistA data).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The ward from where the patient will be discharged.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'WARD_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The UTC date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'CREATION_UTC_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of discharges.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN).', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of creation.', 'SCHEMA', N'dbo', 'TABLE', N'DISCHARGE_EVN', 'COLUMN', N'ENTERED_DATE'
GO