USE BMS
GO

--EXEC [usp_Get_Patient_Icons] 'WHITEBOARD_ICON', 'EMERGENCY_ICON', '138e6e94-c392-49d6-bb8d-71617dab6fd9,11977387-11a7-470a-bc80-30da7b1c15bb,d3bca70f-48f3-4539-b065-7429fb754d64,7970fcd9-a50b-463d-8523-d50c095f5828,8d98a662-0e69-4929-b6fe-a9b73fff564e,e90b01cf-ed6d-4671-9686-f75d152bbab4,fc961a5f-d18d-4505-9a14-f88c01661e37,fa5bf2ce-faaf-4f4e-870d-20e39aa356e8,e463d2a1-f879-4e9e-a108-348735447922,663b6163-eeb1-4663-9d7f-5f031f93b812,aba56fe1-7609-4196-b3d0-2553a88cd8ca,3b91853c-a0b3-44ec-965b-65cda2b61893,8bf04cc2-8462-4d5b-ba45-71beb8032678,f9f0ef21-eb09-4aba-be68-a1ef1d85ca34'
CREATE PROCEDURE [dbo].[usp_Get_Patient_Icons] 
	@GROUP NVARCHAR(100),
	@SUBGROUP NVARCHAR(100),
	@PATIENT_UID_LIST NVARCHAR(MAX),
	@INCLUDE_NULL_RESULTS BIT = 0
AS

BEGIN
SET NOCOUNT ON

IF @INCLUDE_NULL_RESULTS = 0
	BEGIN
		SELECT * FROM 
		(SELECT CAST(P.Value as uniqueidentifier) AS PATIENT_UID, 
		STUFF( (SELECT ',' + CAST(ICON_FLAG_ID AS NVARCHAR(MAX))
													FROM ICON_ASSOCIATION
													INNER JOIN ICON_FLAG ON ICON_ASSOCIATION.ICON_FLAG_ID = ICON_FLAG.ID
													WHERE PATIENT_UID = P.VALUE AND ICON_FLAG_ID IS NOT NULL AND [GROUP] = @GROUP AND SUBGROUP = @SUBGROUP AND ACTIVE = 1 AND PATIENT_OR_ROOMBED = 'P'
													FOR XML PATH('')), 
												1, 1, '') AS ICON_FLAG_IDS
		FROM dbo.fn_Split(@PATIENT_UID_LIST, ',') AS P) Results
		WHERE Results.ICON_FLAG_IDS IS NOT NULL
	END
ELSE
	BEGIN
		SELECT CAST(P.Value as uniqueidentifier) AS PATIENT_UID, 
		STUFF( (SELECT ',' + CAST(ICON_FLAG_ID AS NVARCHAR(MAX))
													FROM ICON_ASSOCIATION
													INNER JOIN ICON_FLAG ON ICON_ASSOCIATION.ICON_FLAG_ID = ICON_FLAG.ID
													WHERE PATIENT_UID = P.VALUE AND ICON_FLAG_ID IS NOT NULL AND [GROUP] = @GROUP AND SUBGROUP = @SUBGROUP AND ACTIVE = 1 AND PATIENT_OR_ROOMBED = 'P'
													FOR XML PATH('')), 
												1, 1, '') AS ICON_FLAG_IDS
		FROM dbo.fn_Split(@PATIENT_UID_LIST, ',') AS P
	END
END

