USE [BMS_HISTORY]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_WhiteboardAuditLog]    Script Date: 6/15/2016 4:11:11 PM ******/
DROP PROCEDURE [dbo].[usp_Rpt_WhiteboardAuditLog]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_WhiteboardAuditLog]    Script Date: 6/15/2016 4:11:11 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--Whiteboard Audit Log Report
--
--exec usp_Rpt_WhiteboardAuditLog @DATE_FROM='2010-05-10 00:00:01',@DATE_TO='2016-05-17 23:59:59',@TIME_ZONE_MINUTES_OFFSET=-360,@UserID=N'DNS   HORND@DNS           ',@FACILITIES_IDS=N'27127BEC-7FFC-4AE3-AB51-5FC12E94978E,DE5F7D7A-2B23-4238-A62C-95F98C799FBF,B9BD1F1E-F01D-4436-A119-C3F3411F1768,AD3296DE-4489-4C86-9073-116BCBFC5807,BF033FD3-C3FF-4597-9309-8506AF025CCF,0345964C-1C40-4C67-9926-0FF3646F76E3,384246E5-2383-4164-A5F8-BBC4DB65268C,074A4A23-BD1C-4645-BA17-FD4285CB8DD1,82664146-A432-4D5D-ACE9-3473A94A4843,199D6E6C-B791-4570-BD0C-A4F21C11B1C9,B76FD5CC-45A6-4396-BAE5-390BBFD9608A,E890E0DD-2A5B-4DF2-9BD3-A80FF7880D68,6B2EEF5C-B569-429B-817D-11D67F4FB7A4,37BB9F69-E6A0-4686-96CF-E0D6A65A4229,123F5F3D-0220-448B-A3EA-30CC27440D3E,D7D99DDA-6395-4230-9769-7D34281218BD,BD0BE09A-DA6B-4BC9-8512-55DB164A3936,83993150-11EB-46B6-A140-66249407EA99,4228A303-D83B-4D29-9C63-9CF38723A609,B8E19493-FF5D-4D0F-9475-531AB2876D55,A4D69C85-2EFE-4E58-8F51-87A3367D5360,603990B0-6C86-4DCC-A0A2-EDB7EDCF86EE,C9120516-1CA1-488D-A9B7-9F7E8C5CB163,451FDA5B-BF99-4356-A6AD-BD5D1619CD8D,3DC03304-2593-4CE7-BB7C-DAD5036CC466,142B212F-FBBB-4E03-ADB3-6BFDE81EAF3C,5D59E39A-D5DF-4FDB-AD16-DFBF49A2333F,2CF9A166-C3D4-49EC-8C62-F0E369186F37,2908DE1A-AE4A-469C-9C9F-F10857B23639,86831D20-AEBE-4280-B67D-BE0B653280D5,69378E0F-B210-493B-B2A1-2130C9F7F394,85A09908-5BFA-47F1-BEB5-FEBB2E7BE543,AB19779C-94E5-4A50-9139-581A21A84109,158D29E4-76F3-4346-B0E0-D9763CE19C83,AB3A91F8-7180-49B5-B67D-EE7EEBDAEC84,112392FE-7168-4997-A045-246A3622F254,66591DB9-16B7-436A-8BA3-C58D167A588D,059BE374-E52D-4959-AAB4-4BA098FF61E8,3CE8A5F0-82BF-41A2-B159-200B90641A43,160CA25C-AF38-45A6-8F97-B6680627F971,8BF6E455-0BAA-4C62-B649-D5FC37AA88FB,50FF2AC9-0BDC-4C47-8605-68A0558E2B6E,89880507-FF65-4570-A1C4-A6825A3429B5,93AFBDDE-9B8A-4625-932B-2F8FA88646E4,804892C0-C264-46E7-BD1C-9609B4CA4F1C,5151717F-9911-46CE-936D-EAEB881ED4B0,E4EF5C91-C8C7-4979-A652-9B74F43A3C29,ACA61E46-009A-4878-B5E6-70CDEAB1E040,45475D91-28BF-4018-9949-C418A0671DDD,BEAE8ECD-F483-4538-BE2D-673CAB60DFE5,CC262497-9ED7-4A61-AFFA-9F26197603AB,888EEAE2-2369-49DE-98CF-A9A8E9EE17F5,286566E2-E679-4FB5-88A9-BA37B3561B3D,E95499CA-500C-482D-9ECB-BA4B7599EB82,A84FE131-C31C-4044-AFDB-3B61A531919A,DD64B757-F066-4F2D-AF89-EC50A8AF1CD7,44330A17-1C70-463F-A099-56668281B80A,33617A96-3E0F-487C-8A4C-3E141AA6B5F1,4F62B779-57D7-4ECC-91C5-24A1F40B089A,CE0BE571-1C7A-4B54-8013-10544D9777E1,324DB4DF-8BA2-46B7-9C6D-48004D412BCE,2F4332A8-9489-4AC6-BBB9-7719508A30E1,FCED40B3-BF53-4FB0-A7CB-F43BD99E2D30,FBB30408-0C7B-4B6E-AAC5-67F98970DF6F,4F0216B5-1AD6-42DD-AEE0-C76DA395B8E3,5873DC3C-7727-4B33-A2DB-BAE85FFBB93B,719FF4AF-FC82-4031-9386-CA8FBCB291AF,3A31E917-6985-4C49-BB3A-7F1EACC32431,C4721CB8-126C-474D-A75D-E1ECA55A9E26,82F22B45-1DC4-44A1-B574-76AED9EE08ED,FC6080D7-C9CA-455F-8A9A-0CDEF9084821,5055F460-A241-494D-97B7-AAF1CE94C088,F29D2134-C562-4527-9539-8D3A6D6460CB,5A2AB598-B1E8-490E-9FDD-8EA4E2A51BAB,924662F7-9425-48B0-A1D1-84FD83805B2B,4EA4AC4F-D512-4ADF-8014-4D21FE1A8289,A98558D4-505C-4046-A24D-BCC24A46D5B0,69450451-12E8-4084-B6FA-013309A5F814,15E538E4-EFCB-474A-95F2-599E6CFE1AF8,0A8AD105-4069-4EEB-815B-C13C8DFB2E09,DF945CD2-25F7-48E5-BE40-C7AB0823D0ED,D51D0E56-2883-4F66-BE47-4D99ED6DE082,3F246B9F-E91F-4BC7-8131-56F6174C776A,C2785D26-C5A0-41C0-9906-3C0DAA86D07A,280DFF7D-D689-43FA-AD25-0BCFB9802954,87D643D5-A086-4E03-892C-173C76C0CF58,8EAFB939-1824-4A75-B808-A9B54C393399,F21774A4-A832-4AB9-B5AB-AA38615F1730,7982F659-534B-4DC9-AEE9-36AA7E0BF035,17F6135E-2ECA-416C-B066-F236EDD752AF,8F30BEDF-C177-4ECB-9328-4F1294327A6B,8FE3BD98-079F-4B27-8129-CDFAA27A5992,E8934FDE-8AC4-436E-B9FD-D74075C2CBFC,726332B6-3EEB-469D-BEBF-68A375685473,7F661DD6-8801-4FA8-92F0-B514818AEEB8,0023CC35-177F-4052-8B0B-8ECA94670B3B,FA854ED7-7249-4398-BD29-62A26483D53B,BC9DF7D5-3929-4AC0-BD5F-CD091FF337F4,6B160084-A6E6-4F2B-9016-168B5BCD780C,304DB2BE-36AC-4CB8-8B61-3A6DBDD0E675,5E4D685F-33E8-4FFE-A46E-C420EE4DC889,D498F5AC-788A-4CFD-87CB-F6832AD5C085,0E99FA6A-FA78-4F88-B88C-24293994876F,6ED340B4-DE87-4DC3-B888-3112486D6348,682D2688-4175-4140-BDBB-55188C4B49D2,07F2F24E-E08F-495C-8DE4-EF75EA32EF25,09B3BEEA-D078-41E5-ACBA-661838CD0E25,1924A041-4769-4219-AE42-11C7B8FAB6FE,A09C8658-C40F-4825-BA67-375F11B50BD9,2A82DF79-0691-4811-9B9C-03231DDF4E6A,487D5CD0-808A-4FF0-A353-B566F15CB107,EEE2965C-5849-4B9E-912A-1D6046A48C61,2C6DA1BE-D0A1-42BD-AAAA-8794CAC69E00,FCD16EFC-D965-4853-9B13-C33042268561,C33E6708-FBB1-47DE-8394-505A8FE1688C,72244CFC-3520-4547-8F69-C496AECC3784,6BB1F574-1082-43C3-9A5B-475B83334F3B,0E3BF04C-9A89-4F47-AFC7-5A62F8845F47,220977D6-F59B-447F-95E4-B4AE1E306702,145C69BD-B35C-481A-8F30-7C64FD089FCE,188D2285-3956-409D-9E32-27F9C20184EE,806203F9-B7D0-4247-A046-079A00A73F07,B64FD9FB-E6AF-4105-8007-67918B163230,E67EA882-EA3E-4B84-94A2-8BE35EE8869C,0E13380A-F2F1-4612-A29F-78EF36F511AB,4AD9DFDC-3BCE-4C6E-A84F-46905DC0009A,8D84989D-68C0-48DA-8E02-5CF2EE48B57F,A3B79F41-493E-43B4-8A3D-3A7254CE2017,CCA247D3-98BA-49BB-BA3B-43AAF4A3EC56,E2DCB406-9E91-4AF3-891E-F4A6427F3D62,3E1925AC-97DC-4755-B733-60170BFD8A1F,913090D9-CE98-4D34-9351-7D7E0E7F6B37,5354BB42-B12F-4AC6-8FEC-C6071B0DB9DE,5F1AB3DC-E4C6-4EAF-ACD3-475DCBC1CD6D,F2E591EB-019E-4676-ACE0-F29AB5608E37,71399753-46C7-4B53-90DF-AEFC3BBF3E72,CED3D7F7-0C1E-429A-AC1B-853025B2EE51,980EE0B5-AF61-4FE1-9320-8C745D655569,D94F05E0-0243-42D2-A43C-83E3C81FB856,BD202829-2A88-4DC2-A207-CBBAB892C3C2,5DB10171-F7A4-4D3E-A1C2-B73A3E93783C,77E6C1A6-3194-4F2A-B847-01B1C57DA8BD,84B14793-D236-4E26-8D62-ECEF51A8B914',@REPORT_TYPE=N'WhiteboardAuditLog'
--exec usp_Rpt_WhiteboardAuditLog @DATE_FROM='2012-05-14 00:00:01',@DATE_TO='2016-06-01 23:59:59',@TIME_ZONE_MINUTES_OFFSET=0,@UserID=N'DNS   HORND@DNS           ',@FACILITIES_IDS=N'DE5F7D7A-2B23-4238-A62C-95F98C799FBF,B9BD1F1E-F01D-4436-A119-C3F3411F1768,AD3296DE-4489-4C86-9073-116BCBFC5807,BF033FD3-C3FF-4597-9309-8506AF025CCF,0345964C-1C40-4C67-9926-0FF3646F76E3,384246E5-2383-4164-A5F8-BBC4DB65268C,074A4A23-BD1C-4645-BA17-FD4285CB8DD1,82664146-A432-4D5D-ACE9-3473A94A4843,199D6E6C-B791-4570-BD0C-A4F21C11B1C9,B76FD5CC-45A6-4396-BAE5-390BBFD9608A,E890E0DD-2A5B-4DF2-9BD3-A80FF7880D68,6B2EEF5C-B569-429B-817D-11D67F4FB7A4,37BB9F69-E6A0-4686-96CF-E0D6A65A4229,123F5F3D-0220-448B-A3EA-30CC27440D3E,D7D99DDA-6395-4230-9769-7D34281218BD,BD0BE09A-DA6B-4BC9-8512-55DB164A3936,83993150-11EB-46B6-A140-66249407EA99,4228A303-D83B-4D29-9C63-9CF38723A609,B8E19493-FF5D-4D0F-9475-531AB2876D55,A4D69C85-2EFE-4E58-8F51-87A3367D5360,603990B0-6C86-4DCC-A0A2-EDB7EDCF86EE,C9120516-1CA1-488D-A9B7-9F7E8C5CB163,451FDA5B-BF99-4356-A6AD-BD5D1619CD8D,3DC03304-2593-4CE7-BB7C-DAD5036CC466,142B212F-FBBB-4E03-ADB3-6BFDE81EAF3C,5D59E39A-D5DF-4FDB-AD16-DFBF49A2333F,2CF9A166-C3D4-49EC-8C62-F0E369186F37,2908DE1A-AE4A-469C-9C9F-F10857B23639,86831D20-AEBE-4280-B67D-BE0B653280D5,69378E0F-B210-493B-B2A1-2130C9F7F394,85A09908-5BFA-47F1-BEB5-FEBB2E7BE543,AB19779C-94E5-4A50-9139-581A21A84109,158D29E4-76F3-4346-B0E0-D9763CE19C83,AB3A91F8-7180-49B5-B67D-EE7EEBDAEC84,112392FE-7168-4997-A045-246A3622F254,66591DB9-16B7-436A-8BA3-C58D167A588D,059BE374-E52D-4959-AAB4-4BA098FF61E8,3CE8A5F0-82BF-41A2-B159-200B90641A43,160CA25C-AF38-45A6-8F97-B6680627F971,8BF6E455-0BAA-4C62-B649-D5FC37AA88FB,50FF2AC9-0BDC-4C47-8605-68A0558E2B6E,89880507-FF65-4570-A1C4-A6825A3429B5,93AFBDDE-9B8A-4625-932B-2F8FA88646E4,804892C0-C264-46E7-BD1C-9609B4CA4F1C,5151717F-9911-46CE-936D-EAEB881ED4B0,E4EF5C91-C8C7-4979-A652-9B74F43A3C29,ACA61E46-009A-4878-B5E6-70CDEAB1E040,45475D91-28BF-4018-9949-C418A0671DDD,BEAE8ECD-F483-4538-BE2D-673CAB60DFE5,CC262497-9ED7-4A61-AFFA-9F26197603AB,888EEAE2-2369-49DE-98CF-A9A8E9EE17F5,286566E2-E679-4FB5-88A9-BA37B3561B3D,E95499CA-500C-482D-9ECB-BA4B7599EB82,A84FE131-C31C-4044-AFDB-3B61A531919A,DD64B757-F066-4F2D-AF89-EC50A8AF1CD7,44330A17-1C70-463F-A099-56668281B80A,33617A96-3E0F-487C-8A4C-3E141AA6B5F1,4F62B779-57D7-4ECC-91C5-24A1F40B089A,CE0BE571-1C7A-4B54-8013-10544D9777E1,324DB4DF-8BA2-46B7-9C6D-48004D412BCE,2F4332A8-9489-4AC6-BBB9-7719508A30E1,FCED40B3-BF53-4FB0-A7CB-F43BD99E2D30,FBB30408-0C7B-4B6E-AAC5-67F98970DF6F,4F0216B5-1AD6-42DD-AEE0-C76DA395B8E3,5873DC3C-7727-4B33-A2DB-BAE85FFBB93B,719FF4AF-FC82-4031-9386-CA8FBCB291AF,3A31E917-6985-4C49-BB3A-7F1EACC32431,C4721CB8-126C-474D-A75D-E1ECA55A9E26,82F22B45-1DC4-44A1-B574-76AED9EE08ED,FC6080D7-C9CA-455F-8A9A-0CDEF9084821,5055F460-A241-494D-97B7-AAF1CE94C088,F29D2134-C562-4527-9539-8D3A6D6460CB,5A2AB598-B1E8-490E-9FDD-8EA4E2A51BAB,924662F7-9425-48B0-A1D1-84FD83805B2B,4EA4AC4F-D512-4ADF-8014-4D21FE1A8289,A98558D4-505C-4046-A24D-BCC24A46D5B0,69450451-12E8-4084-B6FA-013309A5F814,15E538E4-EFCB-474A-95F2-599E6CFE1AF8,0A8AD105-4069-4EEB-815B-C13C8DFB2E09,DF945CD2-25F7-48E5-BE40-C7AB0823D0ED,D51D0E56-2883-4F66-BE47-4D99ED6DE082,3F246B9F-E91F-4BC7-8131-56F6174C776A,C2785D26-C5A0-41C0-9906-3C0DAA86D07A,280DFF7D-D689-43FA-AD25-0BCFB9802954,87D643D5-A086-4E03-892C-173C76C0CF58,8EAFB939-1824-4A75-B808-A9B54C393399,F21774A4-A832-4AB9-B5AB-AA38615F1730,7982F659-534B-4DC9-AEE9-36AA7E0BF035,17F6135E-2ECA-416C-B066-F236EDD752AF,8F30BEDF-C177-4ECB-9328-4F1294327A6B,8FE3BD98-079F-4B27-8129-CDFAA27A5992,E8934FDE-8AC4-436E-B9FD-D74075C2CBFC,726332B6-3EEB-469D-BEBF-68A375685473,7F661DD6-8801-4FA8-92F0-B514818AEEB8,0023CC35-177F-4052-8B0B-8ECA94670B3B,FA854ED7-7249-4398-BD29-62A26483D53B,BC9DF7D5-3929-4AC0-BD5F-CD091FF337F4,6B160084-A6E6-4F2B-9016-168B5BCD780C,304DB2BE-36AC-4CB8-8B61-3A6DBDD0E675,5E4D685F-33E8-4FFE-A46E-C420EE4DC889,D498F5AC-788A-4CFD-87CB-F6832AD5C085,0E99FA6A-FA78-4F88-B88C-24293994876F,6ED340B4-DE87-4DC3-B888-3112486D6348,682D2688-4175-4140-BDBB-55188C4B49D2,07F2F24E-E08F-495C-8DE4-EF75EA32EF25,09B3BEEA-D078-41E5-ACBA-661838CD0E25,1924A041-4769-4219-AE42-11C7B8FAB6FE,A09C8658-C40F-4825-BA67-375F11B50BD9,2A82DF79-0691-4811-9B9C-03231DDF4E6A,487D5CD0-808A-4FF0-A353-B566F15CB107,EEE2965C-5849-4B9E-912A-1D6046A48C61,2C6DA1BE-D0A1-42BD-AAAA-8794CAC69E00,FCD16EFC-D965-4853-9B13-C33042268561,C33E6708-FBB1-47DE-8394-505A8FE1688C,72244CFC-3520-4547-8F69-C496AECC3784,6BB1F574-1082-43C3-9A5B-475B83334F3B,0E3BF04C-9A89-4F47-AFC7-5A62F8845F47,220977D6-F59B-447F-95E4-B4AE1E306702,145C69BD-B35C-481A-8F30-7C64FD089FCE,188D2285-3956-409D-9E32-27F9C20184EE,806203F9-B7D0-4247-A046-079A00A73F07,B64FD9FB-E6AF-4105-8007-67918B163230,E67EA882-EA3E-4B84-94A2-8BE35EE8869C,0E13380A-F2F1-4612-A29F-78EF36F511AB,4AD9DFDC-3BCE-4C6E-A84F-46905DC0009A,8D84989D-68C0-48DA-8E02-5CF2EE48B57F,A3B79F41-493E-43B4-8A3D-3A7254CE2017,CCA247D3-98BA-49BB-BA3B-43AAF4A3EC56,E2DCB406-9E91-4AF3-891E-F4A6427F3D62,3E1925AC-97DC-4755-B733-60170BFD8A1F,913090D9-CE98-4D34-9351-7D7E0E7F6B37,5354BB42-B12F-4AC6-8FEC-C6071B0DB9DE,5F1AB3DC-E4C6-4EAF-ACD3-475DCBC1CD6D,F2E591EB-019E-4676-ACE0-F29AB5608E37,71399753-46C7-4B53-90DF-AEFC3BBF3E72,CED3D7F7-0C1E-429A-AC1B-853025B2EE51,980EE0B5-AF61-4FE1-9320-8C745D655569,D94F05E0-0243-42D2-A43C-83E3C81FB856,BD202829-2A88-4DC2-A207-CBBAB892C3C2,5DB10171-F7A4-4D3E-A1C2-B73A3E93783C,77E6C1A6-3194-4F2A-B847-01B1C57DA8BD,84B14793-D236-4E26-8D62-ECEF51A8B914',@REPORT_TYPE=N'WhiteBoardUsageAuditLog'

/*
AUDIT TABLES
BED_REASON_COMMENT_HISTORY_H (BED_UID, DIVISION_UID, VISTA_SITE_UID) GOOD
BED_UNAVAILABLE_H (BED_UID, VISTA_SITE_UID, ACT_ID*) GOOD
BED_UNAVAILABLE_WARD_H (BED_UNAVAILABLE_ID, WARD_UID) GOOD
ICON_ASSOCIATION_H (BED_UID, ICON_FLAG_ID, ICON_FLAG_FACILITY_ID) GOOD
BED_STAFF_H (BED_UID, DIVISION_UID, PATIENT_UID, FACILITY_UID) NO DATA
*/

CREATE PROCEDURE [dbo].[usp_Rpt_WhiteboardAuditLog]
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@TIME_ZONE_MINUTES_OFFSET INT,
	@UserID NVARCHAR(500),
	@FACILITIES_IDS NVARCHAR(MAX) = '',
	@REPORT_TYPE NVARCHAR(50)
AS
BEGIN
SET NOCOUNT ON;

IF (@REPORT_TYPE = 'WhiteboardUsageAuditLog')
BEGIN

	CREATE TABLE #TBL_FACILITY (
		SOURCE_ID NVARCHAR(250) PRIMARY KEY, 
		FACILITY_NAME NVARCHAR(250), 
		TIMEZONE_OFFSET INT)
	
	INSERT INTO #TBL_FACILITY(SOURCE_ID, FACILITY_NAME, TIMEZONE_OFFSET) 
	SELECT DISTINCT CONVERT(NVARCHAR(250), FACILITY.VALUE), ORG.NAME,  [dbo].[ufn_GetOffsetByFacilityUID](VALUE) 
	FROM dbo.ufn_Split(@FACILITIES_IDS, ',') AS FACILITY
	INNER JOIN BMS_EIS.dbo.ENTITY AS ENTITY 
	  ON ENTITY.IDENTIFIER = FACILITY.VALUE 
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS ORG 
	  ON ORG.PFK_ORGANIZATION = ENTITY.PK_ENTITY

	--select * from #TBL_FACILITY

	CREATE TABLE #WARDS (
		WARD_ID int,
		SOURCE_ID nvarchar(250),
		WARD_NAME varchar(100),
		FACILITY_NAME varchar(100)
	)

	INSERT INTO #WARDS
	SELECT WARDGROUP.ID, WARDGROUP.SOURCE_ID, WARDGROUP.NAME, FACILITY.NAME FROM BMS_DW.dbo.DIM_ORGANIZATION AS WARDGROUP
				INNER JOIN BMS_DW.dbo.DIM_ORGANIZATION AS FACILITY 
				ON WARDGROUP.DIM_ORGANIZATION_ID = FACILITY.ID
				INNER JOIN #TBL_FACILITY myFAC ON FACILITY.SOURCE_ID = myFAC.SOURCE_ID
				WHERE WARDGROUP.DIM_ORGANIZATION_TYPE_ID =6

	--select * from #WARDS				

	CREATE TABLE #BEDUNAVAILABLE (
			PK int,
			ACT_ID int,
			DIVISION_UID uniqueidentifier,
			BED_UID uniqueidentifier,
			BED_Name	Varchar(250),  --JP ADDED 06/08/16
			VISTA_SITE_UID uniqueidentifier,
			COMMENT varchar(max),
			History_Comment nvarchar(max),  --JP ADDED 06/08/16
			TYPE_ID int,
			REASON_ID int,
			IS_UNAVAILABLE_FROM_VISTA bit,
			CREATION_BY nvarchar(250),
			EDITED_BY nvarchar(250),
			EDITED_DATE datetime,
			EXPECTED_COMPLETED_DATE datetime,
			COMPLETED_BY nvarchar(250),
			COMPLETED_DATE datetime,
			TRANSACTION_TYPE_CODE varchar(50),
			DATE datetime,
			CREATED_BY nvarchar(50),
			WARD_UID uniqueidentifier,
			WARD_NAME varchar(30),
			W_TRANSACTION_TYPE_CODE varchar(50),
			W_DATE datetime,
			ACTION_TYPE varchar(20)
	)
	INSERT #BEDUNAVAILABLE
	SELECT	BEDUHISTORY.PK,
			BEDUHISTORY.ACT_ID,
			BEDUHISTORY.DIVISION_UID,
			BEDUHISTORY.BED_UID,
			BED.Name as BED_Name, --JP ADDED 06/08/16
			BEDUHISTORY.VISTA_SITE_UID,
			BEDUHISTORY.COMMENT,
			BRCHH.Comment as History_Comment, --JP ADDED 06/08/16
			BEDUHISTORY.TYPE_ID,
			BEDUHISTORY.REASON_ID,
			BEDUHISTORY.IS_UNAVAILABLE_FROM_VISTA,
			BEDUHISTORY.CREATION_BY,
			BEDUHISTORY.EDITED_BY,
			BEDUHISTORY.EDITED_DATE,
			BEDUHISTORY.EXPECTED_COMPLETED_DATE,
			BEDUHISTORY.COMPLETED_BY,
			BEDUHISTORY.COMPLETED_DATE,
			BEDUHISTORY.TRANSACTION_TYPE_CODE,
			BEDUHISTORY.DATE,
			BEDUHISTORY.CREATED_BY,
			BEDWARDUHISTORY.WARD_UID,		
			PLACE.NAME as WARD_NAME,
			BEDWARDUHISTORY.TRANSACTION_TYPE_CODE,
			BEDWARDUHISTORY.DATE,
			CASE WHEN BEDUHISTORY.TRANSACTION_TYPE_CODE = 'I' THEN 'NEW RECORD' 
				 WHEN BEDUHISTORY.TRANSACTION_TYPE_CODE = 'U' THEN 'UPDATED'
				 WHEN BEDUHISTORY.TRANSACTION_TYPE_CODE = 'D' THEN 'DELETED'
			END as ACTIONTYPE 
	FROM BED_UNAVAILABLE_H BEDUHISTORY
	LEFT JOIN BED_UNAVAILABLE_WARD_H BEDWARDUHISTORY
	ON BEDUHISTORY.ACT_ID = BEDWARDUHISTORY.BED_UNAVAILABLE_ID
	INNER JOIN BMS_DW.dbo.DIM_BED BED ON BEDUHISTORY.BED_UID = BED.SOURCE_ID
	INNER JOIN BMS_DW.dbo.GROUP_BED_WARDGROUP as GBWG ON GBWG.DIM_BED_ID = BED.ID
	INNER JOIN #WARDS WARDS ON GBWG.DIM_WARDGROUP_ID =WARDS.WARD_ID
	--INNER JOIN #WARDS WARDS ON BEDWARDUHISTORY.WARD_UID = WARDS.SOURCE_ID
	LEFT JOIN BMS_EIS.dbo.ENTITY AS ENTITY ON ENTITY.IDENTIFIER = BEDWARDUHISTORY.WARD_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS PLACE ON PLACE.PFK_PLACE = ENTITY.PK_ENTITY
	LEFT JOIN BMS_DW.dbo.DIM_WARD WARD ON PLACE.PFK_PLACE = WARD.SOURCE_PK
	LEFT JOIN BMS_HISTORY.dbo.BED_REASON_COMMENT_HISTORY_H BRCHH
	  ON BRCHH.BED_UID = BEDUHISTORY.BED_UID
	WHERE BEDUHISTORY.DATE BETWEEN @DATE_FROM AND @DATE_TO  
	OPTION (MAXDOP 1) 

	--SELECT * FROM #TRANHISTORY

	CREATE TABLE #WBHISTORY(
		ENTERED_DATE datetime,
		COMPLETED_DATE datetime,
		EDITED datetime,
		EDITED_BY nvarchar(250),
		PATIENT_NAME nvarchar(250),
		BED_NAME nvarchar(100),
		ACT_ID int,
		ACTION_TYPE varchar(25),
		TRAN_UPDS varchar(max),
		TRAN_COMMENTS varchar(max),
		UPDATE_TYPE varchar(30)
	)
	INSERT INTO #WBHISTORY
	SELECT DISTINCT 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BEDU.DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BEDU.DATE), 108) as ENTERED_DATE, 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BEDU.COMPLETED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BEDU.COMPLETED_DATE), 108) as COMPLETED_DATE,
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BEDU.EDITED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BEDU.EDITED_DATE), 108) as EDITED,
		   
		   --MODIFICATION BY JP 06/08/16
		   CASE WHEN H_BEDU.ACTION_TYPE = 'NEW RECORD' Then H_BEDU.CREATION_BY
		        WHEN H_BEDU.ACTION_TYPE = 'UPDATED' and H_BEDU.COMPLETED_BY is not null and H_BEDU.EDITED_BY is null 
					Then H_BEDU.COMPLETED_BY
				 WHEN H_BEDU.ACTION_TYPE = 'UPDATED' and H_BEDU.EDITED_BY is not null and H_BEDU.COMPLETED_BY is null 
					Then H_BEDU.EDITED_BY
				WHEN H_BEDU.ACTION_TYPE = 'UPDATED' and H_BEDU.EDITED_BY is not null and H_BEDU.COMPLETED_BY is not null 
					Then H_BEDU.COMPLETED_BY
				END as EDITED_BY,
		   --H_BEDU.EDITED_BY,

		   NULL as PATIENT_NAME,
		   --BED.NAME as BED_NAME,    --JP DELETED 06/08/16
		   H_BEDU.BED_Name as BED_NAME, --JP ADDED 06/08/16
		   H_BEDU.ACT_ID,
		   H_BEDU.ACTION_TYPE,
	CASE WHEN H_BEDU.TRANSACTION_TYPE_CODE = 'U' THEN 
		CASE WHEN H_BEDU.REASON_ID <> PREVIOUS_H_BEDU.REASON_ID OR (H_BEDU.REASON_ID IS NULL AND PREVIOUS_H_BEDU.REASON_ID IS NOT NULL) OR (H_BEDU.REASON_ID IS NOT NULL AND PREVIOUS_H_BEDU.REASON_ID IS NULL)
			THEN  'REASON FROM ' + ISNULL(REASON.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(REASON.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' '+
        CASE WHEN H_BEDU.COMPLETED_BY <> PREVIOUS_H_BEDU.COMPLETED_BY OR (H_BEDU.COMPLETED_BY IS NULL AND PREVIOUS_H_BEDU.COMPLETED_BY IS NOT NULL) OR (H_BEDU.COMPLETED_BY IS NOT NULL AND PREVIOUS_H_BEDU.COMPLETED_BY IS NULL)
			THEN  'COMPLETED BY FROM ' + ISNULL(PREVIOUS_H_BEDU.COMPLETED_BY,'<EMPTY>') + ' TO ' + ISNULL(H_BEDU.COMPLETED_BY,'') + char(13)+char(10) ELSE '' END + ' '+
		CASE WHEN H_BEDU.COMPLETED_DATE <> PREVIOUS_H_BEDU.COMPLETED_DATE OR (H_BEDU.COMPLETED_DATE IS NULL AND PREVIOUS_H_BEDU.COMPLETED_DATE IS NOT NULL) OR (H_BEDU.COMPLETED_DATE IS NOT NULL AND PREVIOUS_H_BEDU.COMPLETED_DATE IS NULL) 
			THEN 'COMPLETED DATE FROM ' + CASE WHEN PREVIOUS_H_BEDU.COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),PREVIOUS_H_BEDU.COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),PREVIOUS_H_BEDU.COMPLETED_DATE,108), '') + ' ' + ISNULL(right(convert(varchar(30),PREVIOUS_H_BEDU.COMPLETED_DATE,109),2),'') END +
				' TO ' + CASE WHEN H_BEDU.COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),H_BEDU.COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),H_BEDU.COMPLETED_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),H_BEDU.COMPLETED_DATE,109),2),'') + char(13)+char(10) END ELSE '' END + ' ' +
		CASE WHEN H_BEDU.TYPE_ID <> PREVIOUS_H_BEDU.TYPE_ID OR (H_BEDU.TYPE_ID IS NULL AND PREVIOUS_H_BEDU.TYPE_ID IS NOT NULL) OR (H_BEDU.TYPE_ID IS NOT NULL AND PREVIOUS_H_BEDU.TYPE_ID IS NULL)
			THEN  'TYPE FROM ' + ISNULL(TYPECODE.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(TYPECODE.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' '+
		CASE WHEN H_BEDU.IS_UNAVAILABLE_FROM_VISTA <> PREVIOUS_H_BEDU.IS_UNAVAILABLE_FROM_VISTA THEN 'UNAVAILABLE FROM VISTA FROM ' + 
			CASE WHEN PREVIOUS_H_BEDU.IS_UNAVAILABLE_FROM_VISTA = 1 THEN 'Yes' ELSE 'No' END + ' TO ' + 
			CASE WHEN H_BEDU.IS_UNAVAILABLE_FROM_VISTA = 1 THEN 'Yes' ELSE 'No' END + char(13)+char(10) ELSE '' END + ' ' +		
		CASE WHEN H_BEDU.EXPECTED_COMPLETED_DATE <> PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE OR (H_BEDU.EXPECTED_COMPLETED_DATE IS NULL AND PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE IS NOT NULL) OR (H_BEDU.EXPECTED_COMPLETED_DATE IS NOT NULL AND PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE IS NULL) 
			THEN 'EXPECTED COMPLETED DATE FROM ' + CASE WHEN PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE,108), '') + ' ' + ISNULL(right(convert(varchar(30),PREVIOUS_H_BEDU.EXPECTED_COMPLETED_DATE,109),2),'') END +
				' TO ' + CASE WHEN H_BEDU.EXPECTED_COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),H_BEDU.EXPECTED_COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),H_BEDU.EXPECTED_COMPLETED_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),H_BEDU.EXPECTED_COMPLETED_DATE,109),2),'') + char(13)+char(10) END ELSE '' END + ' ' +
		CASE WHEN H_BEDU.WARD_UID <> PREVIOUS_H_BEDU.WARD_UID OR (H_BEDU.WARD_UID IS NULL AND PREVIOUS_H_BEDU.WARD_UID IS NOT NULL) OR (H_BEDU.WARD_UID IS NOT NULL AND PREVIOUS_H_BEDU.WARD_UID IS NULL)
			THEN  'WARD FROM ' + ISNULL(WARD.NAME,'<EMPTY>') + ' TO ' + ISNULL(WARD2.NAME,'') + char(13)+char(10) ELSE '' END 

	ELSE '' 
	END as TRAN_UPDS,
	
	--MODIFICATION BY JP 06/08/16
	--CASE WHEN H_BEDU.COMMENT <> PREVIOUS_H_BEDU.COMMENT OR (H_BEDU.COMMENT IS NULL AND PREVIOUS_H_BEDU.COMMENT IS NOT NULL) OR (H_BEDU.COMMENT IS NOT NULL AND PREVIOUS_H_BEDU.COMMENT IS NULL)
	--	THEN  'COMMENT FROM ' + ISNULL(PREVIOUS_H_BEDU.COMMENT,'<EMPTY>') + ' TO ' + ISNULL(H_BEDU.COMMENT,'') + char(13)+char(10) ELSE '' END as TRAN_COMMENTS,
	CASE WHEN H_BEDU.History_Comment <> PREVIOUS_H_BEDU.History_Comment OR (H_BEDU.History_Comment IS NULL AND PREVIOUS_H_BEDU.History_Comment IS NOT NULL) OR (H_BEDU.History_Comment IS NOT NULL AND PREVIOUS_H_BEDU.History_Comment IS NULL)
		THEN  'COMMENT FROM ' + ISNULL(PREVIOUS_H_BEDU.History_Comment,'<EMPTY>') + ' TO ' + ISNULL(H_BEDU.History_Comment,'') + char(13)+char(10) ELSE '' END as TRAN_COMMENTS,
	
	'BED UNAVAILABLE' as UPDATE_TYPE
	FROM #BEDUNAVAILABLE H_BEDU
	LEFT JOIN #BEDUNAVAILABLE AS PREVIOUS_H_BEDU ON
	PREVIOUS_H_BEDU.ACT_ID = H_BEDU.ACT_ID AND
	PREVIOUS_H_BEDU.PK < H_BEDU.PK
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E1 ON E1.IDENTIFIER = PREVIOUS_H_BEDU.BED_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED ON BED.PFK_PLACE = E1.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E2 ON E2.IDENTIFIER = H_BEDU.BED_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED2 ON BED.PFK_PLACE = E2.PK_ENTITY
	LEFT JOIN CONCEPT_H as REASON ON H_BEDU.REASON_ID = REASON.ID AND REASON.CODE_SYSTEM_NAME = 'UnavailableReason'
	LEFT JOIN CONCEPT_H as TYPECODE ON H_BEDU.TYPE_ID = TYPECODE.ID AND TYPECODE.CODE_SYSTEM_NAME = 'AdminURType'
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E3 ON E3.IDENTIFIER = PREVIOUS_H_BEDU.WARD_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS WARD ON WARD.PFK_PLACE =E3.PK_ENTITY 
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E4 ON E4.IDENTIFIER = H_BEDU.WARD_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS WARD2 ON WARD2.PFK_PLACE =E4.PK_ENTITY 

--select * from #WBHISTORY
	OPTION (MAXDOP 1) 

	CREATE TABLE #BEDSTAFF(
		PK int,
		BED_UID uniqueidentifier,
		DIVISION_UID uniqueidentifier,
		STAFF nvarchar(250),
		PATIENT_UID uniqueidentifier,
		FACILITY_UID uniqueidentifier,
		TRANSACTION_TYPE_CODE varchar(50),
		DATE datetime,
		CREATED_BY nvarchar(50),
		ACTION_TYPE varchar(25)
	)
	INSERT INTO #BEDSTAFF
	SELECT	PK,
			BED_UID,
			DIVISION_UID,
			STAFF,
			PATIENT_UID,
			FACILITY_UID,
			TRANSACTION_TYPE_CODE,
			DATE,
			CREATED_BY,
			CASE WHEN BED_STAFF_H.TRANSACTION_TYPE_CODE = 'I' THEN 'NEW RECORD' 
				 WHEN BED_STAFF_H.TRANSACTION_TYPE_CODE = 'U' THEN 'UPDATED'
				 WHEN BED_STAFF_H.TRANSACTION_TYPE_CODE = 'D' THEN 'DELETED' END
			AS ACTION_TYPE
	FROM	BED_STAFF_H
	INNER JOIN #TBL_FACILITY FAC
	ON BED_STAFF_H.FACILITY_UID = FAC.SOURCE_ID 

	INSERT INTO #WBHISTORY
	SELECT DISTINCT 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BSTAFF.DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BSTAFF.DATE), 108) as ENTERED_DATE, 
		   NULL AS COMPLETED_DATE,	
		   NULL AS EDITED,
		   UH.NAME AS CREATED_BY,
		   PERSON.[NAME_FAMILY] + SUBSTRING(S1.[IDENTIFIER_EXTENSION], 7, 5) AS PATIENT_NAME,
		   BED.NAME as BED_NAME,
		   NULL AS ACT_ID,
		   H_BSTAFF.ACTION_TYPE,
		   CASE WHEN H_BSTAFF.TRANSACTION_TYPE_CODE = 'U' THEN
				CASE WHEN H_BSTAFF.STAFF <> PREVIOUS_H_BSTAFF.STAFF OR (H_BSTAFF.STAFF IS NULL AND PREVIOUS_H_BSTAFF.STAFF IS NOT NULL) OR (H_BSTAFF.STAFF IS NOT NULL AND PREVIOUS_H_BSTAFF.STAFF IS NULL)
				THEN  'STAFF FROM ' + ISNULL(PREVIOUS_H_BSTAFF.STAFF,'<EMPTY>') + ' TO ' + ISNULL(H_BSTAFF.STAFF,'') + char(13)+char(10) ELSE '' END 
		   ELSE 
				'BED STAFF: ' + ISNULL(H_BSTAFF.STAFF,'')
		   END AS TRAN_UPDS,
		   NULL AS TRAN_COMMENTS,
		   'BED STAFF' AS UPDATE_TYPE
	FROM #BEDSTAFF H_BSTAFF
	LEFT JOIN #BEDSTAFF AS PREVIOUS_H_BSTAFF ON
	PREVIOUS_H_BSTAFF.BED_UID = H_BSTAFF.BED_UID AND
	PREVIOUS_H_BSTAFF.PK < H_BSTAFF.PK
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E5 ON E5.IDENTIFIER = H_BSTAFF.BED_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED ON BED.PFK_PLACE = E5.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E6 ON E6.IDENTIFIER = H_BSTAFF.PATIENT_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PERSON AS PERSON ON PERSON.PFK_PERSON = E6.PK_ENTITY
	LEFT JOIN BMS_EIS.dbo.EHL7_UID AS S1 ON S1.FK_ENTITY = PERSON.PFK_PERSON AND S1.IDENTIFIER_ROOT = 'SSN'
	LEFT JOIN BMS_HISTORY.dbo.USER_H UH ON H_BSTAFF.CREATED_BY = UH.SID

	CREATE TABLE #BRCH(
		PK int,
		BED_REASON_COMMENT_HISTORY_ID int,
		DIVISION_UID uniqueidentifier,
		BED_UID uniqueidentifier,
		VISTA_SITE_UID uniqueidentifier,
		COMMENT nvarchar(max),
		TYPE_ID int,
		REASON_ID int,
		CREATION_DATE datetime,
		CREATION_BY nvarchar(250),
		EDITED_BY nvarchar(250),
		EDITED_DATE datetime,
		EXPECTED_COMPLETED_DATE datetime,
		COMPLETED_BY nvarchar(250),
		COMPLETED_DATE datetime,
		TRANSACTION_TYPE_CODE varchar(50),
		DATE datetime,
		CREATED_BY nvarchar(50),
		ACTION_TYPE varchar(20)
	)

	INSERT #BRCH
		SELECT  PK,
				BED_REASON_COMMENT_HISTORY_ID,
				DIVISION_UID,
				BED_UID,
				VISTA_SITE_UID,
				BRCH.COMMENT,
				TYPE_ID,
				REASON_ID,
				CREATION_DATE,
				CREATION_BY,
				EDITED_BY,
				EDITED_DATE,
				EXPECTED_COMPLETED_DATE,
				COMPLETED_BY,
				COMPLETED_DATE,
				TRANSACTION_TYPE_CODE,
				DATE,
				CREATED_BY,
				CASE WHEN BRCH.TRANSACTION_TYPE_CODE = 'I' THEN 'NEW RECORD' 
				 WHEN BRCH.TRANSACTION_TYPE_CODE = 'U' THEN 'UPDATED'
				 WHEN BRCH.TRANSACTION_TYPE_CODE = 'D' THEN 'DELETED' END
			AS ACTION_TYPE
		FROM BED_REASON_COMMENT_HISTORY_H BRCH
		INNER JOIN BMS_DW.dbo.DIM_BED BED ON BRCH.BED_UID = BED.SOURCE_ID
		INNER JOIN BMS_DW.dbo.GROUP_BED_WARDGROUP as GBWG ON GBWG.DIM_BED_ID = BED.ID
		INNER JOIN #WARDS WARDS ON GBWG.DIM_WARDGROUP_ID =WARDS.WARD_ID
	
	INSERT INTO #WBHISTORY
	SELECT DISTINCT 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BRCH.DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BRCH.DATE), 108) as ENTERED_DATE, 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BRCH.COMPLETED_DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_BRCH.COMPLETED_DATE), 108) AS COMPLETED_DATE,	
		   NULL AS EDITED,
		   
		  --MODIFICATION BY JP 06/08/16
		   CASE WHEN H_BRCH.ACTION_TYPE = 'NEW RECORD' Then H_BRCH.CREATION_BY
		        WHEN H_BRCH.ACTION_TYPE = 'UPDATED' and H_BRCH.COMPLETED_BY is not null and H_BRCH.EDITED_BY is null 
					Then H_BRCH.COMPLETED_BY
				 WHEN H_BRCH.ACTION_TYPE = 'UPDATED' and H_BRCH.EDITED_BY is not null and H_BRCH.COMPLETED_BY is null 
					Then H_BRCH.EDITED_BY
				WHEN H_BRCH.ACTION_TYPE = 'UPDATED' and H_BRCH.EDITED_BY is not null and H_BRCH.COMPLETED_BY is not null 
					Then H_BRCH.COMPLETED_BY
				END as EDITED_BY,
		   --H_BRCH.EDITED_BY,

		   NULL AS PATIENT_NAME,
		   BED.NAME as BED_NAME,
		   NULL AS ACT_ID,
		   H_BRCH.ACTION_TYPE,
		   CASE WHEN H_BRCH.TRANSACTION_TYPE_CODE IN ('I','U', 'D') THEN
		   CASE WHEN H_BRCH.COMPLETED_DATE <> PREVIOUS_H_BRCH.COMPLETED_DATE OR (H_BRCH.COMPLETED_DATE IS NULL AND PREVIOUS_H_BRCH.COMPLETED_DATE IS NOT NULL) OR (H_BRCH.COMPLETED_DATE IS NOT NULL AND PREVIOUS_H_BRCH.COMPLETED_DATE IS NULL) 
		   THEN 'COMPLETED DATE FROM ' + CASE WHEN PREVIOUS_H_BRCH.COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),PREVIOUS_H_BRCH.COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),PREVIOUS_H_BRCH.COMPLETED_DATE,108), '') + ' ' + ISNULL(right(convert(varchar(30),PREVIOUS_H_BRCH.COMPLETED_DATE,109),2),'') END +
				' TO ' + CASE WHEN H_BRCH.COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),H_BRCH.COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),H_BRCH.COMPLETED_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),H_BRCH.COMPLETED_DATE,109),2),'') + char(13)+char(10) END ELSE '' END + ' ' +
		   CASE WHEN H_BRCH.EXPECTED_COMPLETED_DATE <> PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE OR (H_BRCH.EXPECTED_COMPLETED_DATE IS NULL AND PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE IS NOT NULL) OR (H_BRCH.EXPECTED_COMPLETED_DATE IS NOT NULL AND PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE IS NULL) 
		   THEN 'EXPECTED COMPLETED DATE FROM ' + CASE WHEN PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE,108), '') + ' ' + ISNULL(right(convert(varchar(30),PREVIOUS_H_BRCH.EXPECTED_COMPLETED_DATE,109),2),'') END +
				' TO ' + CASE WHEN H_BRCH.EXPECTED_COMPLETED_DATE IS NULL THEN '<Empty>' ELSE ISNULL(convert(varchar(20),H_BRCH.EXPECTED_COMPLETED_DATE,101), '') + ' ' + ISNULL(convert(varchar(20),H_BRCH.EXPECTED_COMPLETED_DATE,108),'') + ' ' + ISNULL(right(convert(varchar(30),H_BRCH.EXPECTED_COMPLETED_DATE,109),2),'') + char(13)+char(10) END ELSE '' END + ' ' +		   
     	   CASE WHEN H_BRCH.TYPE_ID <> PREVIOUS_H_BRCH.TYPE_ID --OR (H_BRCH.TYPE_ID IS NULL AND PREVIOUS_H_BRCH.TYPE_ID IS NOT NULL) OR (H_BRCH.TYPE_ID IS NOT NULL AND PREVIOUS_H_BRCH.TYPE_ID IS NULL)
		   THEN  'TYPE FROM ' + ISNULL(TYPECODE.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(TYPECODE.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' '+
		   CASE WHEN H_BRCH.REASON_ID <> PREVIOUS_H_BRCH.REASON_ID --OR (H_BRCH.REASON_ID IS NULL AND PREVIOUS_H_BRCH.REASON_ID IS NOT NULL) OR (H_BRCH.REASON_ID IS NOT NULL AND PREVIOUS_H_BRCH.REASON_ID IS NULL)
		   THEN  'REASON FROM ' + ISNULL(REASON.DISPLAY_NAME,'<EMPTY>') + ' TO ' + ISNULL(REASON.DISPLAY_NAME,'') + char(13)+char(10) ELSE '' END + ' ' +
		   CASE WHEN H_BRCH.COMPLETED_BY <> PREVIOUS_H_BRCH.COMPLETED_BY OR (H_BRCH.COMPLETED_BY IS NULL AND PREVIOUS_H_BRCH.COMPLETED_BY IS NOT NULL) OR (H_BRCH.COMPLETED_BY IS NOT NULL AND PREVIOUS_H_BRCH.COMPLETED_BY IS NULL)
		   THEN  'COMPLETED BY FROM ' + ISNULL(PREVIOUS_H_BRCH.COMPLETED_BY,'<EMPTY>') + ' TO ' + ISNULL(H_BRCH.COMPLETED_BY,'') + char(13)+char(10) ELSE '' END
		   END AS TRAN_UPDS,
		   CASE WHEN H_BRCH.COMMENT <> PREVIOUS_H_BRCH.COMMENT OR (H_BRCH.COMMENT IS NULL AND PREVIOUS_H_BRCH.COMMENT IS NOT NULL) OR (H_BRCH.COMMENT IS NOT NULL AND PREVIOUS_H_BRCH.COMMENT IS NULL)
		   THEN  'COMMENT FROM ' + ISNULL(PREVIOUS_H_BRCH.COMMENT,'<EMPTY>') + ' TO ' + ISNULL(H_BRCH.COMMENT,'') + char(13)+char(10) ELSE '' END  AS TRAN_COMMENTS,
		   'BED REASON COMMENT' AS UPDATE_TYPE
	FROM #BRCH H_BRCH
	LEFT JOIN #BRCH AS PREVIOUS_H_BRCH ON
	PREVIOUS_H_BRCH.BED_UID = H_BRCH.BED_UID AND
	PREVIOUS_H_BRCH.PK < H_BRCH.PK
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E5 ON E5.IDENTIFIER = H_BRCH.BED_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED ON BED.PFK_PLACE = E5.PK_ENTITY
	LEFT JOIN CONCEPT_H as REASON ON H_BRCH.REASON_ID = REASON.ID AND REASON.CODE_SYSTEM_NAME = 'UnavailableReason'
	LEFT JOIN CONCEPT_H as TYPECODE ON H_BRCH.TYPE_ID = TYPECODE.ID AND TYPECODE.CODE_SYSTEM_NAME = 'AdminURType'
	--WHERE H_BRCH.COMMENT IS NOT NULL AND H_BRCH.TRANSACTION_TYPE_CODE <> 'N'

	CREATE TABLE #IAH(
	PK int,
	BED_UID uniqueidentifier,
	PATIENT_UID uniqueidentifier,
	ICON_FLAG_ID int,
	ICON_FLAG_FACILITY_ID int,
	TRANSACTION_TYPE_CODE varchar(50),
	DATE datetime,
	CREATED_BY nvarchar(50),
	ACTION_TYPE varchar(20),
	ICON_NAME varchar(150),
	FACILITY_ICON_NAME varchar(150),
	FACILITY_UID uniqueidentifier
	)

	INSERT INTO #IAH
	SELECT  IAH.PK,
			BED_UID,
			PATIENT_UID,
			IAH.ICON_FLAG_ID,
			IAH.ICON_FLAG_FACILITY_ID,
			IAH.TRANSACTION_TYPE_CODE,
			IAH.DATE,
			IAH.CREATED_BY,
			CASE WHEN IAH.TRANSACTION_TYPE_CODE = 'I' THEN 'NEW RECORD' 
				 WHEN IAH.TRANSACTION_TYPE_CODE = 'U' THEN 'UPDATED'
				 WHEN IAH.TRANSACTION_TYPE_CODE = 'D' THEN 'DELETED' END
			AS ACTION_TYPE,
			FLAG.ICON_NAME,
			FLAG_F.ICON_NAME as FACILITY_ICON_NAME,
			FLAG_FAC.FACILITY_UID
	FROM ICON_ASSOCIATION_H IAH
	LEFT JOIN ICON_FLAG_H FLAG
	ON IAH.ICON_FLAG_ID = FLAG.ID
	LEFT JOIN ICON_FLAG_FACILITY_H FLAG_FAC
	ON IAH.ICON_FLAG_FACILITY_ID = FLAG_FAC.ID
	LEFT JOIN ICON_FLAG_H FLAG_F
	ON FLAG_FAC.ICON_FLAG_ID = FLAG_F.ID

	INSERT #WBHISTORY
	SELECT DISTINCT 
		   CONVERT(VARCHAR, DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_IAH.DATE), 101) + ' ' 
			 + CONVERT(VARCHAR(5), DATEADD (minute, @TIME_ZONE_MINUTES_OFFSET, H_IAH.DATE), 108) as ENTERED_DATE, 
		   NULL AS COMPLETED_DATE,	
		   NULL AS EDITED,
		   UH.NAME AS CREATED_BY,
		   NULL AS PATIENT_NAME,
		   BED.NAME as BED_NAME,
		   NULL AS ACT_ID,
		   H_IAH.ACTION_TYPE,
		   CASE WHEN H_IAH.TRANSACTION_TYPE_CODE = 'U' THEN
     		CASE WHEN H_IAH.ICON_FLAG_ID <> PREVIOUS_H_IAH.ICON_FLAG_ID OR (H_IAH.ICON_FLAG_ID IS NULL AND PREVIOUS_H_IAH.ICON_FLAG_ID IS NOT NULL) OR (H_IAH.ICON_FLAG_ID IS NOT NULL AND PREVIOUS_H_IAH.ICON_FLAG_ID IS NULL)
			THEN  'ICON FROM ' + ISNULL(PREVIOUS_H_IAH.ICON_NAME,'<EMPTY>') + ' TO ' + ISNULL(H_IAH.ICON_NAME,'') + char(13)+char(10) END
		   ELSE 
				ISNULL(H_IAH.ICON_NAME, H_IAH.FACILITY_ICON_NAME)
		   END as TRAN_UPDS,
		   NULL as TRAN_COMMENTS,
		   'ICON ASSOCIATION' as UPDATE_TYPE
	FROM #IAH H_IAH
	LEFT JOIN #IAH AS PREVIOUS_H_IAH ON
	PREVIOUS_H_IAH.BED_UID = H_IAH.BED_UID AND
	PREVIOUS_H_IAH.PK < H_IAH.PK
	LEFT JOIN BMS_EIS.dbo.ENTITY AS E1 ON E1.IDENTIFIER = H_IAH.BED_UID
	LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED ON BED.PFK_PLACE = E1.PK_ENTITY
	LEFT JOIN BMS_DW.dbo.DIM_BED as BED2 on BED2.SOURCE_ID = H_IAH.BED_UID
	LEFT JOIN BMS_DW.dbo.GROUP_BED_WARDGROUP as GBWG ON GBWG.DIM_BED_ID = BED2.ID
	INNER JOIN #WARDS WARDS ON GBWG.DIM_WARDGROUP_ID = WARDS.WARD_ID
	LEFT JOIN BMS_HISTORY.dbo.USER_H UH ON H_IAH.CREATED_BY = UH.SID

	SELECT * FROM #WBHISTORY

	--SELECT * FROM #WARDS
	--SELECT * FROM #BEDUNAVAILABLE

	DROP TABLE #WBHISTORY
	DROP TABLE #BEDUNAVAILABLE
	DROP TABLE #BEDSTAFF
	DROP TABLE #TBL_FACILITY
	DROP TABLE #WARDS
	DROP TABLE #BRCH
	DROP TABLE #IAH
END
END
GO


