USE [BMS_HISTORY]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_IconUsageHistory_Audit]    Script Date: 6/14/2016 9:13:31 AM ******/
DROP PROCEDURE [dbo].[usp_Rpt_IconUsageHistory_Audit]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_IconUsageHistory_Audit]    Script Date: 6/14/2016 9:13:31 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



--exec usp_Rpt_IconUsageHistory_Audit @UserID=N'aac.dva.DNS   \bms_svc_sqa',@FACILITIES_IDS=N'144;143_1,145;142_2,146;141_3,147;140_4,148;139_5,149;138_6,150;137_7,151;136_8,161;135_9,162;134_10,163;133_11,164;132_12,165;131_13,166;130_14,167;129_15,168;128_16,169;127_17,170;126_18,171;125_19,172;124_20,173;123_21,174;122_22,175;121_23,176;120_24,177;119_25,178;118_26,179;117_27,180;116_28,181;115_29,182;114_30,183;113_31,184;112_32,185;111_33,186;110_34,187;109_35,188;108_36,189;107_37,190;106_38,191;105_39,192;104_40,193;103_41,194;102_42,195;101_43,196;100_44,197;99_45,198;98_46,199;97_47,200;96_48,201;95_49,202;94_50,203;93_51,204;92_52,205;91_53,206;90_54,207;89_55,208;88_56,209;87_57,210;86_58,211;85_59,212;84_60,213;83_61,214;82_62,215;81_63,216;80_64,217;79_65,218;78_66,219;77_67,220;76_68,221;75_69,222;74_70,223;73_71,224;72_72,225;71_73,226;70_74,227;69_75,228;68_76,229;67_77,230;66_78,231;65_79,232;64_80,233;63_81,234;62_82,235;61_83,236;60_84,237;59_85,238;58_86,239;57_87,240;56_88,241;55_89,242;54_90,243;53_91,244;52_92,245;51_93,246;50_94,247;49_95,248;48_96,249;47_97,250;46_98,251;45_99,252;44_100,253;43_101,254;42_102,255;41_103,256;40_104,257;39_105,258;38_106,259;37_107,260;36_108,261;35_109,262;34_110,263;33_111,264;32_112,265;31_113,266;30_114,267;29_115,268;28_116,269;27_117,270;26_118,271;25_119,272;24_120,273;23_121,274;22_122,275;21_123,276;20_124,277;19_125,278;18_126,279;17_127,280;16_128,281;15_129,282;14_130,283;13_131,284;12_132,285;11_133,286;10_134,287;9_135,295;8_136,296;7_137,297;6_138,298;5_139,299;4_140,300;3_141,301;2_142,302;1_143',@DATE_FROM = '1/1/2008', @DATE_TO='12/29/2016'
--exec usp_Rpt_IconUsageHistory_Audit_Test @UserID=N'DNS   HORND@DNS           ',@FACILITIES_IDS=N'155;141_3,157;139_5,154;142_2,158;138_6,159;137_7,160;136_8,161;135_9,162;134_10,163;133_11,156;140_4,164;132_12,165;131_13,166;130_14,167;129_15,168;128_16,169;127_17,170;126_18,171;125_19,172;124_20,173;123_21,174;122_22,175;121_23,176;120_24,177;119_25,178;118_26,179;117_27,180;116_28,181;115_29,182;114_30,183;113_31,184;112_32,185;111_33,186;110_34,187;109_35,188;108_36,189;107_37,190;106_38,191;105_39,192;104_40,193;103_41,194;102_42,195;101_43,196;100_44,197;99_45,198;98_46,199;97_47,200;96_48,201;95_49,202;94_50,203;93_51,204;92_52,205;91_53,206;90_54,207;89_55,208;88_56,209;87_57,210;86_58,211;85_59,212;84_60,213;83_61,214;82_62,215;81_63,216;80_64,217;79_65,218;78_66,219;77_67,220;76_68,221;75_69,222;74_70,223;73_71,224;72_72,225;71_73,226;70_74,227;69_75,228;68_76,229;67_77,230;66_78,231;65_79,232;64_80,233;63_81,234;62_82,235;61_83,236;60_84,237;59_85,238;58_86,239;57_87,240;56_88,241;55_89,242;54_90,243;53_91,244;52_92,245;51_93,246;50_94,247;49_95,248;48_96,249;47_97,250;46_98,251;45_99,252;44_100,253;43_101,254;42_102,255;41_103,256;40_104,257;39_105,258;38_106,259;37_107,260;36_108,261;35_109,262;34_110,263;33_111,264;32_112,265;31_113,266;30_114,267;29_115,295;1_143,268;28_116,269;27_117,270;26_118,271;25_119,272;24_120,273;23_121,274;22_122,153;143_1,275;21_123,276;20_124,277;19_125,278;18_126,279;17_127,280;16_128,281;15_129,282;14_130,283;13_131,284;12_132,285;11_133,286;10_134,287;9_135,288;8_136,289;7_137,290;6_138,291;5_139,292;4_140,293;3_141,294;2_142',@DATE_FROM='2016-03-07 00:00:01',@DATE_TO='2016-05-09 23:59:59'
CREATE PROCEDURE [dbo].[usp_Rpt_IconUsageHistory_Audit] 
	@UserID NVARCHAR(500),
	@FACILITIES_IDS NVARCHAR(MAX) = '',
	@DATE_FROM DATETIME,
	@DATE_TO DATETIME,
	@REPORT_TYPE NVARCHAR(50)

AS
BEGIN
IF (@REPORT_TYPE = 'IconUsage')
BEGIN
	/*SELECT NULL as CODE, NULL as [DESCRIPTION], NULL as FLAG_ID, NULL as ICON_NAME, NULL as ACTIVE, NULL as PT_REC, 
		   NULL as BED_REC, NULL as IMAGE_BYTES, NULL as SHORT_DESCRIPTION, NULL as IMAGE_NAME, NULL as SUBGROUP,
		   NULL as WARD, NULL as BED, NULL as PATIENT */

	DECLARE @TBL_FACILITY TABLE (ID INT PRIMARY KEY)
	DECLARE @TBL_ICON_TYPE TABLE (CODE VARCHAR(250) PRIMARY KEY)
						 
	INSERT INTO @TBL_FACILITY(ID) 
	SELECT CASE WHEN CHARINDEX(';',F.ID) > 0 THEN CAST(SUBSTRING(F.ID,1, CHARINDEX(';',F.ID) -1) AS INT) 
			    ELSE CAST(F.ID AS INT) 
		   END
	FROM (SELECT  VALUE AS ID FROM dbo.ufn_Split(@FACILITIES_IDS, ','))F

/*
	INSERT INTO @TBL_ICON_TYPE(CODE) 
	SELECT CONVERT(VARCHAR(20), VALUE) FROM dbo.ufn_Split(@ICON_TYPES, ',')
	
	declare @TBL_ICONS table (id int PRIMARY KEY)
	
	insert into @TBL_ICONS(id)
	select case when charindex(';',code) > 0 then 
			substring(code,1,charindex(';',code) -1) 
			else code end
	from @TBL_ICON_TYPE
	where charindex('-2',code) > 0 -- for standard icons
	
	if exists (select id from @TBL_ICONS where id = -2)
	begin
		insert into @TBL_ICONS
		select id from BMS_DW.dbo.dim_icon_flag 
		where id not in (select id from @TBL_ICONS)
				
		delete from @TBL_ICONS
		where id = -2		
	
	end
	*/
	
	IF EXISTS(SELECT 1  FROM @TBL_FACILITY)
		BEGIN
		
		CREATE TABLE #TBL_TEMP 
		(
			ID INT IDENTITY(1,1) PRIMARY KEY,
			CODE_B NVARCHAR(250),
			CODE_P NVARCHAR(250),
			FLAG_ID INT,
			[DESCRIPTION] NVARCHAR(250), 
			ICON_NAME NVARCHAR(250), 
			ACTIVE CHAR(1), 
			PT_REC NVARCHAR(10), 
			BED_REC NVARCHAR(10),
			IMAGE_BYTES nvarchar(max),
			SHORT_DESCRIPTION NVARCHAR(250),
			IMAGE_NAME nvarchar(250),
			SUBGROUP nvarchar(250),
			PATIENT_P nvarchar(250),
			PATIENT_B nvarchar(250),
			BED_B nvarchar(20),
			WARD_B nvarchar(100),
			BED_P nvarchar(20),
			WARD_P nvarchar(100)
		)

		INSERT INTO #TBL_TEMP(CODE_B, CODE_P, FLAG_ID, ICON_NAME, [DESCRIPTION],  ACTIVE, PT_REC, BED_REC, IMAGE_BYTES, 
							  SHORT_DESCRIPTION, IMAGE_NAME, SUBGROUP, PATIENT_P, PATIENT_B, BED_B, WARD_B, BED_P, WARD_P)		
			SELECT 	SUBSTRING(ORG_B.NAME, 4,3) as CODE_B,
				SUBSTRING(ORG_P.NAME, 4,3) AS CODE_P, 
				ICON_FLAG.ID as FLAG_ID, 
				RTRIM(ICON_FLAG.[SHORT_DESCRIPTION]) as [DESCRIPTION],
				RTRIM(ICON_FLAG.ICON_NAME) as ICON_NAME,
				'Y' AS ACTIVE, 
				CASE WHEN ICON_ASSOCIATION.PATIENT_UID IS NOT NULL THEN 'Y' ELSE 'N' END AS PT_REC,
				CASE WHEN ICON_ASSOCIATION.BED_UID IS NOT NULL THEN 'Y' ELSE 'N' END AS BED_REC,
				ICON_FLAG.IMAGE_BYTES,
				RTRIM(ICON_FLAG.SHORT_DESCRIPTION),
				ICON_FLAG.IMAGE_NAME,
				RTRIM(ICON_FLAG.SUBGROUP),
				PERSON_P.[NAME_FAMILY] + SUBSTRING(S1.[IDENTIFIER_EXTENSION], 7, 5) AS PATIENT_P,
				PERSON_B.[NAME_FAMILY] + SUBSTRING(S2.[IDENTIFIER_EXTENSION], 7, 5) AS PATIENT_B,
				BED_PLACEB.NAME AS BED_B,
				WARD_PLACEB.NAME AS WARD_B,
				BED_PLACEP.NAME AS BED_P,
				WARD_PLACEP.NAME as WARD_P
			FROM ICON_ASSOCIATION_H AS ICON_ASSOCIATION
			INNER JOIN ICON_FLAG_H ICON_FLAG ON ICON_ASSOCIATION.ICON_FLAG_ID = ICON_FLAG.ID
			LEFT JOIN ADMISSION_EVN_H ADM_B ON ICON_ASSOCIATION.BED_UID = ADM_B.BED_UID
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E1 ON E1.IDENTIFIER = ICON_ASSOCIATION.PATIENT_UID
			LEFT JOIN BMS_EIS.dbo.EHL7_PERSON AS PERSON_P ON PERSON_P.PFK_PERSON = E1.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.EHL7_UID AS S1 ON S1.FK_ENTITY = PERSON_P.PFK_PERSON AND S1.IDENTIFIER_ROOT = 'SSN'
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E2 ON E2.IDENTIFIER = ICON_ASSOCIATION.BED_UID
			LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED_PLACEB ON BED_PLACEB.PFK_PLACE = E2.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E3 ON E3.IDENTIFIER = ADM_B.WARD_UID
			LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS WARD_PLACEB ON WARD_PLACEB.PFK_PLACE =E3.PK_ENTITY
			LEFT JOIN ADMISSION_EVN_H ADM_P ON ICON_ASSOCIATION.PATIENT_UID = ADM_P.PATIENT_UID
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E4 ON E4.IDENTIFIER = ADM_P.BED_UID 
			LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS BED_PLACEP ON BED_PLACEP.PFK_PLACE = E4.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E5 ON E5.IDENTIFIER = ADM_P.WARD_UID 
			LEFT JOIN BMS_EIS.dbo.EHL7_PLACE AS WARD_PLACEP ON WARD_PLACEP.PFK_PLACE = E5.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E6 ON E6.IDENTIFIER = ADM_B.VISTA_SITE_UID
			LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION ORG_B ON ORG_B.PFK_ORGANIZATION = E6.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E7 ON E7.IDENTIFIER = ADM_P.VISTA_SITE_UID
			LEFT JOIN BMS_EIS.dbo.EHL7_ORGANIZATION ORG_P ON ORG_P.PFK_ORGANIZATION = E7.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.ENTITY AS E8 ON E8.IDENTIFIER = ADM_B.PATIENT_UID
			LEFT JOIN BMS_EIS.dbo.EHL7_PERSON AS PERSON_B ON PERSON_B.PFK_PERSON = E8.PK_ENTITY
			LEFT JOIN BMS_EIS.dbo.EHL7_UID AS S2 ON S2.FK_ENTITY = PERSON_B.PFK_PERSON AND S2.IDENTIFIER_ROOT = 'SSN'
		WHERE ICON_ASSOCIATION.DATE BETWEEN @DATE_FROM AND @DATE_TO 

		--select * from #TBL_TEMP
			
		-- count how many patients or beds have the icon associated
		
/*		SELECT RESULT.CODE, RESULT.[DESCRIPTION], RESULT.FLAG_ID, RESULT.ICON_NAME, RESULT.ACTIVE, RESULT.PT_REC, RESULT.BED_REC, 
			IMAGE_BYTES, SHORT_DESCRIPTION, IMAGE_NAME, SUBGROUP, WARD, BED, PATIENT
		FROM ( */
		select ISNULL(ISNULL(CODE_B, CODE_P), 'N/A') AS CODE, 
			   --[DESCRIPTION], 
			   FLAG_ID, 
			   ICON_NAME, 
			   ACTIVE,
			   PT_REC,
			   BED_REC,
			   IMAGE_BYTES,
			   --SHORT_DESCRIPTION,
			   IMAGE_NAME,
			   --SUBGROUP,
			   ISNULL(ISNULL(WARD_B, WARD_P), '') as WARD,
			   ISNULL(ISNULL(BED_B, BED_P), '') as BED,
			   ISNULL(ISNULL(PATIENT_B, PATIENT_P), '') as PATIENT
		from #TBL_TEMP 
		group by ISNULL(CODE_B, CODE_P), FLAG_ID, ICON_NAME, ACTIVE, BED_REC, PT_REC, IMAGE_BYTES,  IMAGE_NAME, ISNULL(WARD_B, WARD_P),ISNULL(PATIENT_B, PATIENT_P),
		--[DESCRIPTION], SHORT_DESCRIPTION, SUBGROUP,
			   ISNULL(BED_B, BED_P) /*) RESULT */
		order by CODE, ICON_NAME
		
		DROP TABLE #TBL_TEMP
		
	END
END
END


GO


