USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetVisn]    Script Date: 6/14/2016 9:10:24 AM ******/
DROP PROCEDURE [dbo].[usp_GetVisn]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetVisn]    Script Date: 6/14/2016 9:10:24 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[usp_GetVisn]
	@USER_NAME NVARCHAR(100)
AS
BEGIN
		
	-- create permission table
	CREATE TABLE #PERMISSION
        (
         DIM_ORGANIZATION_ID INT,
         DIM_WARD_ID INT
        )
    
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
	
	DECLARE @DIM_ORGANIZATION_TYPE_ID int
	SET @DIM_ORGANIZATION_TYPE_ID = (SELECT ID
	FROM DIM_ORGANIZATION_TYPE
	WHERE CODE='VISN')
	
	SELECT DISTINCT VISN.ID AS ID, VISN.NAME AS NAME, cast(VISN.CODE as int) as CODE
	FROM DIM_ORGANIZATION AS VISN 
		INNER JOIN 
		(
			#PERMISSION P INNER JOIN DIM_ORGANIZATION AS FACILITY ON FACILITY.ID = P.DIM_ORGANIZATION_ID
			INNER JOIN DIM_ORGANIZATION AS VISTA_SITE ON FACILITY.DIM_ORGANIZATION_ID = VISTA_SITE.ID
		) ON VISN.ID = VISTA_SITE.DIM_ORGANIZATION_ID
	
	WHERE VISN.DIM_ORGANIZATION_TYPE_ID = @DIM_ORGANIZATION_TYPE_ID
	ORDER BY cast(VISN.CODE as int)
END


GO


