﻿using BMS.ServiceContracts;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;
using BMS.ServicesWrapper.BMService;

namespace BMS.UnitTesting
{        
    /// <summary>
    ///This is a test class for BedManagerOperations and is intended
    ///to contain all BedManagerOperations Unit Tests
    ///</summary>
    [TestClass()]
    public class BedManagerOperations
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            ServicesControl.Init();
        }
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        internal virtual IBedManagerOperations CreateIBedManagerOperations()
        {
            IBedManagerOperations target = BMSFactory.BedManagerOperationsClient;
            return target;
        }

        /// <summary>
        /// Test method for creating a new discharge act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new discharge act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateDischarge()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            //intent
            Discharge dischargeIntent = Builders.BuildDischargeIntent(4);
            II id = target.CreateDischarge(dischargeIntent);
            Discharge dischargeIntentResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(dischargeIntent, dischargeIntentResult));
            //request
            Discharge dischargeRequest = Builders.BuildDischargeRequest(4);
            dischargeRequest.Parent = new Act() { Id = id };
            id = target.CreateDischarge(dischargeRequest);
            Discharge dischargeRequestResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(dischargeRequest, dischargeRequestResult));
            //event
            Discharge dischargeEvent = Builders.BuildDischargeEvent(4);
            dischargeEvent.Parent = new Act() { Id = id };
            id = target.CreateDischarge(dischargeEvent);
            Discharge dischargeEventResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(dischargeEvent, dischargeEventResult));
        }

        /// <summary>
        /// Test method for creating a new bed out of service event.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new bed out of service event.")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateBedOutOfServiceEvent()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            BedUnavailable bedOutOfServiceEvent = Builders.BuildBedOutOfServiceEvent(1);
            II id = target.CreateBedUnavailable(bedOutOfServiceEvent);
            BedUnavailable bedOutOfServiceEventResult = target.GetBedUnavailable(id, null);
            Assert.IsTrue(new BedOutOfServiceEventComparer().Equals(bedOutOfServiceEvent, bedOutOfServiceEventResult));
        }

        /// <summary>
        /// Test method for creating a new bed cleaning operation.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new bed cleaning operation.")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateBedCleaningOperation()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            BedCleaningOperation bedCleaningOperation = Builders.BuildBedCleaningOperation(1);
            II id = target.CreateBedCleaningOperation(bedCleaningOperation);
            BedCleaningOperation bedCleaningOperationResult = target.GetBedCleaningOperation(id, null);
            Assert.IsTrue(new BedCleaningOperationComparer().Equals(bedCleaningOperation, bedCleaningOperationResult));
        }

        /// <summary>
        /// Test method for creating a new admission act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new admission act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateAdmission()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            //intent
            Admission admissionIntent = Builders.BuildAdmissionIntent(1);
            II id = target.CreateAdmission(admissionIntent);
            Admission admissionIntentResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(admissionIntent, admissionIntentResult));
            //request
            Admission admissionRequest = Builders.BuildAdmissionRequest(1);
            admissionRequest.Parent = new Act() { Id = id };
            id = target.CreateAdmission(admissionRequest);
            Admission admissionRequestResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(admissionRequest, admissionRequestResult));
            //event
            Admission admissionEvent = Builders.BuildAdmissionEvent(1);
            admissionEvent.Parent = new Act() { Id = id };
            id = target.CreateAdmission(admissionEvent);
            Admission admissionEventResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(admissionEvent, admissionEventResult));
        }

        /// <summary>
        /// Test method for creating a new diversion record.
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new diversion record.")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateDiversion()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            Diversion diversion = Builders.BuildDiversion(1);
            II id = target.CreateDiversion(diversion);
            Diversion diversionResult = target.GetDiversion(id);
            diversion.Location = null;
            Assert.IsTrue(new DiversionComparer().Equals(diversion, diversionResult));
        }

        /// <summary>
        /// Test method for creating a new transfer act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new transfer act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateTransfer()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            II id = null;
            ////intent
            //Transfer transferIntent = Builders.BuildTransferIntent(1);
            //II id = target.CreateTransfer(transferIntent);
            //Transfer transferIntentResult = target.GetTransfer(id);
            //Assert.IsTrue(new TransferComparer().Equals(transferIntent, transferIntentResult));
            //request
            Transfer transferRequest = Builders.BuildTransferRequest(1);
            //canceled date , adimissionFacility, dispositionDate and disposition makes sense only for transfer events.
            transferRequest.CanceledDate = null;
            transferRequest.AdmissionFacility = null;
            transferRequest.DispositionDate = null;
            transferRequest.Disposition = null;
            //transferRequest.Parent = new Act() { Id = id };
            id = target.CreateTransfer(transferRequest);
            Transfer transferRequestResult = target.GetTransfer(id);
            Assert.IsTrue(new TransferComparer().Equals(transferRequest, transferRequestResult));
            //event
            Transfer transferEvent = Builders.BuildTransferEvent(1);
            transferEvent.Parent = new Act() { Id = id };
            id = target.CreateTransfer(transferEvent);
            Transfer transferEventResult = target.GetTransfer(id);
            transferEvent.CanceledDate = null;
            Assert.IsTrue(new TransferComparer().Equals(transferEvent, transferEventResult));
        }

        /// <summary>
        /// Test method for modifying an existing admission act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing admission act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateAdmission()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            //intent
            Admission admissionIntent = Builders.BuildAdmissionIntent(2);
            II id = target.CreateAdmission(admissionIntent);
            Admission admissionIntentResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(admissionIntent, admissionIntentResult));

            Admission newAdmissionIntent = Builders.BuildAdmissionIntent(3);
            newAdmissionIntent.Id = admissionIntentResult.Id;
            target.UpdateAdmission(newAdmissionIntent);

            Admission newAdmissionIntentResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(newAdmissionIntent, newAdmissionIntentResult));
            //request
            Admission admissionRequest = Builders.BuildAdmissionRequest(2);
            id = target.CreateAdmission(admissionRequest);
            Admission admissionRequestResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(admissionRequest, admissionRequestResult));

            Admission newAdmissionRequest = Builders.BuildAdmissionRequest(3);
            newAdmissionRequest.Id = admissionRequestResult.Id;
            target.UpdateAdmission(newAdmissionRequest);

            Admission newAdmissionRequestResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(newAdmissionRequest, newAdmissionRequestResult));
            //event
            Admission admissionEvent = Builders.BuildAdmissionEvent(2);
            id = target.CreateAdmission(admissionEvent);
            Admission admissionEventResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(admissionEvent, admissionEventResult));

            Admission newAdmissionEvent = Builders.BuildAdmissionEvent(3);
            newAdmissionEvent.Id = admissionEventResult.Id;
            target.UpdateAdmission(newAdmissionEvent);

            Admission newAdmissionEventResult = target.GetAdmission(id);
            Assert.IsTrue(new AdmissionComparer().Equals(newAdmissionEvent, newAdmissionEventResult));
        }

        /// <summary>
        /// Test method for modifying an existing bed cleaning operation.
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing bed cleaning operation.")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateBedCleaningOperation()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            BedCleaningOperation bedCleaningOperation = Builders.BuildBedCleaningOperation(2);
            II id = target.CreateBedCleaningOperation(bedCleaningOperation);
            BedCleaningOperation bedCleaningOperationResult = target.GetBedCleaningOperation(id, null);
            Assert.IsTrue(new BedCleaningOperationComparer().Equals(bedCleaningOperation, bedCleaningOperationResult));

            BedCleaningOperation newBedCleaningOperation = Builders.BuildBedCleaningOperation(3);
            newBedCleaningOperation.Id = bedCleaningOperationResult.Id;
            target.UpdateBedCleaningOperation(newBedCleaningOperation);

            BedCleaningOperation newBedCleaningOperationResult = target.GetBedCleaningOperation(id, null);
            Assert.IsTrue(new BedCleaningOperationComparer().Equals(newBedCleaningOperation, newBedCleaningOperationResult));
        }

        /// <summary>
        /// Test method for modifying an existing bed out of service event.
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing bed out of service event.")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateBedOutOfServiceEvent()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            BedUnavailable bedOutOfServiceEvent = Builders.BuildBedOutOfServiceEvent(2);
            II id = target.CreateBedUnavailable(bedOutOfServiceEvent);
            BedUnavailable bedOutOfServiceEventResult = target.GetBedUnavailable(id, null);
            Assert.IsTrue(new BedOutOfServiceEventComparer().Equals(bedOutOfServiceEvent, bedOutOfServiceEventResult));

            BedUnavailable newBedOutOfServiceEvent = Builders.BuildBedOutOfServiceEvent(3);
            newBedOutOfServiceEvent.Id = bedOutOfServiceEventResult.Id;
            target.UpdateBedUnavailable(newBedOutOfServiceEvent);

            BedUnavailable newBedOutOfServiceEventResult = target.GetBedUnavailable(id, null);
            Assert.IsTrue(new BedOutOfServiceEventComparer().Equals(newBedOutOfServiceEvent, newBedOutOfServiceEventResult));
        }

        /// <summary>
        /// Test method for modifying an existing discharge act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing discharge act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateDischarge()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            Discharge dischargeIntent = Builders.BuildDischargeIntent(2);
            II id = target.CreateDischarge(dischargeIntent);
            Discharge dischargeIntentResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(dischargeIntent, dischargeIntentResult));

            Discharge newDischargeIntent = Builders.BuildDischargeIntent(3);
            newDischargeIntent.Id = dischargeIntentResult.Id;
            target.UpdateDischarge(newDischargeIntent);

            Discharge newDischargeResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(newDischargeIntent, newDischargeResult));
            //request
            Discharge dischargeRequest = Builders.BuildDischargeRequest(2);
            id = target.CreateDischarge(dischargeRequest);
            Discharge dischargeRequestResult = target.GetDischarge(id);

            Discharge newDischargeRequest = Builders.BuildDischargeRequest(3);
            newDischargeRequest.Id = dischargeRequestResult.Id;
            target.UpdateDischarge(newDischargeRequest);

            Discharge newDischargeRequestResult = target.GetDischarge(id);
            //event
            Discharge dischargeEvent = Builders.BuildDischargeEvent(2);
            id = target.CreateDischarge(dischargeEvent);
            Discharge dischargeEventResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(dischargeEvent, dischargeEventResult));

            Discharge newDischargeEvent = Builders.BuildDischargeEvent(3);
            newDischargeEvent.Id = dischargeEventResult.Id;
            target.UpdateDischarge(newDischargeEvent);
            newDischargeEvent.CreationDate = dischargeEvent.CreationDate;
            Discharge newDischargeEventResult = target.GetDischarge(id);
            Assert.IsTrue(new DischargeComparer().Equals(newDischargeEvent, newDischargeEventResult));
        }

        /// <summary>
        /// Test method for modifying an existing diversion.
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing diversion.")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateDiversion()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            Diversion diversion = Builders.BuildDiversion(2);
            II id = target.CreateDiversion(diversion);
            Diversion diversionResult = target.GetDiversion(id);
            diversion.Location = null;
            Assert.IsTrue(new DiversionComparer().Equals(diversion, diversionResult));

            Diversion newDiversion = Builders.BuildDiversion(3);
            newDiversion.Id = diversionResult.Id;
            target.UpdateDiversion(newDiversion);

            Diversion newDiversionResult = target.GetDiversion(id);
            newDiversion.Location = null;
            Assert.IsTrue(new DiversionComparer().Equals(newDiversion, newDiversionResult));
        }


        private void CheckRequest(Transfer transfer)
        {
            transfer.Disposition = null;
            transfer.DispositionDate = null;
            transfer.AdmissionFacility = null;
            transfer.CanceledDate = null;
        }

        /// <summary>
        /// Test method for modifying an existing transfer act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing transfer act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateTransfer()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            ////intent
            //Transfer transferIntent = Builders.BuildTransferIntent(2);
            //II id = target.CreateTransfer(transferIntent);
            //Transfer transferIntentResult = target.GetTransfer(id);
            //Assert.IsTrue(new TransferComparer().Equals(transferIntent, transferIntentResult));

            //Transfer newTransferIntent = Builders.BuildTransferIntent(3);
            //newTransferIntent.Id = transferIntentResult.Id;
            //target.UpdateTransfer(newTransferIntent);

            //Transfer newTransferIntentResult = target.GetTransfer(id);
            //Assert.IsTrue(new TransferComparer().Equals(newTransferIntent, newTransferIntentResult));
            //request
            Transfer transferRequest = Builders.BuildTransferRequest(2);
            II id = target.CreateTransfer(transferRequest);
            Transfer transferRequestResult = target.GetTransfer(id);
            CheckRequest(transferRequest);
            Assert.IsTrue(new TransferComparer().Equals(transferRequest, transferRequestResult));

            Transfer newTransferRequest = Builders.BuildTransferRequest(3);
            newTransferRequest.Id = transferRequestResult.Id;
            newTransferRequest.CreationDate = transferRequest.CreationDate;
            target.UpdateTransfer(newTransferRequest);

            Transfer newTransferRequestResult = target.GetTransfer(id);
            
            CheckRequest(newTransferRequest);
            Assert.IsTrue(new TransferComparer().Equals(newTransferRequest, newTransferRequestResult));
            //event
            Transfer transferEvent = Builders.BuildTransferEvent(2);
            id = target.CreateTransfer(transferEvent);
            transferEvent.CanceledDate = null;
            Transfer transferEventResult = target.GetTransfer(id);
            Assert.IsTrue(new TransferComparer().Equals(transferEvent, transferEventResult));
            
            Transfer newTransferEvent = Builders.BuildTransferEvent(3);
            newTransferEvent.Id = transferEventResult.Id;
            target.UpdateTransfer(newTransferEvent);
     
            newTransferEvent.CanceledDate = null;
            Transfer newTransferEventResult = target.GetTransfer(id);
            Assert.IsTrue(new TransferComparer().Equals(newTransferEvent, newTransferEventResult));
        }

        /// <summary>
        /// Test method for creating a new movement act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for creating a new movement act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void CreateMovement()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            //intent
            Movement movementIntent = Builders.BuildMovementIntent(1);
            II id = target.CreateMovement(movementIntent);
            Movement movementIntentResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(movementIntent, movementIntentResult));
            //request
            Movement movementRequest = Builders.BuildMovementRequest(1);
            movementRequest.Parent = new Act() { Id = id };
            id = target.CreateMovement(movementRequest);
            Movement movementRequestResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(movementRequest, movementRequestResult));
            //event
            Movement movementEvent = Builders.BuildMovementEvent(1);
            movementEvent.Parent = new Act() { Id = id };
            id = target.CreateMovement(movementEvent);
            Movement movementEventResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(movementEvent, movementEventResult));
        }

        /// <summary>
        /// Test method for modifying an existing movement act(intent, request, event).
        ///</summary>
        [TestMethod()]
        [Description("Test for modifying an existing movement act(intent, request, event).")]
        [TestCategory(Constants.IBedManagerOperations)]
        public void UpdateMovement()
        {
            IBedManagerOperations target = CreateIBedManagerOperations();
            //intent
            Movement movementIntent = Builders.BuildMovementIntent(2);
            II id = target.CreateMovement(movementIntent);
            Movement movementIntentResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(movementIntent, movementIntentResult));

            Movement newMovementIntent = Builders.BuildMovementIntent(3);
            newMovementIntent.Id = movementIntentResult.Id;
            target.UpdateMovement(newMovementIntent);

            Movement newMovementIntentResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(newMovementIntent, newMovementIntentResult));
            //request
            Movement movementRequest = Builders.BuildMovementRequest(2);
            id = target.CreateMovement(movementRequest);
            Movement movementRequestResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(movementRequest, movementRequestResult));

            Movement newMovementRequest = Builders.BuildMovementRequest(3);
            newMovementRequest.Id = movementRequestResult.Id;
            target.UpdateMovement(newMovementRequest);

            Movement newMovementRequestResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(newMovementRequest, newMovementRequestResult));
            //event
            Movement movementEvent = Builders.BuildMovementEvent(2);
            id = target.CreateMovement(movementEvent);
            Movement movementEventResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(movementEvent, movementEventResult));

            Movement newMovementEvent = Builders.BuildMovementEvent(3);
            newMovementEvent.Id = movementEventResult.Id;
            target.UpdateMovement(newMovementEvent);

            Movement newMovementEventResult = target.GetMovement(id);
            Assert.IsTrue(new MovementComparer().Equals(newMovementEvent, newMovementEventResult));
        }
    }
}
