﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// The Model class for the WardConfiguration page.
    /// </summary>
    public class WardConfigurationViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the wards from BMS.
        /// </summary>
        /// <value>
        /// The wards.
        /// </value>
        public IList<WardViewModel> Wards { get; set; }

        /// <summary>
        /// Gets or sets the selected ward extension.
        /// </summary>
        /// <value>
        /// The selected ward extension.
        /// </value>
        public string SelectedWardExtension { get; set; }

        /// <summary>
        /// Gets or sets the active wards.
        /// </summary>
        /// <value>
        /// The active wards.
        /// </value>
        public IList<WardViewModel> ActiveWards { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        public string Ien { get; set; }

        /// <summary>
        /// Gets or sets the root id.
        /// </summary>
        /// <value>
        /// The root id.
        /// </value>
        public string RootId { get; set; }

        /// <summary>
        /// Gets or sets the extension id.
        /// </summary>
        /// <value>
        /// The extension id.
        /// </value>
        public string ExtensionId { get; set; }

        /// <summary>
        /// Gets or sets the type group.
        /// </summary>
        /// <value>
        /// The type group.
        /// </value>
        [Required]
        [ValidateXss]
        public string TypeGroup { get; set; }

        /// <summary>
        /// Gets or sets the ward group text.
        /// </summary>
        /// <value>
        /// The ward group text.
        /// </value>
        [Required]
        [ValidateXss]
        public string WardGroupText { get; set; }


        /// <summary>
        /// Gets or sets the name of the current facility.
        /// </summary>
        /// <value>
        /// The name of the facility.
        /// </value>
        public string FacilityName { get; set; }

        public string StartIEN { get; set; }

        public string EndIEN { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista ward name button.
        /// </summary>
        /// <value>
        /// The sort by vista ward name button.
        /// </value>
        public string SortByVistaWardNameButton { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista specialty button.
        /// </summary>
        /// <value>
        /// The sort by vista specialty button.
        /// </value>
        public string SortByVistaSpecialtyButton { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista type group button.
        /// </summary>
        /// <value>
        /// The sort by vista type group button.
        /// </value>
        public string SortByVistaTypeGroupButton { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista ward group text button.
        /// </summary>
        /// <value>
        /// The sort by vista ward group text button.
        /// </value>
        public string SortByVistaWardGroupTextButton { get; set; }
    }

    public class WardViewModel : BaseViewModel
    {
        public Ward Model { get; set; }

        public string DivisionName
        {
            get { return Model == null || Model.Division == null ? null :  Model.Division.Name; }
        }

        public string TypeGroup
        {
            get { return Model == null || Model.TypeGroup == null ? null : Model.TypeGroup; }
        }

        public string VistaSpecialty
        {
            get { return Model == null || Model.Specialty == null ? null : Model.Specialty.displayName; }
        }

        public string Ien
        {
            get { return Model == null ? null : Model.Ien; }
        }

        public string WardName
        {
            get { return Model == null ? null : Model.Name; }
        }
    }

    public class AddEditWardViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        public WardViewModel Ward { get; set; }

        /// <summary>
        /// Gets or sets the root id.
        /// </summary>
        /// <value>
        /// The root id.
        /// </value>
        public string RootId { get; set; }

        /// <summary>
        /// Gets or sets the extension id.
        /// </summary>
        /// <value>
        /// The extension id.
        /// </value>
        public string ExtensionId { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista ward name button.
        /// </summary>
        /// <value>
        /// The sort by vista ward name button.
        /// </value>
        public string SortByVistaWardNameButton { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista specialty button.
        /// </summary>
        /// <value>
        /// The sort by vista specialty button.
        /// </value>
        public string SortByVistaSpecialtyButton { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista type group button.
        /// </summary>
        /// <value>
        /// The sort by vista type group button.
        /// </value>
        public string SortByVistaTypeGroupButton { get; set; }

        /// <summary>
        /// Gets or sets the sort by vista ward group text button.
        /// </summary>
        /// <value>
        /// The sort by vista ward group text button.
        /// </value>
        public string SortByVistaWardGroupTextButton { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is added message confirmation.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is added message confirmation; otherwise, <c>false</c>.
        /// </value>
        public bool IsAddedMessageConfirmation { get; set; }
    }
}
