﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;

namespace BMS.Web.Models
{
    public class EMSMobileViewModel : BaseViewModel
    {
        public EMSMobileViewModel()
        {
            this.DisplayFacilityMissingMessage = false;
            this.DisplayFacilityNotFoundMessage = false;
            this.DisplayFacilityUserNotFoundMessage = false;
            this.LogonErrorMessage = null;
        }

        public string FacilityCode { get; set; }

        public string PIN { get; set; }

        public Facility Facility { get; set; }

        public bool DisplayFacilityMissingMessage { get; set; }

        public bool DisplayFacilityNotFoundMessage { get; set; }

        public bool DisplayFacilityUserNotFoundMessage { get; set; }

        public string LogonErrorMessage { get; set; }

        public List<EmsStaff> EMSUserList { get; set; }

        public string SelectedUserName { get; set; }

        public string SelectedUserId { get; set; }

        public bool DisplayEMSModuleInactive { get; set; }
    }

    public class EMSMobileMainViewModel : BaseViewModel
    {
        public string FacilityCode { get; set; }

        public Facility Facility { get; set; }

        public string UserName { get; set; }

        public string UserId { get; set; }

        public List<BedCleanInfo> AssignedBedCleanList { get; set; }

        public List<BedCleanInfo> PendingBedCleanList { get; set; }

        public string SelectedBedCleanId { get; set; }

        public string ButtonAcceptBedClean { get; set; }

        public string ButtonCompleteBedClean { get; set; }
    }
}