﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Facade;
using System.Reflection;
using BMS.Utils;

namespace BMS.Web.Models
{
    public class BedStatusReportViewModel : BaseViewModel
    {

        public List<int?> OrderFieldsList { get; set; }

        public List<ReportFieldsViewModel> DisplayFieldsList { get; set; }

        public List<CD> GenderList { get; set; }

        public List<CD> WaitingAreaList { get; set; }

        public List<CD> CommunityServicesList { get; set; }

        public List<CD> ReasonUsingFeeList { get; set; }

        public List<CD> AcuteList { get; set; }

        public List<CD> ContractList { get; set; }

        public List<CD> AuthorizedList { get; set; }

        public List<Bed> BedList { get; set; }

        public List<CD> InHouseList { get; set; }

        public string ButtonSubmit { get; set; }
    }

    public class ReportFieldsViewModel
    {
        public int Id { get; set; }

        public string FieldName { get; set; }

        public int? Order { get; set; }

        public string FilterValue { get; set; }

        public string FilterValueSecond { get; set; }

        public string FilterThirdValue { get; set; }

        public string FilterFourthValue { get; set; }

        public string FilterFifthValue { get; set; }

        public string FilterSixValue { get; set; }

        public string FilterSeventhValue { get; set; }
    }

    public class BedStatusReport
    {
        public static List<BedStatusReport> GetViewModel(II facilityId, string filter, string[] displayFields, string filterPatientName, string filterGender)
        {
            List<WaitingListReport> list = FacadeManager.ADTInterface.GetWaitingListReport(facilityId, filter, filterPatientName, filterGender);
            List<BedStatusReport> result = new List<BedStatusReport>();
            BedStatusReport bedStatus = null;
            string header = string.Empty;
            string value = string.Empty;
            PropertyInfo pi = null;
            foreach (WaitingListReport waitingList in list)
            {
                bedStatus = new BedStatusReport();
                for (int i = 0; i < displayFields.Length; i++)
                {
                    header = displayFields[i];
                    switch (displayFields[i])
                    {
                        case Constants.PATIENT_FIELD:
                            value = waitingList.PatientName;
                            break;
                        case Constants.GENDER_FIELD:
                            value = waitingList.PatientGender;
                            break;
                        case Constants.EVENT_TIME_FIELD:
                            value = waitingList.EnteredDate.ToString();
                            break;
                        case Constants.REQUEST_DT_FIELD:
                            value = waitingList.RequestedDate.ToString();
                            break;
                        case Constants.REMOVE_FROM_LIST_FIELD:
                            value = waitingList.RemovedDate.ToString();
                            break;
                        case Constants.CURRENT_WAIT_AREA_FIELD:
                            value = waitingList.WaitingArea;
                            break;
                        case Constants.RECORD_LAST_EDITED_BY_FIELD:
                            value = waitingList.LastEditedBy;
                            break;
                        case Constants.COMMUNITY_SERVICES_FIELD:
                            value = waitingList.CommunityServices;
                            break;
                        case Constants.CONTRACTED_FIELD:
                            value = waitingList.ContractFee;
                            break;
                        case Constants.REASON_USING_FEE_FIELD:
                            value = waitingList.ReasonUsingFee;
                            break;
                        case Constants.ACUTE_FIELD:
                            value = waitingList.DispositionFee;
                            break;
                        case Constants.AUTHORIZED_FEE_FIELD:
                            value = waitingList.AuthorizedFee;
                            break;
                        case Constants.IN_HOUSE_TRANSFER_FIELD:
                            value = waitingList.InHouseTransfer.ToString();
                            break;
                        case Constants.DATE_TIME_BED_REQUEST_FIELD:
                            value = waitingList.BedRequestedDate.ToString();
                            break;
                        case Constants.DATE_TIME_BED_ASSIGNED_FIELD:
                            value = waitingList.BedAssignedDate.ToString();
                            break;
                        case Constants.FEE_COMMENTS_FIELD:
                            value = waitingList.FeeComments;
                            break;
                        case Constants.ROOM_BED_ASSIGNED_FIELD:
                            value = waitingList.RoomBedAssigned;
                            break;
                        case Constants.TYPE_OF_BED_WARD_REQUIRED_FIELD:
                            value = waitingList.TypeOfBedWard;
                            break;
                        case Constants.PRESENTING_PROBLEM_FIELD:
                            value = waitingList.PresentingProblem;
                            break;
                    }
                    pi = bedStatus.GetType().GetProperty("FieldHeader" + (i + 1));
                    pi.SetValue(bedStatus, header, null);
                    pi = bedStatus.GetType().GetProperty("FieldValue" + (i + 1));
                    pi.SetValue(bedStatus, value, null);
                    pi = bedStatus.GetType().GetProperty("IsVisible" + (i + 1));
                    pi.SetValue(bedStatus, true, null);
                }
                result.Add(bedStatus);
            }
            if (list == null || list.Count == 0)
            {
                bedStatus = new BedStatusReport();
                for (int i = 0; i < displayFields.Length; i++)
                {
                    pi = bedStatus.GetType().GetProperty("FieldHeader" + (i + 1));
                    pi.SetValue(bedStatus, displayFields[i], null);
                    pi = bedStatus.GetType().GetProperty("FieldValue" + (i + 1));
                    pi.SetValue(bedStatus, null, null);
                    pi = bedStatus.GetType().GetProperty("IsVisible" + (i + 1));
                    pi.SetValue(bedStatus, true, null);
                }
                result.Add(bedStatus);
            }
            return result;
        }

        public string FieldHeader1 { get; set; }
        public string FieldValue1 { get; set; }
        public bool IsVisible1 { get; set; }

        public string FieldHeader2 { get; set; }
        public string FieldValue2 { get; set; }
        public bool IsVisible2 { get; set; }

        public string FieldHeader3 { get; set; }
        public string FieldValue3 { get; set; }
        public bool IsVisible3 { get; set; }

        public string FieldHeader4 { get; set; }
        public string FieldValue4 { get; set; }
        public bool IsVisible4 { get; set; }

        public string FieldHeader5 { get; set; }
        public string FieldValue5 { get; set; }
        public bool IsVisible5 { get; set; }

        public string FieldHeader6 { get; set; }
        public string FieldValue6 { get; set; }
        public bool IsVisible6 { get; set; }

        public string FieldHeader7 { get; set; }
        public string FieldValue7 { get; set; }
        public bool IsVisible7 { get; set; }

        public string FieldHeader8 { get; set; }
        public string FieldValue8 { get; set; }
        public bool IsVisible8 { get; set; }

        public string FieldHeader9 { get; set; }
        public string FieldValue9 { get; set; }
        public bool IsVisible9 { get; set; }

        public string FieldHeader10 { get; set; }
        public string FieldValue10 { get; set; }
        public bool IsVisible10 { get; set; }

        public string FieldHeader11 { get; set; }
        public string FieldValue11 { get; set; }
        public bool IsVisible11 { get; set; }

        public string FieldHeader12 { get; set; }
        public string FieldValue12 { get; set; }
        public bool IsVisible12 { get; set; }

        public string FieldHeader13 { get; set; }
        public string FieldValue13 { get; set; }
        public bool IsVisible13 { get; set; }

        public string FieldHeader14 { get; set; }
        public string FieldValue14 { get; set; }
        public bool IsVisible14 { get; set; }

        public string FieldHeader15 { get; set; }
        public string FieldValue15 { get; set; }
        public bool IsVisible15 { get; set; }

        public string FieldHeader16 { get; set; }
        public string FieldValue16 { get; set; }
        public bool IsVisible16 { get; set; }

        public string FieldHeader17 { get; set; }
        public string FieldValue17 { get; set; }
        public bool IsVisible17 { get; set; }

        public string FieldHeader18 { get; set; }
        public string FieldValue18 { get; set; }
        public bool IsVisible18 { get; set; }

        public string FieldHeader19 { get; set; }
        public string FieldValue19 { get; set; }
        public bool IsVisible19 { get; set; }
    }
}