﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;
using BMS.Utils;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Models
{
    public class AdminIconSortViewModel
    {
        public string Group { get; set; }
        public string SubGroup { get; set; }
        public string IconIDs { get; set; }

        public string[] GetIDs()
        {
            if (IconIDs == null)
                return null;

            return IconIDs.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        }

        
    }

    public class AdminIconViewModel : BaseViewModel
    {
        public AdminIconViewModel()
        {
            this.SystemIconList = new List<IconInfo>();
            this.BedCleaningIconList = new List<IconInfo>();
            this.StandardIconList = new List<IconInfo>();
            this.EmergencyIconList = new List<IconInfo>();
            this.SiteConfigurableIconList = new List<IconInfo>();
        }

        public List<IconInfo> SystemIconList { get; set; }

        public List<IconInfo> BedCleaningIconList { get; set; }

        public List<IconInfo> StandardIconList { get; set; }

        public List<IconInfo> EmergencyIconList { get; set; }

        public List<IconInfo> SiteConfigurableIconList { get; set; }

        public List<SearchIconModel> SearchIconsList { get; set; }

        public List<IconInfo> SearchResultIcons { get; set; }

        public IconInfo PatientIcon { get; set; }

        public IconInfo RoomBedIcon { get; set; }

        public string Group { get; set; }

        public string Subgroup { get; set; }

        public bool Active { get; set; }

        public string ImageBytes { get; set; }

        public string ImageBytesInactive { get; set; }

        [Required(ErrorMessage = "The Image Name field is required!")]
        public string ImageName { get; set; }

        [RequiredIf("ActiveHidden", "True", ErrorMessage = "The Icon Name field is required!")]
        [ValidateXss]
        public string IconName { get; set; }

        [RequiredIf("ActiveHidden", "True", ErrorMessage = "The Icon Short Description field is required!")]
        [ValidateXss]
        public string IconShortDescription { get; set; }

        [ValidateXss]
        public string IconLongDescription { get; set; }

        [StringLength(Constants.COMMENTS_MAX_LENGTH, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "CommentLengthError")]
        [ValidateXss]
        public string Comment { get; set; }

        [RequiredIf("ActiveHidden", "True", ErrorMessage = "The Mouse Over Text field is required!")]
        [ValidateXss]
        public string MouseOverText { get; set; }        

        public bool Published { get; set; }

        public bool PatientOrRoomBed { get; set; }

        public int IconId  { get; set; }

        public int OrderIndex { get; set; }

        public bool IsNew { get; set; }

        public string GroupDisplay { get; set; }

        public string SubgroupDisplay { get; set; }

        public string ButtonSaveIcon { get; set; }

        public string ButtonDeleteIcon { get; set; }

        public string ButtonUploadImage { get; set; }

        public bool IsIconAssociated { get; set; }

        public string SearchIconFlagIds { get; set; }

        public int SwitchIconId1 { get; set; }

        public int SwitchIconId2 { get; set; }

        public string SwitchGroup { get; set; }

        public bool ActiveHidden { get; set; }

        public bool PublishedHidden { get; set; }
    }

    public class SearchIconModel
    {
        public int IconId { get; set; }

        public bool IsSelected { get; set; }

        public string ImageBytes { get; set; }

        public string IconName { get; set; }

        public string IconDescription { get; set; }

        public string MouseOverText { get; set; }

        public string ImageName { get; set; }
    }
}