﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using System.Reflection;

namespace BMS.Web.Controllers.Shared
{
    [AttributeUsage(AttributeTargets.Field | AttributeTargets.Property, AllowMultiple = true, Inherited = true)]
    public class RangeIfAttribute : ValidationAttribute //, IClientValidatable
    {
        private RangeAttribute _innerAttribute;

        public string DependentProperty { get; set; }
        public object TargetValue { get; set; }
        public object Minimum { get; set; }
        public object Maximum { get; set; }


        public RangeIfAttribute(string dependentProperty, object targetValue, int minimum, int maximum)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (minimum > maximum)
                    throw new ArgumentException("minimum has to be less than or equal to maximum");
                this.DependentProperty = dependentProperty;
                this.TargetValue = targetValue;
                Minimum = minimum;
                Maximum = maximum;
                _innerAttribute = new RangeAttribute(minimum, maximum);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RangeIfAttribute(string dependentProperty, object targetValue, double minimum, double maximum)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (minimum > maximum)
                    throw new ArgumentException("minimum has to be less than or equal to maximum");
                this.DependentProperty = dependentProperty;
                this.TargetValue = targetValue;
                Minimum = minimum;
                Maximum = maximum;
                _innerAttribute = new RangeAttribute(minimum, maximum);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                // get a reference to the property this validation depends upon
                var containerType = validationContext.ObjectInstance.GetType();
                var field = containerType.GetProperty(this.DependentProperty);

                if (field != null)
                {
                    // get the value of the dependent property
                    var dependentvalue = field.GetValue(validationContext.ObjectInstance, null);

                    // compare the value against the target value
                    if ((dependentvalue == null && this.TargetValue == null) ||
                        (dependentvalue != null && dependentvalue.Equals(this.TargetValue)))
                    {
                        // match => means we should try validating this field
                        if (!_innerAttribute.IsValid(value))
                            // validation failed - return an error
                            return new ValidationResult(this.ErrorMessage, new[] { validationContext.MemberName });
                    }
                }

                return ValidationResult.Success;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private object _typeId = new object();
        public override object TypeId
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return this._typeId;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        //only server side validation. client side validation could be done in the same way as the RequiredIfAttribute - with multiple attributes
        //public IEnumerable<ModelClientValidationRule> GetClientValidationRules(ModelMetadata metadata, ControllerContext context)
        //{
        //    string depProp = BuildDependentPropertyId(metadata, context as ViewContext);

        //    foreach (RangeIfElement element in Elements)
        //    {
        //        var rule = new ModelClientValidationRule()
        //        {
        //            ErrorMessage = FormatErrorMessage(metadata.GetDisplayName()),
        //            ValidationType = "rangeif",
        //        };
        //        // find the value on the control we depend on;
        //        // if it's a bool, format it javascript style 
        //        // (the default is True or False!)
        //        string targetValue = (element.TargetValue ?? "").ToString();
        //        if (element.TargetValue.GetType() == typeof(bool))
        //            targetValue = targetValue.ToLower();

        //        rule.ValidationParameters.Add("dependentproperty", depProp);
        //        rule.ValidationParameters.Add("targetvalue", targetValue);
        //        rule.ValidationParameters.Add("minimum", element.Minimum);
        //        rule.ValidationParameters.Add("maximum", element.Maximum);

        //        yield return rule;
        //    }
        //}

        //private string BuildDependentPropertyId(ModelMetadata metadata, ViewContext viewContext)
        //{
        //    // build the ID of the property
        //    string depProp = viewContext.ViewData.TemplateInfo.GetFullHtmlFieldId(this.DependentProperty);
        //    // unfortunately this will have the name of the current field appended to the beginning,
        //    // because the TemplateInfo's context has had this fieldname appended to it. Instead, we
        //    // want to get the context as though it was one level higher (i.e. outside the current property,
        //    // which is the containing object (our Person), and hence the same level as the dependent property.
        //    var thisField = metadata.PropertyName + "_";
        //    if (depProp.StartsWith(thisField))
        //        // strip it off again
        //        depProp = depProp.Substring(thisField.Length);
        //    return depProp;
        //}
    }
}