﻿var autoScrollIntervalId;
$(document).ready(function () {
    var scrollRate = parseInt($('#ScrollRateSelected').val());
    if (scrollRate > 0) {
        var height = $(window).height() - 270;
        if ($('table[name=tblWhiteboard]').height() > height) {
            $('table[name=tblWhiteboard]').tableScroll({ height: height });
        }
        else {
            $('table[name=tblWhiteboard]').tableScroll({ height: $('table[name=tblWhiteboard]').height() });
        }
        if ($('#divContainerDataTwo')) {
            $('#divContainerDataTwo').css({ "min-width": (($('.tablescroll_head').width() * 2) + 30) + "px" });
        }
    }
    else {
        var tbls = $('table[name=tblWhiteboard]');
        var body;
        for (i = 0; i < tbls.length; i++) {
            $(tbls[i]).css('border-collapse', 'collapse');
            body = $(tbls[i]).find('tbody');
            $(body).css('border-top', '1px solid #DDDDDD');
            $(body).css('border-bottom', '1px solid #DDDDDD');
            $(body).css('border-right', '1px solid #DDDDDD');
        }
    }

    $('.checkStaffBtn').click(function () {
        $('#buttonStaffHidden').click();
        return false;
    });

    //add click events for staff buttons
    ButtonsManageStaff();

    // keep the scroll in the same position on window reload    
    if (scrollRate > 0) {
        var div = $('.tablescroll_wrapper');
        for (i = 0; i < div.length; i++) {
            $(div[i]).scrollTop($('#ActualScrollValue').val());
        }
    }

    //Script for automated scrolling.        
    if (scrollRate > 0)
        autoScrollIntervalId = setInterval(function() { autoScroll(); }, scrollRate * 1000);    
});

function autoScroll() {
    
    var scrollDirection = $('#ActualScrollDirection').val();
    var scroll;
    var div = $("body");

    var docViewTop = $(div).scrollTop();
    var docViewBottom = docViewTop + $(this).height();

    var elemTop = $('#footer').offset().top;
    var elemBottom = elemTop + $('#footer').height();

    if ((elemBottom >= docViewTop) && (elemTop <= docViewBottom)) {
        scroll = $(div).scrollTop() - ($(this).height() - 10); //up
        scrollDirection = '0';
    }
    else if ($(div).scrollTop() == 0) {
        scroll = $(div).scrollTop() + ($(this).height() - 10); //down
        scrollDirection = '1';
    }
    else {
        if (scrollDirection == '1')
            scroll = $(div).scrollTop() + ($(this).height() - 10); //down
        else
            scroll = $(div).scrollTop() - ($(this).height() - 10); //up
    }
    //$(div[i]).animate({ scrollTop: scroll }, 1500);
    $("body").animate({ scrollTop: scroll }, 1500);
    $('#ActualScrollDirection').val(scrollDirection);
    $('#ActualScrollValue').val(scroll);
}

var EditStaffViewModel = function (bedId, staff, patientId) {
    this.BedId = bedId;
    this.Staff = staff;
    this.PatientId = patientId;
}

function ButtonsManageStaff() {
    $('a[id^="btnSaveStaff_"]').click(
        function () {
            var index = $(this).attr('id').split('_')[1];
            var jsStaff = new EditStaffViewModel($('#hiddenBedId_' + index + '').val(), $('#textboxStaff_' + index + '').val().toUpperCase(), $('#hiddenPatientId_' + index + '').val());
            var jsonText = JSON.stringify(jsStaff);

            $.ajaxAntiForgery({
                type: "POST",
                url: "WardWhiteBoardStaff",                
                dataType: "json",                
                data: { model: jsonText },
                async: true,
                cache: false,
                success: function (msg) {
                    $('#lblStaff_' + index + '').text(msg);
                    $('#divStaffEdit_' + index + '').css('display', 'none');
                    $('#divStaffReadOnly_' + index + '').css('display', 'block');
                },
                error: function (x, e) {
                    if (x.responseText.indexOf('<title>BMS User Login Page</title>') >= 0)
                        window.location = '@Url.Action("LogOn", "Account")';
                    else if (x.responseText.indexOf('<title>Unhandled Exception</title>') >= 0 || x.responseText.indexOf('<title>Unauthorized</title>') >= 0)
                        document.body.innerHTML = x.responseText;
                }
            });
            return false;
        });
    $('a[id^="btnCancelStaff_"]').click(
        function () {
            var index = $(this).attr('id').split('_')[1];
            $('#divStaffEdit_' + index + '').css('display', 'none');
            $('#divStaffReadOnly_' + index + '').css('display', 'block');
            return false;
        });
    $('div[id^="divStaffReadOnly_"]').click(
        function () {
            var index = $(this).attr('id').split('_')[1];
            var count = $('div[id^="divStaffReadOnly_"]').length;
            for (i = 0; i < count; i++) {
                $('#divStaffEdit_' + i + '').css('display', 'none');
                $('#divStaffReadOnly_' + i + '').css('display', 'block');
            }
            $('#textboxStaff_' + index + '').val($('#lblStaff_' + index + '').text());
            $('#divStaffEdit_' + index + '').css('display', 'block');
            $('#divStaffReadOnly_' + index + '').css('display', 'none');
            return false;
        });
}