﻿$(document).ready(function () {
    AddAutoCompleteFunctions();
});

// Convert free forms text to uppercase
$(document).submit(function () {
    var allHTMLTags = document.getElementsByTagName('input');
    for (i = 0; i < allHTMLTags.length; i++) {
        //Get all tags with the specified class name.                                 
        if (allHTMLTags[i].className.indexOf("textUppercase") != -1) {
            allHTMLTags[i].value = allHTMLTags[i].value.toUpperCase();
        }
    }
});

function split(val) {
    return val.split(/,\s*/);
}
function extractLast(term) {
    return split(term).pop();
}

function StandardCommentsButtonClick(ctrlId) {
    if ($('#' + ctrlId + '').autocomplete("widget").is(":visible")) {
        $('#' + ctrlId + '').autocomplete("close");
        return;
    }
    $(this).blur();
    $('#' + ctrlId + '').autocomplete("search", "");
    $('#' + ctrlId + '').focus();
}

function Decode(val) {
    return $.base64.decode(val);
}

function Encode(val) {
    return $.base64.encode(val);
}

function AddAutoCompleteFunctions() {
    $(".cssAutoComplete")
                .bind("keydown", function (event) {
                    if (event.keyCode == $.ui.keyCode.TAB && $(this).data("uiAutocomplete").menu.active) {
                        event.preventDefault();
                    }
                })
			    .autocomplete({
			        minLength: 0,
			        source: function (request, response) {
			            var term = extractLast(request.term);
			            var StandardArray = new Array();
			            term = Encode(term);
			            $.postAntiForgery('/Base/LoadStandardComments', { displayName: term }, function (StandardList) {
			                StandardArray = StandardList.responseJSON;
			                response(StandardArray);
			            });
			        },
			        focus: function () {
			            // prevent value inserted on focus
			            return false;
			        },
			        select: function (event, ui) {
			            var terms = (this.value).split(",");
			            // remove the current input
			            terms.pop();
			            if (!(this.value).match(/,$/)) {

			                var lastTerm = extractLast(this.value).toUpperCase();
			                if ((ui.item.value).indexOf(lastTerm) == -1) {
			                    terms.push(lastTerm);
			                }
			            }
			            // add the selected item
			            terms.push(ui.item.value);
			            // add placeholder to get the comma at the end
			            terms.push("");
			            this.value = terms.join(",");
			            return false;
			        }
			    });
}