﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using BMS.Web.App_GlobalResource;
using BMS.Facade;
using BMS.Utils;
using BMS.Web.Reporting;
using BMS.Facade.Data;
using BMS.ServicesWrapper.Security;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Reports
{
    /// <summary>
    /// Page responsible for calling the Report Viewer with the appropriate credentials and parameters
    /// </summary>
    public partial class WhiteboardReportViewer : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ReportUtil reportUtil = null;
                facilityHomeLink.Text = Strings.BMS_Home;
                iconsHomeLink.Text = Strings.IconLegend;
                informationHomeLink.Text = Strings.Information;
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturnToMainPage;
                homeLink.NavigateUrl = "~";

                if (Request != null && Request.QueryString != null && Request.QueryString.Count > 0)
                {
                    String token = Request.QueryString[0];
                    if (String.IsNullOrEmpty(token))
                        return;

                    reportUtil = ReportUtil.Decrypt(token);
                }

                string reportTitle = "Whiteboard";
                if (!string.IsNullOrEmpty(reportTitle))
                {
                    AntiXssEncoder xss = new AntiXssEncoder();
                    reportName.InnerText = xss.Decode(reportTitle);
                }

                if (reportUtil == null)
                {
                    reportUtil = ReportUtil.CreateDefaultInstance(Page.User.Identity.Name);
                    reportUtil.ReportPath = "/BMS/Whiteboard";
                    reportUtil.ReportName = reportTitle;
                }

                int scrollRate, scrollDirection;
                if (reportUtil.Parameters.ContainsKey("scrollRate") && Int32.TryParse(reportUtil.Parameters["scrollRate"], out scrollRate) && scrollRate > 0)
                {
                    ScrollRateSelected.Value = scrollRate.ToString();
                    reportUtil.Parameters.Remove("scrollRate");
                }

                if (reportUtil.Parameters.ContainsKey("scrollDirection") && Int32.TryParse(reportUtil.Parameters["scrollDirection"], out scrollDirection))
                    ActualScrollDirection.Value = scrollDirection.ToString();

                ReportViewerControl.ServerReport.ReportServerUrl = new Uri(reportUtil.ReportServerUrl);
                ReportViewerControl.ServerReport.ReportPath = reportUtil.ReportPath;

                if (this.IsPostBack)
                {
                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "key", "ResizeForm();", true);
                }
                else
                {
                    ReportViewerControl.ServerReport.ReportServerCredentials =
                    (
                        String.IsNullOrEmpty(reportUtil.Domain) ?
                        new CustomReportCredentials(reportUtil.UserName, reportUtil.Password) :
                        new CustomReportCredentials(reportUtil.UserName, reportUtil.Password, reportUtil.Domain)
                    );

                    List<ReportParameter> param = new List<ReportParameter>();

                    ReportParameterInfoCollection coll = null;

                    try
                    {
                        User loggedUser = FacadeManager.UserInterface.GetProfile();
                        if (loggedUser != null)
                        {
                            AntiXssEncoder xss = new AntiXssEncoder();
                            loggedUser.Facility.Name = xss.Decode(loggedUser.Facility.Name);
                        }

                        coll = ReportViewerControl.ServerReport.GetParameters();
                        if (coll.FirstOrDefault(p => string.Equals(p.Name, Strings.UserID, StringComparison.InvariantCultureIgnoreCase)) != null)
                            param.Add(new ReportParameter(Strings.UserID, reportUtil.UserId, false));

                        foreach (var paramName in reportUtil.Parameters.Keys)
                            if (coll.FirstOrDefault(p => string.Equals(p.Name, paramName, StringComparison.InvariantCultureIgnoreCase)) != null)
                                param.Add(new ReportParameter(paramName, reportUtil.Parameters[paramName], true));

                        //adds all the parameter values passed through the query string, excepting UserID, salt, facility and ApplicationURL that are treated separately above and below.
                        foreach (ReportParameterInfo paramName in coll)
                        {
                            if (coll.FirstOrDefault(p => string.Equals(p.Name, paramName.Name, StringComparison.InvariantCultureIgnoreCase)) != null)
                            {
                                if (Request.QueryString[paramName.Name] != null)
                                    param.Add(new ReportParameter(paramName.Name, Request.QueryString[paramName.Name], true));
                            }
                        }

                        if (coll.FirstOrDefault(p => string.Equals(p.Name, Strings.ApplicationURL, StringComparison.InvariantCultureIgnoreCase)) != null)
                        {
                            string url = HttpContext.Current.Request.Url.ToString();
                            int rpt = url.IndexOf("/" + Strings.ReportsFolder);
                            if (rpt > -1)
                            {
                                url = url.Substring(0, rpt);
                                param.Add(new ReportParameter(Strings.ApplicationURL, url, false));
                            }
                        }

                        // set user salt
                        param.Add(new ReportParameter(Constants.REP_USER_SALT, loggedUser.Salt));

                        // facility ID
                        param.Add(new ReportParameter(Constants.REP_GENERAL_FACILITY_EXTENSION_TO_UPPER, loggedUser.Facility.Id.extension));


                        ReportViewerControl.ServerReport.SetParameters(param);
                        //ReportViewerControl.Height = 1000;
                        //ReportViewerControl.ZoomMode = ZoomMode.Percent;
                        //ReportViewerControl.ZoomPercent = 225;
                    }
                    catch (Microsoft.Reporting.WebForms.ReportServerException rsException)
                    {
                        OnError(rsException.ErrorCode + "\t" + rsException.Message);
                    }

                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected void OnError(String message)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY] = message;
                Response.Redirect("ReportError.aspx");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected void ReportViewerControl_ReportError(object sender, ReportErrorEventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (e.Exception != null &&
                    e.Exception.InnerException != null &&
                    e.Exception.InnerException.InnerException != null)
                {
                    e.Handled = true;
                    OnError(e.Exception.InnerException.InnerException.Message);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
