﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace BMS.Web.Models.Shared
{
    public class JobLogModel
    {
        public JobLogModel() { }
        public JobLogModel(string vistaName, string vistaId, string retrievalMethod, string retrievedDataType, string retrievedEntriesNumber, string startDate, string endDate,
            string launchType, string parameters, string status, string errorMessage, string details, int totalCount, int index, DateTime? endDateTime)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                VistaName = vistaName;
                VistaId = vistaId;
                RetrievalMethod = retrievalMethod;
                RetrievedDataType = retrievedDataType;
                RetrievedEntriesNumber = retrievedEntriesNumber;
                StartDate = startDate;
                EndDate = endDate;
                LaunchType = launchType;
                Parameters = parameters;
                Status = status;
                ErrorMessage = errorMessage;
                Details = details;
                TotalCount = totalCount;
                Index = index;
                EndDateTime = endDateTime;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string VistaName { get; set; }
        public string VistaId { get; set; }
        public string RetrievalMethod { get; set; }
        public string RetrievedDataType { get; set; }
        public string RetrievedEntriesNumber { get; set; }
        public string StartDate { get; set; }
        public string EndDate { get; set; }
        public string LaunchType { get; set; }
        public string Parameters { get; set; }
        public string Status { get; set; }
        public string ErrorMessage { get; set; }
        public string Details { get; set; }
        public int TotalCount { get; set; }
        public int Index { get; set; }
        public DateTime? EndDateTime { get; set; }
    }
}