﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Web.App_GlobalResource;
using System.ComponentModel.DataAnnotations;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// Bed Information Model class.
    /// </summary>
    public class BedInfoViewModel
    {
        #region Public Members
        /// <summary>
        /// Gets or sets the logged user.
        /// </summary>
        /// <value>
        /// The logged user.
        /// </value>
        public User LoggedUser { get; set; }

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        public Bed Bed { get; set; }

        /// <summary>
        /// Gets or sets the reasons.
        /// </summary>
        /// <value>
        /// The reasons.
        /// </value>
        public CDList ReasonList { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [ValidateXss]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the cleaning date.
        /// </summary>
        /// <value>
        /// The cleaning date.
        /// </value>        
        public DateTime CleaningDate { get; set; }

        public string CleaningDateString
        {
            get { return CleaningDate.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        CleaningDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        CleaningDate = DateTime.Today;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }


        /// <summary>
        /// Gets or sets the expected completed date.
        /// </summary>
        /// <value>
        /// The expected completed date.
        /// </value>
        public DateTime? ExpectedCompletedDate { get; set; }

        public string ExpectedCompletedDateString
        {
            get
            {
                if (ExpectedCompletedDate.HasValue)
                    return ExpectedCompletedDate.Value.ToString(Strings.USDate);
                else
                    return string.Empty;
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        ExpectedCompletedDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        ExpectedCompletedDate = null;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the expected completed date hour selected.
        /// </summary>
        /// <value>
        /// The expected completed date hour selected.
        /// </value>
        public string ExpectedCompletedDateHourSelected { get; set; }

        /// <summary>
        /// Gets or sets the expected completed date minute selected.
        /// </summary>
        /// <value>
        /// The expected completed date minute selected.
        /// </value>
        public string ExpectedCompletedDateMinuteSelected { get; set; }

        /// <summary>
        /// Gets or sets the real division selected extension.
        /// </summary>
        /// <value>
        /// The real division selected extension.
        /// </value>
        public string RealDivisionSelectedExtension { get; set; }

        /// <summary>
        /// Gets or sets the real division selected root.
        /// </summary>
        /// <value>
        /// The real division selected root.
        /// </value>
        public string RealDivisionSelectedRoot { get; set; }

        /// <summary>
        /// Gets or sets the ward list.
        /// </summary>
        /// <value>
        /// The ward list.
        /// </value>
        public IList<Ward> WardList { get; set; }

        /// <summary>
        /// Gets or sets the bed status code.
        /// </summary>
        /// <value>
        /// The bed status code.
        /// </value>
        public string BedStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the bed status list.
        /// </summary>
        /// <value>
        /// The bed status list.
        /// </value>
        public CDList BedStatusList { get; set; }

        /// <summary>
        /// Gets or sets the division (the name of the ward group).
        /// </summary>
        /// <value>
        /// The name of the division (ward group).
        /// </value>
        public string WardGroupName { get; set; }

        /// <summary>
        /// Gets or sets the root ward group id.
        /// </summary>
        /// <value>
        /// The root ward group id.
        /// </value>
        public string RootWardGroupId { get; set; }

        /// <summary>
        /// Gets or sets the extension ward group id.
        /// </summary>
        /// <value>
        /// The extension ward group id.
        /// </value>
        public string ExtensionWardGroupId { get; set; }

        /// <summary>
        /// Gets or sets the hour selected.
        /// </summary>
        /// <value>
        /// The hour selected.
        /// </value>
        public string HourSelected { get; set; }

        /// <summary>
        /// Gets or sets the minute selected.
        /// </summary>
        /// <value>
        /// The minute selected.
        /// </value>
        public string MinuteSelected { get; set; }

        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        public string Ward { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is add operation.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is add operation; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedUnavailableReasonAddOperation { get; set; }

        /// <summary>
        /// Gets or sets the unavailable reason table header.
        /// </summary>
        /// <value>
        /// The unavailable reason table header.
        /// </value>
        public string UnavailableReasonTableHeader { get; set; }

        /// <summary>
        /// Gets or sets the request cleaning.
        /// </summary>
        /// <value>
        /// The request cleaning.
        /// </value>
        public string RequestCleaning { get; set; }

        /// <summary>
        /// Gets or sets the unavailable reason code.
        /// </summary>
        /// <value>
        /// The unavailable reason code.
        /// </value>
        public string UnavailableReasonCode { get; set; }

        /// <summary>
        /// Gets or sets the root bed id.
        /// </summary>
        /// <value>
        /// The root bed id.
        /// </value>
        public string RootBedId { get; set; }

        /// <summary>
        /// Gets or sets the extension bed id.
        /// </summary>
        /// <value>
        /// The extension bed id.
        /// </value>
        public string ExtensionBedId { get; set; }

        /// <summary>
        /// Gets or sets the submit cleaning button.
        /// </summary>
        /// <value>
        /// The submit cleaning button.
        /// </value>
        public string SubmitCleaningButton { get; set; }

        /// <summary>
        /// Gets or sets the cancel button.
        /// </summary>
        /// <value>
        /// The cancel button.
        /// </value>
        public string CancelButton { get; set; }

        /// <summary>
        /// Gets or sets the clear button.
        /// </summary>
        /// <value>
        /// The clear button.
        /// </value>
        public string ClearButton { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is from summary report.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is from summary report; otherwise, <c>false</c>.
        /// </value>
        public bool IsFromSummaryReport { get; set; }

        /// <summary>
        /// Gets or sets the summary report return path.
        /// </summary>
        /// <value>
        /// The summary report return path.
        /// </value>
        public string SummaryReportReturnPath { get; set; }

        /// <summary>
        /// Gets or sets the summary report return text.
        /// </summary>
        /// <value>
        /// The summary report return text.
        /// </value>
        public string SummaryReportReturnText { get; set; }

        /// <summary>
        /// Gets or sets the visn root used in visn summary report.
        /// </summary>
        /// <value>
        /// The visn root used in visn summary report.
        /// </value>
        public string VisnRoot { get; set; }

        /// <summary>
        /// Gets or sets the visn extension used in visn summary report.
        /// </summary>
        /// <value>
        /// The visn extension used in visn summary report.
        /// </value>
        public string VisnExtension { get; set; }

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        public Division Division { get; set; }
        /// <summary>
        /// Gets or sets the bed unavailable history.
        /// </summary>
        /// <value>
        /// The bed unavailable history.
        /// </value>
        public BedUnavailableHistory BedUnavailableHistory { get; set; }

        /// <summary>
        /// Gets or sets the set visibility for extected completed date.
        /// </summary>
        /// <value>
        /// The set visibility for extected completed date.
        /// </value>
        public string SetVisibilityForExpectedOrActualCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is expected completed date visible.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is expected completed date visible; otherwise, <c>false</c>.
        /// </value>
        public bool IsExpectedCompletedDateVisible { get; set; }

        /// <summary>
        /// Gets or sets the selected reason.
        /// </summary>
        /// <value>
        /// The selected reason.
        /// </value>
        public string SelectedReason { get; set; }

        /// <summary>
        /// Gets or sets the actual completed date.
        /// </summary>
        /// <value>
        /// The actual completed date.
        /// </value>
        public DateTime ActualCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the actual completed date string.
        /// </summary>
        /// <value>
        /// The actual completed date string.
        /// </value>
        public string ActualCompletedDateString
        {
            get { return ActualCompletedDate.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        ActualCompletedDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        ActualCompletedDate = DateTime.Today;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the actual completed date hour selected.
        /// </summary>
        /// <value>
        /// The actual completed date hour selected.
        /// </value>
        public string ActualCompletedDateHourSelected { get; set; }

        /// <summary>
        /// Gets or sets the actual completed date minute selected.
        /// </summary>
        /// <value>
        /// The actual completed date minute selected.
        /// </value>
        public string ActualCompletedDateMinuteSelected { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is actual completed date visible.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is actual completed date visible; otherwise, <c>false</c>.
        /// </value>
        public bool IsActualCompletedDateVisible { get; set; }

        /// <summary>
        /// Gets or sets the special instructions.
        /// </summary>
        /// <value>
        /// The special instructions.
        /// </value>
        [ValidateXss]
        public string SpecialInstructions { get; set; }

        /// <summary>
        /// Gets or sets the bed clean.
        /// </summary>
        /// <value>
        /// The bed clean.
        /// </value>
        public BedClean BedClean { get; set; }

        /// <summary>
        /// Gets or sets the EMS notify icon.
        /// </summary>
        /// <value>
        /// The EMS notify icon.
        /// </value>
        public IconInfo EMSNotifyIcon { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed clean requested.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed clean requested; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedCleanRequested { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed clean accepted.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed clean accepted; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedCleanAccepted { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed clean completed.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed clean completed; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedCleanCompleted { get; set; }

        /// <summary>
        /// Gets or sets the name of the selected ward group.
        /// </summary>
        /// <value>
        /// The name of the selected ward group.
        /// </value>
        public string SelectedWardGroupName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [EMS module inactive].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [EMS module inactive]; otherwise, <c>false</c>.
        /// </value>
        public bool EMSModuleInactive { get; set; }

        /// <summary>
        /// Gets or sets the display EMS module inactive.
        /// </summary>
        /// <value>
        /// The display EMS module inactive.
        /// </value>
        public string DisplayEMSModuleInactive { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is selected reason available.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is selected reason available; otherwise, <c>false</c>.
        /// </value>
        public bool IsSelectedReasonAvailable { get; set; }

        #endregion
    }
}
