using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Facade;
using BMS.Web.App_GlobalResource;
using BMS.Utils;

namespace BMS.Web.Models
{
    /// <summary>
    /// Bed board data model for the bed board screen.
    /// </summary>
    public class BedBoardViewModel
    {
        public Visn VISN { get; set; }

        public string VisnExtension { get; set; }

        public string SelectedFacilityId { get; set; }

        public string SelectedReportSelectionCode { get; set; }

        public CDList ReportSelectionList { get; set; }

        public User LoggedUser { get; set; }

        public IList<TransferInfo> PatientTransferList { get; set; }

        public IList<Facility> FacilityList { get; set; }

        public IList<FacilityModel> FacilityListFiltered
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    if (FacilityList == null)
                        return null;
                    else
                    {
                        IList<Facility> result = FacilityList.Where(x => x.Id.extension != Strings.AllFacilities && x.Address1 != null && x.Address1.city != null).OrderBy(a => a.Address1.city).ToList();
                        if (result == null)
                            result = FacilityList.Where(x => x.Id.extension != Strings.AllFacilities).OrderBy(a => a.Code).ToList();
                        return result.Select(facility => ToFacilityModel(facility, BMSBedOccupancyList[facility.Id.extension], LoggedUserList[facility.Id.extension.ToLower()])).ToList();
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the select report operation for VISN reports.
        /// </summary>
        /// <value>
        /// The select report operation.
        /// </value>
        public string SelectReportOperation { get; set; }

        public Dictionary<string, BedOccupancyCount> BMSBedOccupancyList { get; set; }

        public Dictionary<string, int> LoggedUserList { get; set; }

        public string HeaderCommand { get; set; }

        public List<CD> SpecialtyList { get; set; }

        public bool IsFirstLoad { get; set; }

        public string DiversionReportLink { get; set; }
        
        public string EmerMgmtReportLink { get; set; }

        public class FacilityModel
        {
            public II Id { get; set; }
            public AD Address1 { get; set; }
            public string Code { get; set; }
            public bool IsAlive { get; set; }
            public ST PersonContactName { get; set; }
            public TEL PersonContactEmail { get; set; }
            public TEL PersonContactPhone { get; set; }
            public string Name { get; set; }
            public int Occupancy { get; set; }
            public int LoggedUsers { get; set; }

            public string DiversionInfo { get; set; }
        }

        public static FacilityModel ToFacilityModel(Facility facility, BedOccupancyCount occupaiedAndUnavailableBeds, int loggedUsers)
        {
            FacilityModel model = new FacilityModel();
            model.Id = facility.Id;
            model.Address1 = facility.Address1;
            model.Code = facility.Code;
            model.IsAlive = facility.IsAlive;
            model.PersonContactName = facility.PersonContactName;
            model.PersonContactEmail = facility.PersonContactEmail;
            model.PersonContactPhone = facility.PersonContactPhone;
            model.Name = facility.Name;
            model.LoggedUsers = loggedUsers;
            model.Occupancy = occupaiedAndUnavailableBeds.OccupancyPercent;

            IList<Diversion> diversions = FacadeManager.DiversionInterface.GetDiversions(facility.Id).Where(div => div.Status == Constants.Yes && div.StartDate != null).ToList();
            if (diversions.Count > 0)
            {
                foreach (Diversion diversion in diversions)
                {
                    string diversionInfo = String.Format("- {0}|{1}|{2} Diverted since {3}: {4}\r\n\r\n", diversion.Location.displayName,
                        String.IsNullOrEmpty(diversion.WardGroup) ? "All" : diversion.WardGroup,
                        String.IsNullOrEmpty(diversion.TreatingSpecialty) ? "All" : diversion.TreatingSpecialty,
                        diversion.StartDate.ToShortDateString(), diversion.Comments);

                    model.DiversionInfo += diversionInfo;
                }
            }
            else
                model.DiversionInfo = "No Diversions";

            return model;
        }
    }
}
