﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.VistaIntegration.FacadeContracts.Admin;
using BMS.Utils;

namespace BMS.Web.Models
{
    public class BackgroundProcessorsViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the current scheduler.
        /// </summary>
        /// <value>
        /// The current scheduler.
        /// </value>
        public JobCalendar CurrentWhiteboardScheduler { get; set; }

        /// <summary>
        /// Gets or sets the whiteboard report schedulers.
        /// </summary>
        /// <value>
        /// The whiteboard report schedulers.
        /// </value>
        public List<JobCalendar> WhiteboardReportSchedulers { get; set; }

        /// <summary>
        /// Gets or sets the schedulers.
        /// </summary>
        /// <value>
        /// The schedulers.
        /// </value>
        public List<JobCalendar> WaitingListSchedulers { get; set; }

        /// <summary>
        /// Gets or sets the selected whiteboard scheduler id.
        /// </summary>
        /// <value>
        /// The selected whiteboard scheduler id.
        /// </value>
        public string SelectedWhiteboardSchedulerId { get; set; }

        /// <summary>
        /// Gets or sets the selected scheduler id.
        /// </summary>
        /// <value>
        /// The selected scheduler id.
        /// </value>
        public string SelectedWaitingListSchedulerId { get; set; }

        /// <summary>
        /// Gets or sets the selected method id.
        /// </summary>
        /// <value>
        /// The selected method id.
        /// </value>
        public string SelectedWaitingListMethodId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [H l7 checked].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [H l7 checked]; otherwise, <c>false</c>.
        /// </value>
        public bool HL7Checked { get; set; }

        /// <summary>
        /// Gets or sets the retrieval methods.
        /// </summary>
        /// <value>
        /// The retrieval methods.
        /// </value>
        public List<SelectableEnum<DataRetrievalMethod>> RetrievalMethods { get; set; }

        /// <summary>
        /// Gets or sets the current waiting list scheduler.
        /// </summary>
        /// <value>
        /// The current waiting list scheduler.
        /// </value>
        public string CurrentWaitingListScheduler { get; set; }

        /// <summary>
        /// Gets or sets the button save whiteboard scheduler.
        /// </summary>
        /// <value>
        /// The button save whiteboard scheduler.
        /// </value>
        public string ButtonSaveWhiteboardScheduler { get; set; }

        /// <summary>
        /// Gets or sets the button save waiting list scheduler.
        /// </summary>
        /// <value>
        /// The button save waiting list scheduler.
        /// </value>
        public string ButtonSaveWaitingListScheduler { get; set; }
    }
}