﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.Web.Mvc;
using System.ComponentModel.DataAnnotations;
using BMS.Web.App_GlobalResource;
using BMS.Web.Controllers.Shared;
using BMS.Utils;

namespace BMS.Web.Models
{
    /// <summary>
    /// Model for MaintainMarquee view.
    /// </summary>
    public class ApplicationParametersModel : BaseViewModel
    {
        [AllowHtml]
        public string ClinicalInventoryLink { get; set; }

        public string NationalPatientPlacementAlertEmail { get; set; }

        public ApplicationParameters ToApplicationParameters()
        {
            ApplicationParameters parameters = new ApplicationParameters();
            parameters.Items.Add(Constants.APPLICATION_PARAMETERS_CLINICAL_INVENTORY, new ApplicationParameter() { Key = Constants.APPLICATION_PARAMETERS_CLINICAL_INVENTORY, Value = ClinicalInventoryLink });
            parameters.Items.Add(Constants.APPLICATION_PARAMETERS_NPP_ALERT_EMAIL, new ApplicationParameter() { Key = Constants.APPLICATION_PARAMETERS_NPP_ALERT_EMAIL, Value = NationalPatientPlacementAlertEmail });

            return parameters;
        }
    }
}