﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using VI = BMS.VistaIntegration.FacadeContracts;
using FD = BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.ComponentModel.DataAnnotations;
using BMS.Web.App_GlobalResource;
using System.Web.Mvc;
using BMS.Web.Controllers.Shared;
using BMS.VistaIntegration.FacadeContracts.Admin;
using BMS.Utils;
using System.Text.RegularExpressions;
using BMS.Web.Models.Shared;
using System.Security;

namespace BMS.Web.Models
{
    public class VistaSitesViewModel : BaseViewModel
    {
        private SecureString odb_password;

        public IList<VI.VistASite> VistaSites { get; set; }
        
        public IList<FD.VistaSite> VistaEntities { get; set; }

        [Required(ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredSiteId")]
        public string VistaSiteId { get; set; }
        
        public string VistaSiteName { get; set; }
        
        [Required(ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredTimezone")]
        public string VistaSiteTimeZone { get; set; }
        
        [ValidateXss]
        //[AllowHtml]
        [RequiredIfForAction("TestOdbcConnection", "TestOdbcConnection", "TestOdbcConnection", ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredOdbcConnectionString")]
        public string VistaOdbcConnectionString { get; set; }

        [ValidateXss]
        [RequiredIfForAction("TestOdbcConnection", "TestOdbcConnection", "TestOdbcConnection", ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredOdbcUser")]
        public string VistaOdbcUser { get; set; }
       
        [RequiredIfForAction("TestOdbcConnection", "TestOdbcConnection", "TestOdbcConnection", ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredOdbcPassword")]
        [DataType(DataType.Password)]
        //public string VistaOdbcPassword { get; set; }
        public string VistaOdbcPassword
        {
            get
            {
                return SecureStringUtils.ConvertToUnsecureString(odb_password);
            }

            set
            {
                odb_password = SecureStringUtils.ConvertToSecureString(value);
            }
        }

        
        public string VistASiteNumber { get; set; }        

        public string TestOdbcConnection { get; set; }
        
        public string TestMDWSConnection { get; set; }
        
        public string TestResultMDWSConnection { get; set; }

        public CDList TimeZoneList { get; set; }

        public string MdwsEndpointConfigKey { get; set; }

        public string ViaEndpointConfigKey { get; set; }

        public Dictionary<string, string> MdwsEndpointConfigKeyList { get; set; }

        public Dictionary<string, string> ViaEndpointConfigKeyList { get; set; }
    }

    public class SchedulersViewModel : BaseViewModel
    {
        public IList<VI.Admin.JobCalendar> Calendars { get; set; }

        public string CalendarId { get; set; }
        
        [ValidateXss]
        [Required(ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredCalendarName")]
        public string CalendarName { get; set; }
        
        public string OccurrenceInterval { get; set; }
        
        [Range(1, Int32.MaxValue, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRecursBad")]
        public int Recurs { get; set; }
        
        [CheckTimeEqualToIfAttribute("StartMinute", "EndHour", "EndMinute", false, "OccursOnce", false,
            ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorStartEndTimeBad")]
        
        public string StartHour { get; set; }
        
        public string StartMinute { get; set; }
        
        public string EndHour { get; set; }
        
        public string EndMinute { get; set; }
        
        [RangeIf("RunIntervalUnit", "Minute", 1, 59, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRunIntervalMinuteBad")]
        [RangeIf("RunIntervalUnit", "Hour", 1, 23, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRunIntervalHourBad")]
        public int RunInterval { get; set; }
        
        public string RunIntervalUnit { get; set; }
        
        public bool OccursOnce { get; set; }

        public bool SpecificDayOfSpecificWeek { get; set; }
        
        [Range(1, 5, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorIndexOfWeekDayBad")]
        public int IndexOfWeekday { get; set; }
        
        public string Weekday { get; set; }
        
        [Range(1, 31, ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorIndexOfDayInMonthBad")]
        public int IndexOfDayInMonth { get; set; }

        public bool MondaySelected { get; set; }
        
        public bool TuesdaySelected { get; set; }
        
        public bool WednesdaySelected { get; set; }
        
        public bool ThursdaySelected { get; set; }
        
        public bool FridaySelected { get; set; }
        
        public bool SaturdaySelected { get; set; }
        
        public bool SundaySelected { get; set; }
        
        public List<string> DaysOfWeek { get; set; }
        
        public List<string> OccurrenceIntervals { get; set; }
        
        public List<string> RunIntervals { get; set; }
        
        public List<string> RetrievalMethods { get; set; }

        [Required(ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "SchedulerErrorRequiredTimezone")]
        public string TimeZone { get; set; }
        
        public CDList TimeZoneList { get; set; }
    }

    public class CategoriesViewModel : BaseViewModel
    { 
        public IList<VI.VistASite> VistaSites { get; set; }
        public IList<VI.Admin.JobCalendar> Calendars { get; set; }
        public VI.VistASite SelectedVistaSite { get; set; }
        [Required(ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredSiteId")]
        public string VistaSiteId { get; set; }
        public string VistaSiteName { get; set; }
        public string CalendarName { get; set; }
        public string StartHour { get; set; }
        public string StartMinute { get; set; }
        public string EndHour { get; set; }
        public string EndMinute { get; set; }

        public DateTime StartDateTime { get; set; }
        public string StartDateTimeString
        {
            get { return StartDateTime.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        StartDateTime = DateTime.Parse(value);
                    }
                    catch
                    {
                        StartDateTime = DateTime.Now;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public DateTime EndDateTime { get; set; }
        public string EndDateTimeString
        {
            get { return EndDateTime.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        EndDateTime = DateTime.Parse(value);
                    }
                    catch
                    {
                        EndDateTime = DateTime.Now;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        [RequiredIfForAction("SaveButton", "Save", "SaveButton", ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredSelectedDataType")]
        public string SelectedDataType { get; set; }
        public bool HL7Checked { get; set; }
        [RequiredIfForAction("SaveButton", "Save", "SaveButton", ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredRetrievalMethod")]
        public string RetrievalMethod { get; set; }
        [RequiredIfForAction("SaveButton", "Save", "SaveButton", ErrorMessageResourceType = typeof(Strings), ErrorMessageResourceName = "VistaIntegrationErrorRequiredCalendarId")]
        public string SelectedSchedulerId { get; set; }
        public string RetrievalMethodRun { get; set; }

        public bool RetrieveEntities { get; set; }
        public bool RetrieveVocabularies { get; set; }
        public bool RetrieveHospitalLocation { get; set; }
        public bool RetrievePatient { get; set; }
        public bool RetrieveRoomBed { get; set; }
        public bool RetrieveWardLocation { get; set; }
        public bool RetrieveOrderableItem { get; set; }
        public bool RetrieveSpecialty { get; set; }
        public bool RetrieveTreatingSpecialty { get; set; }
        public bool RetrieveFacilityMovementType { get; set; }
        public bool RetrieveADT { get; set; }
        public bool RetrieveMedicalCenterDivision { get; set; }
        public bool RetrieveWaitingList { get; set; }
        public string InvisibleButton { get; set; }
        public string SaveButton { get; set; }
        public string RemoveButton { get; set; }
        public string RunButton { get; set; }
        public string RunOnDemandResult { get; set; }

        public List<SelectableEnum<DataRetrievalMethod>> RetrievalMethods { get; set; }
        public List<string> OnDemandRetrievalMethods { get; set; }
    }

    public class AuditViewModel : BaseViewModel
    {
        public AuditViewModel()
        {
            DataTypes = new List<SelectableEnum<VI.Admin.VistaDataType>>();
        }

        public List<SelectableSite> VistaSites { get; set; }
        public List<SelectableEnum<DataRetrievalMethod>> RetrievalMethods { get; set; }
        public List<SelectableEnum<VI.Admin.VistaDataType>> DataTypes { get; set; }
        public List<SelectableEnum<JobStatus>> Status { get; set; }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveHospitalLocation
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.HospitalLocation); }
            set { DataTypes.Add(value); }
        }
        public SelectableEnum<VI.Admin.VistaDataType> RetrievePatient
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.Patient); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveRoomBed
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.RoomBed); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveWardLocation
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.WardLocation); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveOrderableItem
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.OrderableItem); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveSpecialty
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.Specialty); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveTreatingSpecialty
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.TreatingSpecialty); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveFacilityMovementType
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.FacilityMovementType); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveADT
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.ADT); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveMedicalCenterDivision
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.MedicalCenterDivision); }
            set { DataTypes.Add(value); }
        }

        public SelectableEnum<VI.Admin.VistaDataType> RetrieveWaitingList
        {
            get { return DataTypes.Find(s => s.EnumValue == VI.Admin.VistaDataType.PatientsPendingBedPlacementList); }
            set { DataTypes.Add(value); }
        }


        public string SelectedPeriod { get; set; }

        /// <summary>
        /// Gets or sets the hour start date selected.
        /// </summary>
        /// <value>
        /// The hour start date selected.
        /// </value>
        public string HourStartDateSelected { get; set; }
        /// <summary>
        /// Gets or sets the minute start date selected.
        /// </summary>
        /// <value>
        /// The minute start date selected.
        /// </value>
        public string MinuteStartDateSelected { get; set; }
        /// <summary>
        /// Gets or sets the second start date selected.
        /// </summary>
        /// <value>
        /// The second start date selected.
        /// </value>
        public string SecondStartDateSelected { get; set; }

        public DateTime StartDateTime { get; set; }
        public string StartDateTimeString
        {
            get { return StartDateTime.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        StartDateTime = DateTime.Parse(value);
                    }
                    catch
                    {
                        StartDateTime = DateTime.Now;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }


        /// <summary>
        /// Gets or sets the hour end date selected.
        /// </summary>
        /// <value>
        /// The hour end date selected.
        /// </value>
        public string HourEndDateSelected { get; set; }


        /// <summary>
        /// Gets or sets the minute end date selected.
        /// </summary>
        /// <value>
        /// The minute end date selected.
        /// </value>
        public string MinuteEndDateSelected { get; set; }


        /// <summary>
        /// Gets or sets the second end date selected.
        /// </summary>
        /// <value>
        /// The second end date selected.
        /// </value>
        public string SecondEndDateSelected { get; set; }

        public DateTime EndDateTime { get; set; }
        public string EndDateTimeString
        {
            get { return EndDateTime.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        EndDateTime = DateTime.Parse(value);
                    }
                    catch
                    {
                        EndDateTime = DateTime.Now;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public IList<JobLogModel> LogEntries { get; set; }
        public int PageSize { get; set; }
        public int CurrentPage { get; set; }

        public int FilterCheckBoxLines
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    int sitesNr = VistaSites != null ? VistaSites.Count : 0;
                    int methodsNr = RetrievalMethods != null ? RetrievalMethods.Count : 0;
                    int dataTypesNr = DataTypes != null ? DataTypes.Count : 0;

                    int max = 0;

                    max = sitesNr >= methodsNr ? sitesNr : methodsNr;
                    max = max >= dataTypesNr ? max : dataTypesNr;

                    return max;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        public string FilterButton { get; set; }
        public string OtherPageButton { get; set; }
        public string PreviousFilterVistaSiteId { get; set; }
        public string PreviousFilterDataType { get; set; }
        public string PreviousFilterRetrievalMethod { get; set; }
        public string PreviousFilterSelectedPeriod { get; set; }
        public string PreviousFilterStartDateTimeString { get; set; }
        public string PreviousFilterEndDateTimeString { get; set; }
    }

    public class ErrorDetailModel
    {
        public string VistaSiteName { get; set; }
        public string ErrorMessage { get; set; }
        public string RetrievalMethod { get; set; }
        public string DataType { get; set; }
    }

    public class SelectableEnum<T> where T : struct, IConvertible
    {
        public SelectableEnum()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IsSelected = false;
                EntityName = string.Empty;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public SelectableEnum(T enumValue, bool isSelected)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!typeof(T).IsEnum)
                    throw new ArgumentException("T must be an enumerated type");

                IsSelected = isSelected;
                EntityName = Enum.GetName(typeof(T), enumValue);
                //EnumValue = enumValue;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public bool IsSelected { get; set; }
        public string EntityName { get; set; }
        public T EnumValue
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return (T)Enum.Parse(typeof(T), EntityName);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    EntityName = Enum.GetName(typeof(T), value);
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
        public string DisplayName
        {
            get { return EntityName == null ? string.Empty : Regex.Replace(Regex.Replace(EntityName, @"(\P{Ll})(\P{Ll}\p{Ll})", "$1 $2"), @"(\p{Ll})(\P{Ll})", "$1 $2"); }
            set { EntityName = Regex.Replace(value, @"\s+", ""); }
        }
    }

    public class SelectableSite
    {
        public SelectableSite()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IsSelected = false;
                EntityName = string.Empty;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public SelectableSite(VI.VistASite vistaSite, bool isSelected)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IsSelected = isSelected;
                EntityName = vistaSite.Name;
                Id = vistaSite.Id;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public bool IsSelected { get; set; }
        public string EntityName { get; set; }
        public string DisplayName { get { return EntityName; } }
        public string Id { get; set; }
    }
}
