﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using BMS.Utils;
using BMS.Facade;
using BMS.ServicesWrapper.BMService;
using BMS.Facade.Data;
using System.Diagnostics;
using BMS.Security.DurableIssuedToken;
using System.Web.SessionState;
using System.Web.Security;
using BMS.Facade.Fault;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.ServiceModel;
using BMS.Web.Controllers.Shared;
using System.Configuration;
using System.Threading.Tasks;

namespace BMS.Web
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801

    public class MvcApplication : System.Web.HttpApplication
    {
        public static float CPUStatus { get; private set; }

        string url = null;

        public static void RegisterGlobalFilters(GlobalFilterCollection filters)
        {
            filters.Add(new HandleErrorAttribute());
        }

        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            routes.MapRoute(
                "FacilityDiversion", //Route name
                "{controller}/{action}/{id}/{location}", //Parameter defaults
                new { controller = "Home", action = "Index", id = UrlParameter.Optional, location = UrlParameter.Optional }
            );
            routes.MapRoute(
                "Default", // Route name
                "{controller}/{action}/{id}", // URL with parameters
                new { controller = "Home", action = "Index", id = UrlParameter.Optional } // Parameter defaults
            );
            routes.MapRoute(
                "WardWhiteboard", // Route name
                "{controller}/{action}/{id}", // URL with parameters
                new { controller = "WardWhiteboard", action = "Index", id = UrlParameter.Optional } // Parameter defaults
            );
        }

        protected void Application_Start()
        {
            ViewEngines.Engines.Clear();
            ViewEngines.Engines.Add(new RazorViewEngine());

            AreaRegistration.RegisterAllAreas();

            RegisterGlobalFilters(GlobalFilters.Filters);
            RegisterRoutes(RouteTable.Routes);

            ModelBinders.Binders.Add(typeof(string), new XssModelBinder());
            ModelMetadataProviders.Current = new XssModelMetadataProvider();

            bool resetLoggedUsers;
            bool.TryParse(ConfigurationManager.AppSettings["Is_IIS_Single_Instance"], out resetLoggedUsers);
            if (resetLoggedUsers)
                BMSFactory.BedManagerOperationsClientWindows.ClearLoggedUsers("domain");

            ThreadPool.QueueUserWorkItem((o) =>
            {
                try
                {
                    BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.FillCache();
                }
                catch (CommunicationObjectAbortedException)
                {
                    try
                    {
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.FillCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ApplicationStart Cache - EIS");
                        Tracer.TraceException(ex);
                    }
                }
                catch (ObjectDisposedException)
                {
                    try
                    {
                        BMS.ServicesWrapper.EIS.EISFactory.InstanceWindows.FillCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ApplicationStart Cache - EIS");
                        Tracer.TraceException(ex);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceMessage("ApplicationStart Cache - EIS");
                    Tracer.TraceException(ex);
                }
            });
            ThreadPool.QueueUserWorkItem((o) =>
            {
                try
                {
                    BMS.ServicesWrapper.EVS.EVSFactory.InstanceWindows.FillCache();
                }
                catch (CommunicationObjectAbortedException)
                {
                    try
                    {
                        BMS.ServicesWrapper.EVS.EVSFactory.InstanceWindows.FillCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ApplicationStart Cache - EVS");
                        Tracer.TraceException(ex);
                    }
                }
                catch (ObjectDisposedException)
                {
                    try
                    {
                        BMS.ServicesWrapper.EVS.EVSFactory.InstanceWindows.FillCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ApplicationStart Cache - EVS");
                        Tracer.TraceException(ex);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceMessage("ApplicationStart Cache - EVS");
                    Tracer.TraceException(ex);
                }
            });
            ThreadPool.QueueUserWorkItem((o) =>
            {
                try
                {
                    BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.FillCache();
                }
                catch (CommunicationObjectAbortedException)
                {
                    try
                    {
                        BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.FillCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ApplicationStart Cache - Security");
                        Tracer.TraceException(ex);
                    }
                }
                catch (ObjectDisposedException)
                {
                    try
                    {
                        BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.FillCache();
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage("ApplicationStart Cache - Security");
                        Tracer.TraceException(ex);
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceMessage("ApplicationStart Cache - Security");
                    Tracer.TraceException(ex);
                }
            });

#if !DEBUG
            System.Timers.Timer timer = new System.Timers.Timer(30000);
            timer.Elapsed += async (sender, e) => await HandleCPUStatusCheck();
            timer.AutoReset = true;
            timer.Start();
#endif
        }

        private static Task HandleCPUStatusCheck()
        {
            Task cpuStatusCheckTask = Task.Run(() =>
            {
                PerformanceCounter cpuCounter;
                cpuCounter = new PerformanceCounter();
                cpuCounter.CategoryName = "Processor";
                cpuCounter.CounterName = "% Processor Time";
                cpuCounter.InstanceName = "_Total";
                cpuCounter.NextValue();
                System.Threading.Thread.Sleep(1000);
                CPUStatus = cpuCounter.NextValue();
            });

            return cpuStatusCheckTask;
        }

        protected void Session_End(object sender, EventArgs e)
        {
            SessionEnd(Session);
        }

        /// <summary>
        /// Ends the session.
        /// </summary>
        /// <param name="session"></param>
        public static void SessionEnd(HttpSessionState session)
        {
            try
            {
                PersistenceIssuedTokenCacheFactory.GetIssuedTokenCache().RemoveToken(session.SessionID);
            }
            catch (Exception ex) { Tracer.TraceException(ex); }
            try
            {
                User user = (User)session["User"];
                if (user != null)
                {
                    ProxyManager.ClearUserProxies(user.UserName);
                    if (!user.IsSuperUser)
                    {
                        BMS.ServicesWrapper.Security.SecurityFactory.Instance.ClearUserPermissionCache(user.UserName);
                        if (!bool.Parse(ConfigurationManager.AppSettings["Is_IIS_Single_Instance"]))
                            ThreadPool.QueueUserWorkItem((o) => { BMS.ServicesWrapper.BMService.BMSFactory.BedManagerCacheClientWindows.ClearUserPermissionCache(user.UserName); });
                    }
                }
            }
            catch (Exception ex) { Tracer.TraceException(ex); }                       
        }

        void Application_BeginRequest(Object source, EventArgs e)
        {
            HttpContext context = HttpContext.Current;            
            url = FirstRequestInitialisation.Initialize(context);
            if (!string.IsNullOrEmpty(url))
                BMSFactory.BedManagerCacheClientFromWCF.InsertWebClientAddress(url);
        }        
    }

    class FirstRequestInitialisation
    {
        private static bool s_InitializedAlready = false;
        private static Object s_lock = new Object();
        // Initialize only on the first request
        public static string Initialize(HttpContext context)
        {
            string result = string.Empty;
            if (s_InitializedAlready)
            {
                return null;
            }
            lock (s_lock)
            {
                if (s_InitializedAlready)
                {
                    return null;
                }
                Uri uri = context.Request.Url;
                result = uri.Scheme + Uri.SchemeDelimiter + uri.Host + ":" + uri.Port;
                if (uri.Host.Equals("localhost"))
                {
                    string localIP = "?";
                    IPHostEntry dnshost = Dns.GetHostEntry(Dns.GetHostName());
                    foreach (IPAddress ip in dnshost.AddressList)
                    {
                        if (ip.AddressFamily == AddressFamily.InterNetwork)
                            localIP = ip.ToString();
                    }
                    result = result.Replace("localhost", localIP);
                }
                s_InitializedAlready = true;
                return result;
            }
        }
    }
}
