﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class WhiteboardStaffController : BaseController
    {
        [ReadPermissionAuthFilter]
        public ActionResult Index(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WhiteboardStaffViewModel model = new WhiteboardStaffViewModel();
                model.DivisionParameter = QueryStrings["divisionId"];
                model.SplitScreenParameter = QueryStrings["splitScreen"];
                model.DisplayPTParameter = QueryStrings["displayPTCode"];
                model.GenderColorParameter = QueryStrings["genderColorCode"];
                model.SortByParameter = QueryStrings["sortBy"];
                model.DisplayFooterCensusParameter = QueryStrings["displayFooterCensus"];
                model.DisplayStaffAttendingParameter = QueryStrings["displayStaffAttending"];
                int scrollRate;
                Int32.TryParse(QueryStrings["scrollRate"], out scrollRate);
                model.ScrollRateParameter = scrollRate;
                model.DivisionIdSelected = QueryStrings["divisionSelected"];
                model.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).OrderBy(a => a.Name).ToList();
                List<Bed> beds = new List<Bed>();
                string wardIdList = string.Empty;
                List<Ward> wards = new List<Ward>();
                List<Bed> bedsDNDAndOOS = new List<Bed>();
                if (string.IsNullOrEmpty(model.DivisionIdSelected) || model.DivisionIdSelected.Equals(Guid.Empty.ToString()))
                {

                    wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id).ToList();
                    foreach (Ward ward in wards)
                        wardIdList += ward.Id.extension + ",";
                    bedsDNDAndOOS = FacadeManager.BedInterface.GetBedsDNDAndOOS(wardIdList, this.loggedUser.Facility.Id).ToList();
                    List<Bed> bedsTemp = new List<Bed>();
                    foreach (Division div in model.DivisionList)
                    {

                        bedsTemp = (from bedTemp in FacadeManager.EntityInterface.GetBedsInDivision(div.Id, loggedUser.VistaSite.Id)
                                    where !(from bedDNDOrOOS in bedsDNDAndOOS select bedDNDOrOOS.Id.extension.ToLower()).Contains(bedTemp.Id.extension.ToLower())
                                    select bedTemp).ToList();
                        beds.AddRange(from a in bedsTemp
                                      where !(from b in beds select b.Id.extension.ToLower()).Contains(a.Id.extension.ToLower())
                                      select a);
                    }
                    model.DivisionIdSelected = Guid.Empty.ToString();
                }
                else
                {
                    wards = FacadeManager.EntityInterface.GetWardsByDivisionId(new II(this.loggedUser.Domain, model.DivisionIdSelected)).ToList();
                    foreach (Ward ward in wards)
                        wardIdList += ward.Id.extension + ",";
                    bedsDNDAndOOS = FacadeManager.BedInterface.GetBedsDNDAndOOS(wardIdList, this.loggedUser.Facility.Id).ToList();

                    beds = (from bedTemp in FacadeManager.EntityInterface.GetBedsInDivision(new II(this.loggedUser.Domain, model.DivisionIdSelected), loggedUser.VistaSite.Id)
                            where !(from bedDNDOrOOS in bedsDNDAndOOS select bedDNDOrOOS.Id.extension.ToLower()).Contains(bedTemp.Id.extension.ToLower())
                            select bedTemp).ToList();
                }

                model.BedList = beds.Select(a => new Bed { Id = a.Id, Name = (!string.IsNullOrEmpty(a.NurseAssignment)) ? a.Name + " (" + a.NurseAssignment + ")" : a.Name })
                                        .Select(b => new CheckItem<Bed>() { Item = b }).OrderBy(c => c.Item.Name).ToList();
                model.DivisionList.Insert(0, new Division() { Id = new II() { root = this.loggedUser.Domain, extension = Guid.Empty.ToString() }, Name = Strings.All });
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Index(WhiteboardStaffViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(input.ButtonDivisionChanged))
                    return this.RedirectToAction<WhiteboardStaffController>(act => act.Index(EncryptQueryString(new string[] { "divisionId", "splitScreen", "displayPTCode", "genderColorCode", "sortBy", "displayFooterCensus", "displayStaffAttending", "scrollRate", "divisionSelected" }, new string[] { input.DivisionParameter, input.SplitScreenParameter, input.DisplayPTParameter, input.GenderColorParameter, input.SortByParameter, input.DisplayFooterCensusParameter, input.DisplayStaffAttendingParameter, null, input.DivisionIdSelected }, loggedUser.Salt)));

                if (input.BedList.Where(a => a.IsChecked).Count() == 0)
                {
                    ModelState.AddModelError(string.Empty, "Select at least one bed!");
                    input.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).OrderBy(a => a.Name).ToList();
                    input.DivisionList.Insert(0, new Division() { Id = new II() { root = this.loggedUser.Domain, extension = Guid.Empty.ToString() }, Name = Strings.All });
                    return View(input);
                }
                Bed bed = null;
                foreach (CheckItem<Bed> item in input.BedList)
                {
                    if (item.IsChecked)
                    {
                        bed = FacadeManager.BedInterface.GetBed(item.Item.Id, loggedUser.VistaSite.Id);
                        bed.NurseAssignment = input.Staff;
                        FacadeManager.BedInterface.UpdateBed(bed);
                        string divisionId = string.Empty;
                        if (input.DivisionIdSelected == Guid.Empty.ToString())
                            divisionId = bed.CommentList.Select(a => a.Division.Id.extension).FirstOrDefault();
                        else
                            divisionId = input.DivisionIdSelected;

                        FacadeManager.BedInterface.ManageBedStaff(bed, new Division { Id = new II(this.loggedUser.Domain, divisionId) }, bed.NurseAssignment, null, this.loggedUser.Facility);
                    }
                }
                return this.RedirectToAction<WardWhiteboardController>(act => act.WardWhiteBoard(EncryptQueryString(new string[] { "divisionId", "splitScreen", "displayPTCode", "genderColorCode", "sortBy", "displayFooterCensus", "displayStaffAttending", "scrollRate", "scrollValue", "scrollDirection" }, new string [] { input.DivisionParameter, input.SplitScreenParameter, input.DisplayPTParameter, input.GenderColorParameter, input.SortByParameter, input.DisplayFooterCensusParameter, input.DisplayStaffAttendingParameter, input.ScrollRateParameter.ToString(), null, null }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
