﻿using System;
using System.Web.Mvc;
using BMS.Web.Models;
using Microsoft.Web.Mvc;
using BMS.Facade;
using BMS.ServicesWrapper.Security;
using BMS.Facade.Data;
using System.Collections.Generic;
using InfoWorld.HL7.ITS;
using BMS.Facade.Fault;
using System.ServiceModel;
using BMS.Utils.Properties;
using System.Diagnostics;
using System.Reflection;
using System.Linq;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using System.Text;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class SiteOptionsController : BaseController
    {        
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SiteOptionsViewModel model = new SiteOptionsViewModel(); 
                FillViewModel(model);
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// POST SiteOptions.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Index(SiteOptionsViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(model.ButtonSubmitEvacuation))
                    return this.RedirectToAction<SiteOptionsController>(act => act.EvacuationConfirmation(EncryptQueryString(new string[] { "showSureQuestion", "isEvacuation" }, new string[] { "true", model.IsEvacuation.ToString() }, loggedUser.Salt)));
                else if (!string.IsNullOrEmpty(model.ButtonSubmitResetSummary))
                {
                    IList<Ward> wards = FacadeManager.EntityInterface.GetWardsByDivisionId(new II(this.loggedUser.Domain, model.DivisionSelectedId));
                    StringBuilder sb = new StringBuilder();
                    foreach (Ward w in wards)
                    {
                        sb.Append(w.Id.extension);
                        sb.Append(",");
                    }
                    List<II> beds = FacadeManager.BedInterface.GetBedsDNDOrOOS(sb.ToString(), model.ResetSummaryUnavailableSelected);
                    FillViewModel(model);
                    if (beds != null && beds.Count > 0)
                    {
                        Division division = FacadeManager.EntityInterface.GetDivisionById(new II(this.loggedUser.Domain, model.DivisionSelectedId));
                        BedUnavailable bedUnavailable = null;
                        BedUnavailableHistory bedUnavailableHistory = null;
                        Bed bed = null;
                        II id = null;
                        foreach (II bedId in beds)
                        {
                            id = new II(this.loggedUser.Domain, bedId.extension);
                            bed = FacadeManager.BedInterface.GetBed(id, loggedUser.VistaSite.Id);
                            bedUnavailable = FacadeManager.BedInterface.GetBedUnavailable(id, loggedUser.Facility.Id);
                            if (bedUnavailable != null)
                            {
                                bedUnavailable.CanceledBy = this.loggedUser.UserName;
                                bedUnavailable.CanceledDate = model.FacilityDateTime;
                                bedUnavailable.EditedBy = this.loggedUser.UserName;
                                bedUnavailable.EditedDate = model.FacilityDateTime;
                                bedUnavailable.OutOfServiceVistA = false;
                                bedUnavailableHistory = TranslateBedUnavailableHistory(bedUnavailable, division);
                                FacadeManager.WorkflowInterface.CancelBedUnavailable(bedUnavailable, loggedUser.Facility);
                                FacadeManager.BedInterface.InsertBedUnavailableHistory(bedUnavailableHistory, this.loggedUser.Facility.Id);
                                foreach (BedComment bc in bed.CommentList)
                                {
                                    if (bc.Division != null && bc.Division.Id != null && bc.Division.Id.extension.Equals(model.DivisionSelectedId, StringComparison.InvariantCultureIgnoreCase))
                                    {
                                        bc.Comment = null;
                                        FacadeManager.BedInterface.UpdateBed(bed);
                                        break;
                                    }
                                }
                            }
                        }
                        model.ResetSummaryResultText = "Done";
                    }
                    else
                        model.ResetSummaryResultText = "None Found";
                    return View(model);
                }
                return null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Go to delete page.
        /// </summary>
        /// <param name="ien">The ien.</param>
        /// <returns></returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult EvacuationConfirmation(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return View(new SiteOptionsViewModel
                {
                    FacilityDateTime = DateTimeNowOnCurrentFacility,
                    VISN = loggedUser.Visn.Number,
                    Region = loggedUser.Visn.Region.Number.ToString(),
                    IsEvacuation = bool.Parse(QueryStrings["isEvacuation"]),
                    IsEvacConfirmationSureQuestionVisible = bool.Parse(QueryStrings["showSureQuestion"]),
                    LoggedUser = loggedUser
                });
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// POST EvacuationConfirmation.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult EvacuationConfirmation(SiteOptionsViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.ConfigurationInterface.SaveIsEvacuation(model.IsEvacuation, this.loggedUser.Domain, this.loggedUser.Facility.Id.extension);
                if (model.IsEvacuation)
                {
                    string wardIdList = string.Empty;
                    IList<Ward> wards = new List<Ward>();
                    wards = FacadeManager.EntityInterface.GetWardsByFacility(this.loggedUser.Facility.Id);
                    foreach (Ward ward in wards)
                        wardIdList += ward.Id.extension + ",";
                    IList<EvacuationPatient> evacuationPatients = FacadeManager.ADTInterface.GetEvacuationPatients(this.loggedUser.Facility.Id, wardIdList);
                    CD waitingArea = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.WaitingArea).Where(a => a.code.Equals(Constants.WAITING_AREA_EVACUATION_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    CD evacDispositionStatus = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.EvacDispositionStatus).Where(a => a.code.Equals(Constants.EVAC_DISPOSITION_STATUS_EVACUATE_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    CD evacTransportationProvider = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.TransportationProvider).Where(a => a.code.Equals(Constants.EVAC_TRANSPORTATION_PROVIDER_VA_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    foreach (EvacuationPatient evacuationPatient in evacuationPatients)
                        AddPatientIntoWaitingList(evacuationPatient.Patient, evacuationPatient.FlowId, waitingArea, evacDispositionStatus, evacTransportationProvider);
                }
                return this.RedirectToAction<SiteOptionsController>(act => act.EvacuationConfirmation(EncryptQueryString(new string[] { "showSureQuestion", "isEvacuation" }, new string[] { "false", model.IsEvacuation.ToString() }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void FillViewModel(SiteOptionsViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                model.FacilityDateTime = DateTimeNowOnCurrentFacility;
                model.VISN = loggedUser.Visn.Number;
                model.VISNExtension = loggedUser.Visn.Id.extension;
                model.FacilityExtension = loggedUser.Facility.Id.extension;
                model.Region = loggedUser.Visn.Region.Number.ToString();
                model.RegionExtension = loggedUser.Visn.Region.Id.extension;
                model.IsEvacuation = FacadeManager.ConfigurationInterface.GetIsEvacuation(this.loggedUser.Domain, this.loggedUser.Facility.Id.extension);
                model.DivisionList = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).OrderBy(a => a.Name).ToList();
                model.DivisionList.Insert(0, new Division() { Id = new II() { root = this.loggedUser.Domain, extension = string.Empty }, Name = string.Empty });                
                model.ResetSummaryResultText = Strings.None.ToUpper();
                model.LoggedUser = loggedUser;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private BedUnavailableHistory TranslateBedUnavailableHistory(BedUnavailable bedUnavailable, Division division)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                BedUnavailableHistory result = new BedUnavailableHistory();
                result.Bed = bedUnavailable.Bed;
                result.CanceledBy = bedUnavailable.CanceledBy;
                result.CanceledDate = bedUnavailable.CanceledDate;
                result.CreatedBy = bedUnavailable.CreatedBy;
                result.CreationDate = bedUnavailable.CreationDate;
                result.EditedBy = bedUnavailable.EditedBy;
                result.EditedDate = bedUnavailable.EditedDate;
                result.Id = bedUnavailable.Id;
                result.Parent = bedUnavailable.Parent;
                result.Patient = bedUnavailable.Patient;
                result.Reason = bedUnavailable.Reason;
                result.Type = bedUnavailable.Type;
                result.VistaSite = bedUnavailable.VistaSite;
                result.ExpectedCompletedDate = bedUnavailable.ExpectedCompletedDate;
                result.Comment = "ADMIN CLEARED " + bedUnavailable.Type.code;
                result.Division = division;
                result.IsChangedOnlyComment = true;
                result.IsClearAll = false;
                result.OutOfServiceVistA = false;
                result.PatientId = bedUnavailable.PatientId;                
                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter(OperationOverride = "AuditLogReport, Index")]
        public ActionResult ViewIconReport()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<IReportInfo> listReports = FacadeManager.ReportsInterface.GetOtherReports(FullUserName);
                IReportInfo report = null;

                if (listReports.Count > 0)
                    report = listReports.Where(rpt => rpt.Name == Constants.ICON_USAGE_RPT).FirstOrDefault();

                //Redirect to the report
                if (report == null)
                    throw new ReportRenderException(Constants.ICON_USAGE_RPT, Strings.ERR_ReportNotAvailable);
                else
                {
                    if (report.Parameters == null)
                        report.Parameters = new Dictionary<string, string>();

                    report.Parameters.Add(Constants.REP_VISN_NETWORK_VISN_EXTENSION, loggedUser.Visn.Id.extension);
                    report.Parameters.Add(Constants.REP_REGION_EXTENSIONS, loggedUser.Visn.Region.Id.extension);
                    report.Parameters.Add(Constants.REP_VISN_EXTENSIONS, loggedUser.Visn.Id.extension);

                    report.Parameters.Add(Constants.REP_GENERAL_FACILITY_EXTENSION_TO_UPPER, loggedUser.Facility.Id.extension);
                    report.Parameters.Add(Constants.REP_IS_FACILITY, "1");

                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, Url.Action("Index", "SiteOptions"));
                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, "Return to Site Options");
                    report.Parameters.Add(Constants.REPORT_TITLE, Strings.ImageUsageReportTitle);
                    return Redirect(report.Url);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
