﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Utils;
using System.Configuration;

namespace BMS.Web.Controllers
{
    public class InformationController : BaseController
    {
        /// <summary>
        /// Main action of the controller.
        /// </summary>
        /// <returns>Returns the appropriate view result.</returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //get VA url from web.config
                string urlKey = ConfigurationManager.AppSettings[Constants.APP_SETTING_VA_URL];
                string[] split = urlKey.Split('/');
                if (split[2].EndsWith("DNS   "))
                {
                    return Redirect(urlKey);
                }
                return null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

    }
}
