﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Facade;
using System.Text;
using BMS.Web.App_GlobalResource;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class BedStatusReportController : BaseController
    {
        public ActionResult Index()
        {
            BedStatusReportViewModel model = new BedStatusReportViewModel();
            model.DisplayFieldsList = SetFieldsList();
            FillFilterList(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult Index([Bind(Exclude = "RememberMe")] BedStatusReportViewModel input)
        {
            if (input.ButtonSubmit != null)
                return Redirect(CreateReportParameters(input.DisplayFieldsList));
            else
            {
                FillFilterList(input);
                return View(input);
            }
        }

        private List<ReportFieldsViewModel> SetFieldsList()
        {
            List<ReportFieldsViewModel> result = new List<ReportFieldsViewModel>();
            result.Add(new ReportFieldsViewModel() { Id = 1, FieldName = Constants.PATIENT_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 2, FieldName = Constants.GENDER_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 3, FieldName = Constants.EVENT_TIME_FIELD, Order = null, FilterValue = DateTimeNowOnCurrentFacility.ToString(Strings.USDate), FilterValueSecond = "00", FilterThirdValue = "00", FilterFourthValue = DateTimeNowOnCurrentFacility.AddDays(1).ToString(Strings.USDate), FilterFifthValue = "00", FilterSixValue = "00" });
            result.Add(new ReportFieldsViewModel() { Id = 4, FieldName = Constants.REQUEST_DT_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 5, FieldName = Constants.REMOVE_FROM_LIST_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty, FilterSeventhValue = Strings.All, });
            result.Add(new ReportFieldsViewModel() { Id = 6, FieldName = Constants.CURRENT_WAIT_AREA_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 7, FieldName = Constants.RECORD_LAST_EDITED_BY_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 8, FieldName = Constants.COMMUNITY_SERVICES_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 9, FieldName = Constants.CONTRACTED_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 10, FieldName = Constants.REASON_USING_FEE_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 11, FieldName = Constants.ACUTE_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 12, FieldName = Constants.AUTHORIZED_FEE_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 13, FieldName = Constants.IN_HOUSE_TRANSFER_FIELD, Order = null, FilterValue = Strings.All, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 14, FieldName = Constants.DATE_TIME_BED_REQUEST_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 15, FieldName = Constants.DATE_TIME_BED_ASSIGNED_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 16, FieldName = Constants.FEE_COMMENTS_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 17, FieldName = Constants.ROOM_BED_ASSIGNED_FIELD, Order = null, FilterValue = (default(Guid)).ToString(), FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 18, FieldName = Constants.TYPE_OF_BED_WARD_REQUIRED_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });
            result.Add(new ReportFieldsViewModel() { Id = 19, FieldName = Constants.PRESENTING_PROBLEM_FIELD, Order = null, FilterValue = string.Empty, FilterValueSecond = string.Empty, FilterThirdValue = string.Empty, FilterFourthValue = string.Empty, FilterFifthValue = string.Empty, FilterSixValue = string.Empty });

            return result;
        }

        private void FillFilterList(BedStatusReportViewModel model)
        {
            model.OrderFieldsList = GetOrderList();
            model.GenderList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.Gender).ToList();
            model.WaitingAreaList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.WaitingArea).ToList();
            model.CommunityServicesList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.ServicesReceiving).ToList();
            model.ReasonUsingFeeList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.FeeReason).ToList();
            model.AcuteList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.FeeDisposition).ToList();
            model.ContractList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.StrictDecision).ToList();
            model.AuthorizedList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.StrictDecision).ToList();
            model.InHouseList = FacadeManager.VocabularyInterface.GetVocabulary(Util.Vocabulary.StrictDecision).ToList();
            model.WaitingAreaList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            model.CommunityServicesList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            model.ReasonUsingFeeList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            model.AcuteList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            model.ContractList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            model.AuthorizedList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            model.InHouseList.Add(new CD() { code = Strings.All, displayName = Strings.All });
            List<Division> divisions = FacadeManager.EntityInterface.GetDivisions(this.loggedUser.Facility.Id).ToList();
            model.BedList = new List<Bed>();
            foreach (Division division in divisions)
                model.BedList.AddRange(FacadeManager.EntityInterface.GetBedsInDivision(division.Id, loggedUser.VistaSite.Id));
            model.BedList.Add(new Bed() { Id = new II() { extension = (default(Guid)).ToString(), root = "" }, Name = Strings.All });
            model.LoggedUser = loggedUser;
        }

        private List<int?> GetOrderList()
        {
            return new List<int?>() { null, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 };
        }

        private string CreateReportParameters(List<ReportFieldsViewModel> inputList)
        {
            StringBuilder url = new StringBuilder();
            string patientNameFilter = string.Empty;
            string patientGenderFilter = string.Empty;
            url.Append("displayFields=");
            List<string> orderFieldNames = inputList.Where(a => a.Order != null).OrderBy(a => a.Order).Select(s => s.FieldName).ToList();
            foreach (string fieldName in orderFieldNames)
            {
                url.Append(fieldName);
                url.Append("*");
            }
            url.Remove(url.Length - 1, 1);
            url.Append("&filterFields=");
            AntiXssEncoder xss = new AntiXssEncoder();
            foreach (ReportFieldsViewModel obj in inputList)
            {
                switch (obj.FieldName)
                {
                    case Constants.REMOVE_FROM_LIST_FIELD:
                        url.Append(obj.FieldName);
                        url.Append("*");
                        if (string.IsNullOrEmpty(obj.FilterValue))
                        {
                            url.Append(string.Empty);
                        }
                        else
                        {
                            url.Append(obj.FilterValue);
                            url.Append(" ");
                            url.Append(obj.FilterValueSecond);
                            url.Append(":");
                            url.Append(obj.FilterThirdValue);
                        }
                        url.Append("*");
                        if (string.IsNullOrEmpty(obj.FilterFourthValue))
                        {
                            url.Append(string.Empty);
                        }
                        else
                        {
                            url.Append(obj.FilterFourthValue);
                            url.Append(" ");
                            url.Append(obj.FilterFifthValue);
                            url.Append(":");
                            url.Append(obj.FilterSixValue);
                        }
                        url.Append("*");
                        url.Append(obj.FilterSeventhValue);
                        url.Append("*");
                        break;
                    case Constants.EVENT_TIME_FIELD:
                    case Constants.REQUEST_DT_FIELD:
                    case Constants.DATE_TIME_BED_REQUEST_FIELD:
                    case Constants.DATE_TIME_BED_ASSIGNED_FIELD:
                        if (!string.IsNullOrEmpty(obj.FilterValue) && !string.IsNullOrEmpty(obj.FilterValueSecond) && !string.IsNullOrEmpty(obj.FilterThirdValue) &&
                            !string.IsNullOrEmpty(obj.FilterFourthValue) && !string.IsNullOrEmpty(obj.FilterFifthValue) && !string.IsNullOrEmpty(obj.FilterSixValue))
                        {
                            url.Append(obj.FieldName);
                            url.Append("*");
                            url.Append(obj.FilterValue);
                            url.Append(" ");
                            url.Append(obj.FilterValueSecond);
                            url.Append(":");
                            url.Append(obj.FilterThirdValue);
                            url.Append("*");
                            url.Append(obj.FilterFourthValue);
                            url.Append(" ");
                            url.Append(obj.FilterFifthValue);
                            url.Append(":");
                            url.Append(obj.FilterSixValue);
                            url.Append("*");
                            url.Append(obj.FilterSeventhValue);
                            url.Append("*");
                        }
                        break;
                    default:
                        if (obj.FilterValue != Strings.All && obj.FilterValue != default(Guid).ToString() && !string.IsNullOrWhiteSpace(obj.FilterValue))
                        {
                            if (obj.FieldName == Constants.PATIENT_FIELD)
                                patientNameFilter = xss.Encode(obj.FilterValue);
                            else if (obj.FieldName == Constants.GENDER_FIELD)
                                patientGenderFilter = obj.FilterValue;                            
                            else
                            {
                                url.Append(obj.FieldName);
                                url.Append("*");
                                if (obj.FieldName == Constants.FEE_COMMENTS_FIELD || obj.FieldName == Constants.TYPE_OF_BED_WARD_REQUIRED_FIELD || obj.FieldName == Constants.PRESENTING_PROBLEM_FIELD)
                                    url.Append(xss.Encode(obj.FilterValue));
                                else
                                    url.Append(obj.FilterValue);
                                url.Append("*");
                                if (!string.IsNullOrEmpty(obj.FilterValueSecond))
                                {
                                    url.Append(obj.FilterValueSecond);
                                    url.Append("*");
                                }
                            }
                        }
                        break;
                }
            }
            url.Remove(url.Length - 1, 1);
            url.Append("&filterPatientName=");
            url.Append(patientNameFilter);
            url.Append("&filterGender=");
            url.Append(patientGenderFilter);
            return "/Reporting/LocalReportViewer.aspx?" + CustomEncryption.Encrypt(url.ToString(), loggedUser.Salt) + "*bs";
        }        
    }
}
