﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.VistA;
using BMS.Utils;

namespace BMS.VistaIntegration.ShareSessions
{
    public class SessionFactory : ISessionFactory
    {
        public VistaSessionFactory MdwsSessionFactory { get; private set; }
        public VistaSessionFactory OdbcSessionFactory { get; private set; }

        public SessionFactory(ISessionFactory concreteSessionFactory)
        {
            this.MdwsSessionFactory = new VistaSessionFactory(concreteSessionFactory.MakeSession(DataRetrievalMethod.MDWS));
            this.OdbcSessionFactory = new VistaSessionFactory(concreteSessionFactory.MakeSession(DataRetrievalMethod.ODBC));
        }

        public IVistASessionFactory MakeSession(DataRetrievalMethod dataRetrivalMethod)
        {
            switch (dataRetrivalMethod)
            {
                case DataRetrievalMethod.MDWS:
                    return MdwsSessionFactory;
                case DataRetrievalMethod.ODBC:
                    return OdbcSessionFactory;
                default:
                    throw new InvalidOperationException("Unknown vista session factory for " + dataRetrivalMethod.ToString());
            }
        }
    }
}
