﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.LogCheckers;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.Security;
using BMS.ServicesWrapper.EVS;
using FC = BMS.Facade.Data;
using BMS.ServicesWrapper.BMService;
using BMS.Utils;
using BMS.VistaWorker2.Writer.Implementation.Concrete;
using BMS.DataContracts;
using VID = BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class EDISPatientAdmissionProcessor : MultipleEntryProcessor
    {
        public Parameter Parameter { get; private set; }
        public IVistAQuery Query { get; private set; }
        public EDISPatientAdmissionProcessor(IWriterManager writerManager, Parameter parameter, IVistAQuery query)
            : base(writerManager)
        {
            if (parameter.Type != VistaDataType.EDISPatientAdmission)
                throw new InvalidOperationException();
            Parameter = parameter;
            Query = query;
            InitEntriesProcessor(GetEntitiesProcessor());
        }

        ListEntryProcessor<T> GetEntitiesProcessor<T>(Func<IList<T>> fetchFunc, Comparison<T> comparison, Func<T, DateTime?> filterDateTimeFunc)
        {
            IList<T> list = fetchFunc();
            if (list != null && list.Count > 0)
                list = (from a in (list as List<VID.EDISPatientAdmission>) orderby long.Parse(a.IEN) select a).ToList() as List<T>;
            return new ListEntryProcessor<T>(WriterManager, list, filterDateTimeFunc);
        }

        public IVistaIntegrationLogChecker LogChecker { get; private set; }

        private IList<IEntryProcessor> GetEntitiesProcessor()
        {
            List<IEntryProcessor> result = new List<IEntryProcessor>();
            List<VistaIntegrationLog> logs = new List<VistaIntegrationLog>();

            ListEntryProcessor<VID.EDISPatientAdmission> s1 = null;
            
            if (Parameter.JobLaunchType == JobLaunchType.Automatic)
                s1 = GetEntitiesProcessor<VID.EDISPatientAdmission>(() => Query.GetEDISPatientAdmission(Parameter.StartDateParam, null), null, null);
            else
                s1 = GetEntitiesProcessor<VID.EDISPatientAdmission>(() => Query.GetEDISPatientAdmission(Parameter.StartDateParam, Parameter.EndDateParam), null, null);
            s1.Entries.ForEach(i => logs.Add(new VistaIntegrationLog() { File = VistaFiles.EDISPatientAdmission, Ien = i.IEN }));
            result.Add(s1);
            LogChecker = new HashSetLogChecker(logs, WriterManager.Site.Name);
            result.ForEach(s => s.InitLogCheck(LogChecker));
            return result;
        }        
    }
}
