﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.Concurrent;
using BMS.Utils;
using System.Configuration;
using System.Threading;

namespace BMS.VistaIntegration.Managers.Implementation
{
    public class Actor
    {
        private object LockThis = new object();
        private static readonly BmsLogger Logger = new BmsLogger("VistaIntegration Actor Message: ");        
        private Dictionary<VistaDataType, Task> _runningTasks = new Dictionary<VistaDataType, Task>();
        private Dictionary<VistaDataType, List<Task>> _waitingTasks = new Dictionary<VistaDataType, List<Task>>();
        private Dictionary<VistaDataType, Timer> _timers = new Dictionary<VistaDataType, Timer>();
        private int taskSchedulerDelayMin = int.Parse(ConfigurationManager.AppSettings["VistaIntegration.TaskSchedulerDelayMin"]);
        private int taskSchedulerDelayMax = int.Parse(ConfigurationManager.AppSettings["VistaIntegration.TaskSchedulerDelayMax"]);
        private int taskSchedulerDelayStep = int.Parse(ConfigurationManager.AppSettings["VistaIntegration.TaskSchedulerDelayStep"]);
        //private Random random = new Random();
        private CryptoRandom random = new CryptoRandom();

        public void ExecuteTask(Task task, VistaDataType dataType)
        {
            lock (LockThis)
            {
                Logger.LogInformation(DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss.fff tt") + " Actor.ExecuteTask() - " + this.GetHashCode().ToString());
                string keys = "";
                foreach (VistaDataType key in _runningTasks.Keys)
                    keys += key.ToString() + "***";
                Logger.LogInformation(DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss.fff tt") + " Actor.ExecuteTask()._runningTasks= " + keys);
                if (_runningTasks.ContainsKey(dataType))
                {
                    if (!_waitingTasks.ContainsKey(dataType))
                        _waitingTasks.Add(dataType, new List<Task>());
                    _waitingTasks[dataType].Add(task);
                }
                else
                {
                    _runningTasks.Add(dataType, task);
                    try
                    {
                        if (taskSchedulerDelayMax > taskSchedulerDelayMin)
                        {
                            int delay = random.Next(taskSchedulerDelayMin, taskSchedulerDelayMax + 1) * taskSchedulerDelayStep * 1000;
                            if (delay > 0)
                            {
                                _timers.Add(dataType, new Timer((state) => { Timer_OnCallback(dataType, task); }, null, delay, Timeout.Infinite));
                            }
                            else
                                task.Start();
                        }
                        else
                            task.Start();
                    }
                    catch (Exception e)
                    {
                        Logger.LogError(e.ToString());
                    }
                }                
            }            
        }

        private void Timer_OnCallback(VistaDataType dataType, Task task)
        {
            lock (LockThis)
            {
                if (_timers.ContainsKey(dataType))
                {
                    _timers[dataType].Dispose();
                    _timers.Remove(dataType);
                }
            }
            task.Start();
        }

        public VistaDataType EndExecuteTask(Task task)
        {
            lock (LockThis)
            {
                Logger.LogInformation(DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss.fff tt") + " Actor.EndExecuteTask() - " + this.GetHashCode().ToString());
                string keys = "";
                foreach (VistaDataType key in _runningTasks.Keys)
                    keys += key.ToString() + "***";
                Logger.LogInformation(DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss.fff tt") + " Actor.EndExecuteTask()._runningTasks before delete= " + keys);
                if (_runningTasks.ContainsValue(task))
                {
                    VistaDataType dataType = _runningTasks.Where(a => a.Value == task).FirstOrDefault().Key;
                    Logger.LogInformation(DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss.fff tt") + " Actor.EndExecuteTask()._dataType found= " + dataType.ToString());
                    _runningTasks.Remove(dataType);
                    if (_waitingTasks.ContainsKey(dataType))
                    {
                        Task t = _waitingTasks[dataType][0];
                        _waitingTasks[dataType].RemoveAt(0);
                        if (_waitingTasks[dataType].Count == 0)
                            _waitingTasks.Remove(dataType);
                        ExecuteTask(t, dataType);
                    }
                    keys = "";
                    foreach (VistaDataType key in _runningTasks.Keys)
                        keys += key.ToString() + "***";
                    Logger.LogInformation(DateTime.Now.ToString("MM/dd/yyyy hh:mm:ss.fff tt") + " Actor.EndExecuteTask()._runningTasks after delete= " + keys);
                    return dataType;
                }
                return VistaDataType.None;
            }
        }

        public void ClearTaskLists()
        {
            lock (LockThis)
            {
                Task.WaitAll(_runningTasks.Values.ToArray());
                _runningTasks.Values.ForEach(s => s.Dispose());
                _waitingTasks.Values.ForEach(s => s.ForEach(a => a.Dispose()));
                _runningTasks = new Dictionary<VistaDataType, Task>();
                _waitingTasks = new Dictionary<VistaDataType, List<Task>>();
            }
        }        
    }
}
