﻿using System;
using System.Collections.Generic;
using System.Configuration;
using BMS.VistaIntegration.Data;
using Mdws2ORM;
using Mdws2ORM.Core;

namespace BMS.VistaIntegration.Via.Commands.EntityCommands
{
    public abstract class BaseListPeriodCommand<T> : BaseListCommand<T> where T : class, IEntity
    {
        protected readonly DateTime MaxDate = DateTime.Today.AddDays(1);

        protected BaseListPeriodCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public DateTime? StartDate
        {
            get;
            set;
        }

        public DateTime? EndDate
        {
            get;
            set;
        }

        protected override bool IsFiltered
        {
            get
            {
                return this.StartDate.HasValue || this.EndDate.HasValue;
            }
        }

        protected static DateTime MinDate
        {
            get
            {
                return DateTime.Parse(ConfigurationManager.AppSettings["MinimumFilemanDate"]);
            }
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
            yield return this.MaxCount;
            yield return this.From;
        }
    }
}
