﻿using System;
using System.Linq;
using System.Collections.Generic;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;

namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class ListPatientMovementIensCommand : BaseListPeriodCommand<PatientMovementIen>
    {
        public ListPatientMovementIensCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public DateTime? MovementDate
        {
            get;
            set;
        }

        public DateTime? LastEditedDate
        {
            get;
            set;
        }

        protected override string GetTarget()
        {
            return "ListPatientMovement";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return string.Empty;
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
            yield return this.MovementDate;
            yield return this.LastEditedDate;
            yield return this.MaxCount;
            yield return string.IsNullOrEmpty(this.From) ? (this.StartDate.HasValue ? (object)this.StartDate.Value.AddDays(-1) : null) : (object)this.From;
        }
        protected override IDependencySource GetDependencySource()
        {
            return PatientMovementIenDependencySource.Instance;
        }
    }
    internal sealed class PatientMovementIenDependencySource : IDependencySource<PatientMovementIen>
    {
        private static IDependencySource instance;
        private PatientMovementIenDependencySource()
        {
        }
        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new PatientMovementIenDependencySource();
                }
                return instance;
            }
        }
        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield break;
        }
        public List<PatientMovementIen> PostProcessEntities(ViaVistAQuery query, List<PatientMovementIen> result)
        {
            return (from movement in result
                    let transaction = movement.TransactionTypeId.ParseDecimal()
                    where (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX) ||
                          (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX) ||
                          (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX) ||
                          (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX)
                    select movement).ToList();
        }
    }
}
