﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Utils;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class ListCancelOrdersCommand  : BaseListCommand<CancelOrder>
    {
        private string currentIens;

        public ListCancelOrdersCommand(ViaVistAQuery query)
            : base(query, false)
        {
        }

        public IEnumerable<string> Iens
        {
            get;
            set;
        }

        public override List<CancelOrder> Execute(ViaVistASession session)
        {
            var result = Enumerable.Empty<CancelOrder>();

            int count = 1000;
            int startIndex = 0;
            do
            {
                this.currentIens = String.Join(",", this.Iens.Skip(startIndex).Take(count).ToArray());
                result = result.Union(base.Execute(session));
                startIndex += count;
            }
            while (startIndex < this.Iens.Count());

            return result.ToList();
        }

        protected override string GetTarget()
        {
            return "ListCancelOrders";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.currentIens;
            yield return string.Empty;
        }

        protected override string TranslateValue(string fieldIen, string value)
        {
            this.Logger.LogFormat(Utils.BmsLogger.Level.Verbose, "Converting value '{1}' for field '{0}'", fieldIen, value);

            switch (fieldIen)
            {
                case ".02":
                case "6":
                    return value.Split(';').First();

                default:
                    return base.TranslateValue(fieldIen, value);
            }
        }
    }
}
