﻿using System;
using System.Collections.Generic;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;

namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class GetPatientMovementCommand : BaseListCommand<PatientMovement>
    {
        public GetPatientMovementCommand(ViaVistAQuery query)
            : base(query)
        {
            // Default values
            this.MovementType = MovementTransactionType.ADMISSION;
        }

        public string PatientIen
        {
            get;
            set;
        }

        public string Ien
        {
            get;
            set;
        }

        public DateTime? DateTime
        {
            get;
            set;
        }

        public MovementTransactionType MovementType
        {
            get;
            set;
        }

        protected override string GetTarget()
        {
            return "GetPatientMovement";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.Ien;                  // Movement IEN
            yield return (int)this.MovementType;    // Movement Type
            yield return this.PatientIen;           // Patient IEN
            yield return this.DateTime;             // Date
            yield return string.Empty;              // Empty
        }
        protected override IDependencySource GetDependencySource()
        {
            return PatientMovementDependencySource.Instance;
        }
    }
}
