﻿using System;
using System.Linq;
using System.Collections.Generic;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;
using Mdws2ORM;
using Mdws2ORM.Core;
using Mdws2ORM.Maps;
using BMS.VistaIntegration.Via.Commands.EIS;
using BMS.VistaIntegration.Via.Commands.EVS;


namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class GetEDISPatientAdmissionCommand : BaseListPeriodCommand<EDISPatientAdmission>
    {
        public GetEDISPatientAdmissionCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        protected override string GetTarget()
        {
            return "GetActivity";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
        }

        protected override IDependencySource GetDependencySource()
        {
            return EDISPatientAdmissionDependencySource.Instance;
        }
    }

    internal sealed class EDISPatientAdmissionDependencySource : IDependencySource
    {
        private static IDependencySource instance;

        private EDISPatientAdmissionDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new EDISPatientAdmissionDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<Patient>(ListPatientCommand.Target, ListPatientCommand.ArgumentsCount, ListPatientCommand.CheckIen, ".06");
        }
    }
}
