﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EntityCommands;
using BMS.VistaIntegration.Via.Commands.EVS;
using Mdws2ORM;

namespace BMS.VistaIntegration.Via.Commands.EIS
{
    public class ListPatientCommand : BaseListPeriodCommand<Patient>
    {
        public const string Target = "ListPatient";
        public const int ArgumentsCount = 5;

        public ListPatientCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public string VistaPatientIen
        {
            get;
            set;
        }

        protected override string GetTarget()
        {
            return Target;
        }

        protected override IDependencySource GetDependencySource()
        {
            return PatientDependencySource.Instance;
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.VistaPatientIen;
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
            yield return this.MaxCount;
            yield return this.From;
        }

        public static bool CheckIen(string ien)
        {
            // IENs of sensitive patient records are not in right format and VIA does not return data for them. We will have to filter them out.
            var parsedValue = 0.0;
            return double.TryParse(ien, out parsedValue);
        }

        public void ResetHasMore()
        {
            this.HasMore = true;
        }
    }

    internal sealed class PatientDependencySource : IDependencySource<Patient>
    {
        private static IDependencySource instance;

        private PatientDependencySource()
        {
        }

        public static IDependencySource Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new PatientDependencySource();
                }

                return instance;
            }
        }

        public IEnumerable<DependentEntityInfo> GetDependentTypes()
        {
            yield return new DependentEntityInfo<NewPerson>(ListNewPersonCommand.Target, ListNewPersonCommand.ArgumentsCount, ".1041");
            yield return new DependentEntityInfo<FacilityTreatingSpecialty>(ListFacilityTreatingSpecialtyCommand.Target, ListFacilityTreatingSpecialtyCommand.ArgumentsCount, ".103");
        }
        public List<Patient> PostProcessEntities(ViaVistAQuery query, List<Patient> result)
        {
            return result.Where(x => !string.IsNullOrWhiteSpace(x.SocialSecurityNumber) && !string.IsNullOrWhiteSpace(x.IEN) && !string.Equals(x.IEN, "0")).ToList();
        }
    }
}
