﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.WF
{
    public class OrderActionMap : SubEntityMapWithParent<OrderAction, Order>
    {
        public override void SetParent(OrderAction entity, Order parent)
        {
            entity.Order = parent;
            entity.OrderId = parent.IEN;
        }

        public override OrderAction NewEntity(string ien)
        {
            return new OrderAction();
        }

        public override string File
        {
            get { return "100.008"; }
        }

        protected override void MapFields()
        {
            MapDateTime(".01", (m, s) => m.DateTimeOrdered = s);
            MapDateTime("6", (m, s) => m.DateTimeSigned = s);
            MapDateTime("16", (m, s) => m.ReleaseDateTime = s);
            MapPointerToFile<NewPerson>("5", (m, s) => m.SignedById = s, (m, s) => m.SignedBy = s);
            MapPointerToFile<NewPerson>("3", (m, s) => m.ProviderId = s, (m, s) => m.Provider = s);
            MapWordProcessing(".1", (m, s) => m.OrderText = s);

            MapFreeText("666", (m, s) => m.OrderId = s);
        }
    }
}
